/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class RequireInstanceListener {
    private RequireInstanceListener() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processRequireInstanceEntry(TreeWalkListener listener, GeneratedYangParser.RequireInstanceStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.REQUIRE_INSTANCE_DATA, "", ListenerErrorLocation.ENTRY);
        Parsable curData = listener.getParsedDataStack().peek();
        boolean isRequireInstance = ListenerUtil.getValidBooleanValue(ctx.requireInstance().getText(), YangConstructType.REQUIRE_INSTANCE_DATA, ctx);
        if (curData instanceof YangLeafRef) {
            ((YangLeafRef)curData).setRequireInstance(isRequireInstance);
            return;
        } else {
            if (!(curData instanceof YangType)) throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.REQUIRE_INSTANCE_DATA, ctx.getText(), ListenerErrorLocation.ENTRY));
            if (((YangType)curData).getDataType() != YangDataTypes.INSTANCE_IDENTIFIER) throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.REQUIRE_INSTANCE_DATA, ctx.getText(), ListenerErrorLocation.ENTRY));
            ((YangType)curData).setDataTypeExtendedInfo(isRequireInstance);
        }
    }
}

