/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangRpc;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class OutputListener {
    private OutputListener() {
    }

    public static void processOutputEntry(TreeWalkListener listener, GeneratedYangParser.OutputStatementContext ctx) {
        YangOutput yangOutput;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.OUTPUT_DATA, "", ListenerErrorLocation.ENTRY);
        Parsable curData = listener.getParsedDataStack().peek();
        if (curData instanceof YangRpc) {
            yangOutput = YangDataModelFactory.getYangOutputNode(GeneratedLanguage.JAVA_GENERATION);
            yangOutput.setName("output");
            yangOutput.setLineNumber(ctx.getStart().getLine());
            yangOutput.setCharPosition(ctx.getStart().getCharPositionInLine());
            yangOutput.setFileName(listener.getFileName());
            YangNode curNode = (YangNode)((Object)curData);
            try {
                curNode.addChild(yangOutput);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.OUTPUT_DATA, "", ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.OUTPUT_DATA, "", ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(yangOutput);
    }

    public static void processOutputExit(TreeWalkListener listener, GeneratedYangParser.OutputStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.OUTPUT_DATA, "", ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangOutput)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.OUTPUT_DATA, "", ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }
}

