/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class LeafListListener {
    private LeafListListener() {
    }

    public static void processLeafListEntry(TreeWalkListener listener, GeneratedYangParser.LeafListStatementContext ctx) {
        Parsable tmpData;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.LEAF_LIST_DATA, ctx);
        LeafListListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, identifier, YangConstructType.LEAF_LIST_DATA);
        YangLeafList leafList = YangDataModelFactory.getYangLeafList(GeneratedLanguage.JAVA_GENERATION);
        leafList.setName(identifier);
        leafList.setLineNumber(line);
        leafList.setCharPosition(charPositionInLine);
        leafList.setFileName(listener.getFileName());
        if (ctx.configStatement().isEmpty()) {
            boolean parentConfig = ListenerValidation.getParentNodeConfig(listener);
            leafList.setConfig(parentConfig);
        }
        if (!((tmpData = listener.getParsedDataStack().peek()) instanceof YangLeavesHolder)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        YangLeavesHolder leavesHolder = (YangLeavesHolder)((Object)tmpData);
        leavesHolder.addLeafList(leafList);
        leafList.setContainedIn(leavesHolder);
        listener.getParsedDataStack().push(leafList);
    }

    public static void processLeafListExit(TreeWalkListener listener, GeneratedYangParser.LeafListStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangLeafList)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.LeafListStatementContext ctx) {
        ListenerValidation.validateCardinalityEqualsOne(ctx.typeStatement(), YangConstructType.TYPE_DATA, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText(), ctx);
        ListenerValidation.validateCardinalityMaxOne(ctx.unitsStatement(), YangConstructType.UNITS_DATA, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.configStatement(), YangConstructType.CONFIG_DATA, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.maxElementsStatement(), YangConstructType.MAX_ELEMENT_DATA, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.minElementsStatement(), YangConstructType.MIN_ELEMENT_DATA, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.LEAF_LIST_DATA, ctx.identifier().getText());
    }
}

