/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangIdentity;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class IdentityListener {
    private IdentityListener() {
    }

    public static void processIdentityEntry(TreeWalkListener listener, GeneratedYangParser.IdentityStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.IDENTITY_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.IDENTITY_DATA, ctx);
        YangIdentity identity = YangDataModelFactory.getYangIdentityNode(GeneratedLanguage.JAVA_GENERATION);
        identity.setName(identifier);
        identity.setLineNumber(ctx.getStart().getLine());
        identity.setCharPosition(ctx.getStart().getCharPositionInLine());
        identity.setFileName(listener.getFileName());
        Parsable curData = listener.getParsedDataStack().peek();
        if (curData instanceof YangModule || curData instanceof YangSubModule) {
            YangNode curNode = (YangNode)((Object)curData);
            try {
                curNode.addChild(identity);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.IDENTITY_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITY_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(identity);
    }

    public static void processIdentityExit(TreeWalkListener listener, GeneratedYangParser.IdentityStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.IDENTITY_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        Parsable parsableType = listener.getParsedDataStack().pop();
        if (!(parsableType instanceof YangIdentity)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITY_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
    }
}

