/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangContainer;
import org.onosproject.yang.compiler.datamodel.YangGrouping;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNotification;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class ContainerListener {
    private ContainerListener() {
    }

    public static void processContainerEntry(TreeWalkListener listener, GeneratedYangParser.ContainerStatementContext ctx) {
        Parsable curData;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.CONTAINER_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.CONTAINER_DATA, ctx);
        ContainerListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, identifier, YangConstructType.CONTAINER_DATA);
        YangContainer container = YangDataModelFactory.getYangContainerNode(GeneratedLanguage.JAVA_GENERATION);
        container.setName(identifier);
        container.setLineNumber(line);
        container.setCharPosition(charPositionInLine);
        container.setFileName(listener.getFileName());
        if (ctx.configStatement().isEmpty()) {
            boolean parentConfig = ListenerValidation.getParentNodeConfig(listener);
            container.setConfig(parentConfig);
        }
        if ((curData = listener.getParsedDataStack().peek()) instanceof YangModule || curData instanceof YangSubModule || curData instanceof YangContainer || curData instanceof YangList || curData instanceof YangCase || curData instanceof YangNotification || curData instanceof YangInput || curData instanceof YangOutput || curData instanceof YangAugment || curData instanceof YangGrouping) {
            YangNode curNode = (YangNode)((Object)curData);
            try {
                curNode.addChild(container);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.CONTAINER_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.CONTAINER_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(container);
    }

    public static void processContainerExit(TreeWalkListener listener, GeneratedYangParser.ContainerStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.CONTAINER_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        if (listener.getParsedDataStack().peek() instanceof YangContainer) {
            YangContainer yangContainer = (YangContainer)listener.getParsedDataStack().peek();
            try {
                yangContainer.validateDataOnExit();
            }
            catch (DataModelException e) {
                ParserException parserException = new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.CONTAINER_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT, e.getMessage()));
                parserException.setLine(ctx.getStart().getLine());
                parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                throw parserException;
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.CONTAINER_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.ContainerStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.presenceStatement(), YangConstructType.PRESENCE_DATA, YangConstructType.CONTAINER_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.configStatement(), YangConstructType.CONFIG_DATA, YangConstructType.CONTAINER_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.CONTAINER_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.CONTAINER_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.CONTAINER_DATA, ctx.identifier().getText());
    }
}

