/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangBelongsTo;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class BelongsToListener {
    private BelongsToListener() {
    }

    public static void processBelongsToEntry(TreeWalkListener listener, GeneratedYangParser.BelongstoStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BELONGS_TO_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.BELONGS_TO_DATA, ctx);
        YangBelongsTo belongstoNode = new YangBelongsTo();
        belongstoNode.setBelongsToModuleName(identifier);
        int errorLine = ctx.getStart().getLine();
        int errorPosition = ctx.getStart().getCharPositionInLine();
        belongstoNode.setLineNumber(errorLine);
        belongstoNode.setCharPosition(errorPosition);
        belongstoNode.setFileName(listener.getFileName());
        listener.getParsedDataStack().push(belongstoNode);
    }

    public static void processBelongsToExit(TreeWalkListener listener, GeneratedYangParser.BelongstoStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BELONGS_TO_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpBelongstoNode = listener.getParsedDataStack().peek();
        if (tmpBelongstoNode instanceof YangBelongsTo) {
            listener.getParsedDataStack().pop();
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BELONGS_TO_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
            Parsable tmpNode = listener.getParsedDataStack().peek();
            switch (tmpNode.getYangConstructType()) {
                case SUB_MODULE_DATA: {
                    YangSubModule subModule = (YangSubModule)tmpNode;
                    subModule.setBelongsTo((YangBelongsTo)tmpBelongstoNode);
                    subModule.setPrefix(subModule.getBelongsTo().getPrefix());
                    break;
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.BELONGS_TO_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.BELONGS_TO_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
    }
}

