/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils.builtindatatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Base64;
import java.util.ListIterator;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangUnion;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;

public final class ObjectProvider {
    private static final String E_DATATYPE = "Data type not supported.";
    private static final String E_NONEMPTY = "Value is of non Empty type";

    private ObjectProvider() {
    }

    public static Object getObject(YangType typeInfo, String leafValue, YangDataTypes dataType) throws IllegalArgumentException {
        YangDataTypes type = dataType != null ? dataType : typeInfo.getDataType();
        switch (type) {
            case INT8: {
                return Byte.parseByte(leafValue);
            }
            case UINT8: 
            case INT16: {
                return Short.parseShort(leafValue);
            }
            case UINT16: 
            case INT32: {
                return Integer.parseInt(leafValue);
            }
            case UINT32: 
            case INT64: {
                return Long.parseLong(leafValue);
            }
            case UINT64: {
                return new BigInteger(leafValue);
            }
            case EMPTY: {
                if (leafValue == null || leafValue.equals("")) {
                    return true;
                }
                throw new IllegalArgumentException(E_NONEMPTY);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(leafValue);
            }
            case BINARY: {
                byte[] data = Base64.getDecoder().decode(leafValue);
                String str = new String(data);
                return str;
            }
            case BITS: 
            case IDENTITYREF: 
            case ENUMERATION: 
            case STRING: {
                return leafValue;
            }
            case DECIMAL64: {
                return new BigDecimal(leafValue);
            }
            case LEAFREF: {
                YangType refType = ((YangLeafRef)typeInfo.getDataTypeExtendedInfo()).getEffectiveDataType();
                return ObjectProvider.getObject(refType, leafValue, refType.getDataType());
            }
            case DERIVED: {
                YangType<?> rt = ((YangDerivedInfo)typeInfo.getDataTypeExtendedInfo()).getReferredTypeDef().getTypeList().get(0);
                return ObjectProvider.getObject(rt, leafValue, ((YangDerivedInfo)typeInfo.getDataTypeExtendedInfo()).getEffectiveBuiltInType());
            }
            case UNION: {
                return ObjectProvider.parseUnionTypeInfo(typeInfo, leafValue);
            }
        }
        throw new IllegalArgumentException(E_DATATYPE);
    }

    private static Object parseUnionTypeInfo(YangType type, String leafValue) {
        ListIterator<YangType<?>> it = ((YangUnion)type.getDataTypeExtendedInfo()).getTypeList().listIterator();
        while (it.hasNext()) {
            YangType t = (YangType)it.next();
            try {
                return ObjectProvider.getObject(t, leafValue, t.getDataType());
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw new IllegalArgumentException("Invalid value of data");
    }
}

