/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ListIterator;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.YangDesc;
import org.onosproject.yang.compiler.datamodel.YangPatternRestriction;
import org.onosproject.yang.compiler.datamodel.YangRangeInterval;
import org.onosproject.yang.compiler.datamodel.YangRangeRestriction;
import org.onosproject.yang.compiler.datamodel.YangReference;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangUint64;

public class YangStringRestriction
extends DefaultLocationInfo
implements YangDesc,
YangReference,
Parsable,
Serializable {
    private static final long serialVersionUID = 8062016053L;
    private YangRangeRestriction<YangUint64> lengthRestriction;
    private YangPatternRestriction patternRestriction;
    private String reference;
    private String description;

    public YangRangeRestriction<YangUint64> getLengthRestriction() {
        return this.lengthRestriction;
    }

    public void setLengthRestriction(YangRangeRestriction<YangUint64> rest) {
        this.lengthRestriction = rest;
    }

    public YangPatternRestriction getPatternRestriction() {
        return this.patternRestriction;
    }

    void setPatternRestriction(YangPatternRestriction rest) {
        this.patternRestriction = rest;
    }

    public void addPattern(String newPattern) {
        if (this.patternRestriction == null) {
            this.patternRestriction = new YangPatternRestriction();
        }
        this.patternRestriction.addPattern(newPattern);
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String ref) {
        this.reference = ref;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.PATTERN_DATA;
    }

    boolean isValidStringOnLengthRestriction(String valueInString) {
        if (this.lengthRestriction == null || this.lengthRestriction.getAscendingRangeIntervals() == null || this.lengthRestriction.getAscendingRangeIntervals().isEmpty()) {
            return true;
        }
        ListIterator<YangRangeInterval<YangUint64>> rangeListIterator = this.lengthRestriction.getAscendingRangeIntervals().listIterator();
        boolean isMatched = false;
        while (rangeListIterator.hasNext()) {
            YangRangeInterval<YangUint64> rangeInterval = rangeListIterator.next();
            rangeInterval.setCharPosition(this.getCharPosition());
            rangeInterval.setLineNumber(this.getLineNumber());
            rangeInterval.setFileName(this.getFileName());
            BigInteger startValue = rangeInterval.getStartValue().getValue();
            BigInteger endValue = rangeInterval.getEndValue().getValue();
            if (valueInString.length() < startValue.intValue() || valueInString.length() > endValue.intValue()) continue;
            isMatched = true;
            break;
        }
        return isMatched;
    }

    boolean isValidStringOnPatternRestriction(String valueInString) {
        if (this.patternRestriction == null || this.patternRestriction.getPatternList().isEmpty()) {
            return true;
        }
        ListIterator<String> patternListIterator = this.patternRestriction.getPatternList().listIterator();
        boolean isMatched = false;
        while (patternListIterator.hasNext()) {
            if (!valueInString.matches(patternListIterator.next())) continue;
            isMatched = true;
            break;
        }
        return isMatched;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }
}

