/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtn.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.BridgeConfig;
import org.onosproject.net.behaviour.BridgeDescription;
import org.onosproject.net.behaviour.BridgeName;
import org.onosproject.net.behaviour.DefaultBridgeDescription;
import org.onosproject.net.behaviour.DefaultTunnelDescription;
import org.onosproject.net.behaviour.InterfaceConfig;
import org.onosproject.net.behaviour.TunnelDescription;
import org.onosproject.net.behaviour.TunnelEndPoints;
import org.onosproject.net.behaviour.TunnelKeys;
import org.onosproject.net.driver.DriverHandler;

public final class VtnConfig {
    public static final String DEFAULT_BRIDGE_NAME = "br-int";
    private static final String DEFAULT_TUNNEL = "vxlan-0.0.0.0";
    private static final Map<String, String> DEFAULT_TUNNEL_OPTIONS = new HashMap<String, String>(){
        {
            this.put("key", "flow");
            this.put("remote_ip", "flow");
            this.put("dst_port", "4790");
            this.put("in_nsi", "flow");
            this.put("in_nsp", "flow");
            this.put("out_nsi", "flow");
            this.put("out_nsp", "flow");
            this.put("in_nshc1", "flow");
            this.put("out_nshc1", "flow");
            this.put("in_nshc2", "flow");
            this.put("out_nshc2", "flow");
            this.put("in_nshc3", "flow");
            this.put("out_nshc3", "flow");
            this.put("in_nshc4", "flow");
            this.put("out_nshc4", "flow");
            this.put("exts", "gpe");
        }
    };

    private VtnConfig() {
    }

    public static void applyBridgeConfig(DriverHandler handler, String dpid, String exPortName) {
        BridgeConfig bridgeConfig = (BridgeConfig)handler.behaviour(BridgeConfig.class);
        BridgeDescription bridgeDesc = DefaultBridgeDescription.builder().name(DEFAULT_BRIDGE_NAME).failMode(BridgeDescription.FailMode.SECURE).datapathId(dpid).disableInBand().enableLocalController().build();
        bridgeConfig.addBridge(bridgeDesc);
        bridgeConfig.addPort(BridgeName.bridgeName((String)DEFAULT_BRIDGE_NAME), exPortName);
    }

    public static void applyTunnelConfig(DriverHandler handler, IpAddress srcIp) {
        DefaultAnnotations.Builder optionBuilder = DefaultAnnotations.builder();
        for (String key : DEFAULT_TUNNEL_OPTIONS.keySet()) {
            optionBuilder.set(key, DEFAULT_TUNNEL_OPTIONS.get(key));
        }
        InterfaceConfig interfaceConfig = (InterfaceConfig)handler.behaviour(InterfaceConfig.class);
        TunnelDescription tunnel = DefaultTunnelDescription.builder().deviceId(DEFAULT_BRIDGE_NAME).ifaceName(DEFAULT_TUNNEL).type(TunnelDescription.Type.VXLAN).local(TunnelEndPoints.ipTunnelEndpoint((IpAddress)srcIp)).remote(TunnelEndPoints.flowTunnelEndpoint()).key(TunnelKeys.flowTunnelKey()).otherConfigs((SparseAnnotations)optionBuilder.build()).build();
        interfaceConfig.addTunnelMode(DEFAULT_TUNNEL, tunnel);
    }

    public static void removeTunnelConfig(DriverHandler handler) {
        InterfaceConfig interfaceConfig = (InterfaceConfig)handler.behaviour(InterfaceConfig.class);
        interfaceConfig.removeTunnelMode(DEFAULT_TUNNEL);
    }

    public static Set<PortNumber> getPortNumbers(DriverHandler handler) {
        BridgeConfig bridgeConfig = (BridgeConfig)handler.behaviour(BridgeConfig.class);
        return bridgeConfig.getPortNumbers();
    }
}

