/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtn.table.impl;

import com.google.common.base.Preconditions;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.vtn.table.SnatService;
import org.onosproject.vtnrsc.SegmentationId;

public class SnatServiceImpl
implements SnatService {
    private static final int SNAT_SAME_SEG_PRIORITY = 65535;
    private static final int SNAT_SAME_SEG_CON_PRIORITY = 65520;
    private static final int SNAT_DIFF_SEG_PRIORITY = 65504;
    private static final int PREFIC_LENGTH = 32;
    private final FlowObjectiveService flowObjectiveService;
    private final ApplicationId appId;

    public SnatServiceImpl(ApplicationId appId) {
        this.appId = (ApplicationId)Preconditions.checkNotNull((Object)appId, (Object)"ApplicationId can not be null");
        DefaultServiceDirectory serviceDirectory = new DefaultServiceDirectory();
        this.flowObjectiveService = (FlowObjectiveService)serviceDirectory.get(FlowObjectiveService.class);
    }

    @Override
    public void programSnatSameSegmentRules(DeviceId deviceId, SegmentationId matchVni, IpAddress srcIP, IpAddress dstIP, MacAddress ethDst, MacAddress ethSrc, IpAddress ipSrc, SegmentationId actionVni, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchTunnelId(Long.parseLong(matchVni.segmentationId())).matchIPSrc(IpPrefix.valueOf((IpAddress)srcIP, (int)32)).matchIPDst(IpPrefix.valueOf((IpAddress)dstIP, (int)32)).build();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.setEthDst(ethDst).setEthSrc(ethSrc).setIpSrc(ipSrc).setTunnelId(Long.parseLong(actionVni.segmentationId()));
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment.build()).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    @Override
    public void programSnatDiffSegmentRules(DeviceId deviceId, SegmentationId matchVni, IpAddress srcIP, MacAddress ethDst, MacAddress ethSrc, IpAddress ipSrc, SegmentationId actionVni, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchTunnelId(Long.parseLong(matchVni.segmentationId())).matchIPSrc(IpPrefix.valueOf((IpAddress)srcIP, (int)32)).build();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.setEthDst(ethDst).setEthSrc(ethSrc).setIpSrc(ipSrc).setTunnelId(Long.parseLong(actionVni.segmentationId()));
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment.build()).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65504);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    @Override
    public void programSnatSameSegmentUploadControllerRules(DeviceId deviceId, SegmentationId matchVni, IpAddress srcIP, IpAddress dstIP, IpPrefix prefix, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchTunnelId(Long.parseLong(matchVni.segmentationId())).matchIPSrc(IpPrefix.valueOf((IpAddress)srcIP, (int)32)).matchIPDst(IpPrefix.valueOf((IpAddress)dstIP, (int)prefix.prefixLength())).build();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.add((Instruction)Instructions.createOutput((PortNumber)PortNumber.CONTROLLER));
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment.build()).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65520);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    @Override
    public void removeSnatRules(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, Objective.Operation type) {
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(priority);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }
}

