/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtn.table.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.ExtensionTreatmentResolver;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.vtn.table.L2ForwardService;
import org.onosproject.vtnrsc.SegmentationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2ForwardServiceImpl
implements L2ForwardService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int MAC_PRIORITY = 65535;
    public static final Integer GROUP_ID = 1;
    private final FlowObjectiveService flowObjectiveService;
    private final ApplicationId appId;
    private final DriverService driverService;

    public L2ForwardServiceImpl(ApplicationId appId) {
        this.appId = (ApplicationId)Preconditions.checkNotNull((Object)appId, (Object)"ApplicationId can not be null");
        DefaultServiceDirectory serviceDirectory = new DefaultServiceDirectory();
        this.flowObjectiveService = (FlowObjectiveService)serviceDirectory.get(FlowObjectiveService.class);
        this.driverService = (DriverService)serviceDirectory.get(DriverService.class);
    }

    @Override
    public void programLocalBcastRules(DeviceId deviceId, SegmentationId segmentationId, PortNumber inPort, Iterable<PortNumber> localVmPorts, Iterable<PortNumber> localTunnelPorts, Objective.Operation type) {
        if (localVmPorts == null || localTunnelPorts == null) {
            this.log.info("No other host port and tunnel in the device");
            return;
        }
        Sets.newHashSet(localVmPorts).forEach(lp -> {
            TrafficSelector selector = DefaultTrafficSelector.builder().matchInPort(lp).matchEthDst(MacAddress.BROADCAST).add(Criteria.matchTunnelId((long)Long.parseLong(segmentationId.toString()))).build();
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            boolean flag = false;
            for (PortNumber outPort : localVmPorts) {
                flag = true;
                if (outPort == lp) continue;
                treatment.setOutput(outPort);
            }
            if (type == Objective.Operation.REMOVE && inPort.equals(lp)) {
                flag = false;
            }
            treatment.group(new GroupId(GROUP_ID.intValue()));
            DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment.build()).withSelector(selector).fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
            if (flag) {
                this.flowObjectiveService.forward(deviceId, objective.add());
            } else {
                this.flowObjectiveService.forward(deviceId, objective.remove());
            }
        });
    }

    @Override
    public void programTunnelBcastRules(DeviceId deviceId, SegmentationId segmentationId, Iterable<PortNumber> localVmPorts, Iterable<PortNumber> localTunnelPorts, Objective.Operation type) {
        if (localVmPorts == null || localTunnelPorts == null) {
            this.log.info("No other host port or tunnel ports in the device");
            return;
        }
        Sets.newHashSet(localTunnelPorts).forEach(tp -> {
            TrafficSelector selector = DefaultTrafficSelector.builder().matchInPort(tp).add(Criteria.matchTunnelId((long)Long.parseLong(segmentationId.toString()))).matchEthDst(MacAddress.BROADCAST).build();
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            for (PortNumber outPort : localVmPorts) {
                treatment.setOutput(outPort);
            }
            DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment.build()).withSelector(selector).fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
            if (type.equals((Object)Objective.Operation.ADD)) {
                if (Sets.newHashSet((Iterable)localVmPorts).isEmpty()) {
                    this.flowObjectiveService.forward(deviceId, objective.remove());
                } else {
                    this.flowObjectiveService.forward(deviceId, objective.add());
                }
            } else {
                this.flowObjectiveService.forward(deviceId, objective.remove());
            }
        });
    }

    @Override
    public void programLocalOut(DeviceId deviceId, SegmentationId segmentationId, PortNumber outPort, MacAddress sourceMac, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchTunnelId(Long.parseLong(segmentationId.toString())).matchEthDst(sourceMac).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(outPort).build();
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    @Override
    public void programExternalOut(DeviceId deviceId, SegmentationId segmentationId, PortNumber outPort, MacAddress sourceMac, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchTunnelId(Long.parseLong(segmentationId.toString())).matchEthSrc(sourceMac).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(outPort).build();
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    @Override
    public void programTunnelOut(DeviceId deviceId, SegmentationId segmentationId, PortNumber tunnelOutPort, MacAddress dstMac, Objective.Operation type, IpAddress ipAddress) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthDst(dstMac).add(Criteria.matchTunnelId((long)Long.parseLong(segmentationId.toString()))).build();
        DriverHandler handler = this.driverService.createHandler(deviceId, new String[0]);
        ExtensionTreatmentResolver resolver = (ExtensionTreatmentResolver)handler.behaviour(ExtensionTreatmentResolver.class);
        ExtensionTreatment treatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type());
        try {
            treatment.setPropertyValue("tunnelDst", (Object)Ip4Address.valueOf((String)ipAddress.toString()));
        }
        catch (Exception e) {
            this.log.error("Failed to get extension instruction to set tunnel dst {}", (Object)deviceId);
        }
        TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
        builder.extension(treatment, deviceId).setOutput(tunnelOutPort).build();
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(builder.build()).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }
}

