/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtn.table.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.vtn.table.ClassifierService;
import org.onosproject.vtnrsc.SegmentationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassifierServiceImpl
implements ClassifierService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final EthType.EtherType ETH_TYPE = EthType.EtherType.ARP;
    private static final int ARP_CLASSIFIER_PRIORITY = 60000;
    private static final int L3_CLASSIFIER_PRIORITY = 65535;
    private static final int L2_CLASSIFIER_PRIORITY = 50000;
    private static final int USERDATA_CLASSIFIER_PRIORITY = 65535;
    private final FlowObjectiveService flowObjectiveService;
    private final ApplicationId appId;

    public ClassifierServiceImpl(ApplicationId appId) {
        this.appId = (ApplicationId)Preconditions.checkNotNull((Object)appId, (Object)"ApplicationId can not be null");
        DefaultServiceDirectory serviceDirectory = new DefaultServiceDirectory();
        this.flowObjectiveService = (FlowObjectiveService)serviceDirectory.get(FlowObjectiveService.class);
    }

    @Override
    public void programLocalIn(DeviceId deviceId, SegmentationId segmentationId, PortNumber inPort, MacAddress srcMac, ApplicationId appid, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchInPort(inPort).matchEthSrc(srcMac).build();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.add((Instruction)Instructions.modTunnelId((long)Long.parseLong(segmentationId.toString())));
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment.build()).withSelector(selector).fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(50000);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.log.debug("programLocalIn-->ADD");
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.log.debug("programLocalIn-->REMOVE");
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    @Override
    public void programTunnelIn(DeviceId deviceId, SegmentationId segmentationId, Iterable<PortNumber> localTunnelPorts, Objective.Operation type) {
        if (localTunnelPorts == null) {
            this.log.info("No tunnel port in device");
            return;
        }
        Sets.newHashSet(localTunnelPorts).forEach(tp -> {
            TrafficSelector selector = DefaultTrafficSelector.builder().matchInPort(tp).add(Criteria.matchTunnelId((long)Long.parseLong(segmentationId.toString()))).build();
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().build();
            DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment).withSelector(selector).fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(50000);
            if (type.equals((Object)Objective.Operation.ADD)) {
                this.log.debug("programTunnelIn-->ADD");
                this.flowObjectiveService.forward(deviceId, objective.add());
            } else {
                this.log.debug("programTunnelIn-->REMOVE");
                this.flowObjectiveService.forward(deviceId, objective.remove());
            }
        });
    }

    @Override
    public void programL3ExPortClassifierRules(DeviceId deviceId, PortNumber inPort, IpAddress dstIp, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchInPort(inPort).matchIPDst(IpPrefix.valueOf((IpAddress)dstIp, (int)32)).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().build();
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.log.debug("L3ExToInClassifierRules-->ADD");
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.log.debug("L3ExToInClassifierRules-->REMOVE");
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    @Override
    public void programL3InPortClassifierRules(DeviceId deviceId, PortNumber inPort, MacAddress srcMac, MacAddress dstMac, SegmentationId actionVni, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchInPort(inPort).matchEthSrc(srcMac).matchEthDst(dstMac).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setTunnelId(Long.parseLong(actionVni.segmentationId())).build();
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.log.debug("L3InternalClassifierRules-->ADD");
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.log.debug("L3InternalClassifierRules-->REMOVE");
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    @Override
    public void programArpClassifierRules(DeviceId deviceId, IpAddress dstIp, SegmentationId actionVni, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(ETH_TYPE.ethType().toShort()).matchArpTpa(Ip4Address.valueOf((String)dstIp.toString())).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setTunnelId(Long.parseLong(actionVni.segmentationId())).build();
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(60000);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.log.debug("ArpClassifierRules-->ADD");
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.log.debug("ArpClassifierRules-->REMOVE");
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    @Override
    public void programArpClassifierRules(DeviceId deviceId, PortNumber inPort, IpAddress dstIp, SegmentationId actionVni, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchInPort(inPort).matchEthType(ETH_TYPE.ethType().toShort()).matchArpTpa(Ip4Address.valueOf((String)dstIp.toString())).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setTunnelId(Long.parseLong(actionVni.segmentationId())).build();
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(60000);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.log.debug("ArpClassifierRules-->ADD");
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.log.debug("ArpClassifierRules-->REMOVE");
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    @Override
    public void programUserdataClassifierRules(DeviceId deviceId, IpPrefix ipPrefix, IpAddress dstIp, MacAddress dstmac, SegmentationId actionVni, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPSrc(ipPrefix).matchIPDst(IpPrefix.valueOf((IpAddress)dstIp, (int)32)).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setTunnelId(Long.parseLong(actionVni.segmentationId())).setEthDst(dstmac).build();
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.log.debug("UserdataClassifierRules-->ADD");
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.log.debug("UserdataClassifierRules-->REMOVE");
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    @Override
    public void programExportPortArpClassifierRules(Port exportPort, DeviceId deviceId, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(EthType.EtherType.ARP.ethType().toShort()).matchInPort(exportPort.number()).build();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.add((Instruction)Instructions.createOutput((PortNumber)PortNumber.CONTROLLER));
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment.build()).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }
}

