/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.cli;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.EncapsulationType;
import org.onosproject.vpls.api.Vpls;
import org.onosproject.vpls.api.VplsData;
import org.onosproject.vpls.cli.VplsCommandEnum;

@Command(scope="onos", name="vpls", description="Manages the VPLS application")
public class VplsCommand
extends AbstractShellCommand {
    private static final Set<VplsData.VplsState> CHANGING_STATE = ImmutableSet.of((Object)((Object)VplsData.VplsState.ADDING), (Object)((Object)VplsData.VplsState.REMOVING), (Object)((Object)VplsData.VplsState.UPDATING));
    private static final String BOLD = "\u001b[1m";
    private static final String COLOR_ERROR = "\u001b[31m";
    private static final String RESET = "\u001b[0m";
    private static final String ENCAP_NOT_FOUND = "\u001b[31mEncapsulation type \u001b[1m%s\u001b[0m\u001b[31m not found\u001b[0m";
    private static final String IFACE_NOT_FOUND = "\u001b[31mInterface \u001b[1m%s\u001b[0m\u001b[31m not found\u001b[0m";
    private static final String IFACE_ALREADY_ASSOCIATED = "\u001b[31mInterface \u001b[1m%s\u001b[0m\u001b[31m already associated to VPLS \u001b[1m%s\u001b[0m\u001b[31m\u001b[0m";
    private static final String INSERT_VPLS_NAME = "\u001b[31mMissing the \u001b[1mVPLS name.\u001b[0m\u001b[31m Specifying a VPLS name is mandatory.\u001b[0m";
    private static final String INSERT_ENCAP_TYPE = "\u001b[31mMissing the \u001b[1mencapsulation type.\u001b[0m\u001b[31m Encapsulation type is mandatory.\u001b[0m";
    private static final String INSERT_INTERFACE = "\u001b[31mMissing the \u001b[1minterface name.\u001b[0m\u001b[31m Specifying an interface name is mandatory.\u001b[0m";
    private static final String SEPARATOR = "----------------";
    private static final String VPLS_ALREADY_EXISTS = "\u001b[31mVPLS \u001b[1m%s\u001b[0m\u001b[31m already exists\u001b[0m";
    private static final String VPLS_COMMAND_NOT_FOUND = "\u001b[31mVPLS command \u001b[1m%s\u001b[0m\u001b[31m not found\u001b[0m";
    private static final String VPLS_DISPLAY = "VPLS name: \u001b[1m%s\u001b[0m\nAssociated interfaces: %s\nEncapsulation: %s\nState: %s";
    private static final String VPLS_NOT_FOUND = "\u001b[31mVPLS \u001b[1m%s\u001b[0m\u001b[31m not found\u001b[0m";
    private static final String IFACE_NOT_ASSOCIATED = "\u001b[31mInterface \u001b[1m%s\u001b[0m\u001b[31m cannot be removed from VPLS \u001b[1m%s\u001b[0m.";
    protected static Vpls vpls;
    protected static InterfaceService interfaceService;
    @Argument(index=0, name="command", description="Command name (add-if|create|delete|list|rem-if|set-encap|show)", required=true, multiValued=false)
    String command = null;
    @Argument(index=1, name="vplsName", description="The name of the VPLS", required=false, multiValued=false)
    String vplsName = null;
    @Argument(index=2, name="optArg", description="The interface name or the encapsulation type for set-encap", required=false, multiValued=false)
    String optArg = null;

    protected void execute() {
        VplsCommandEnum enumCommand;
        if (vpls == null) {
            vpls = (Vpls)VplsCommand.get(Vpls.class);
        }
        if (interfaceService == null) {
            interfaceService = (InterfaceService)VplsCommand.get(InterfaceService.class);
        }
        if ((enumCommand = VplsCommandEnum.enumFromString(this.command)) != null) {
            switch (enumCommand) {
                case ADD_IFACE: {
                    this.addIface(this.vplsName, this.optArg);
                    break;
                }
                case CREATE: {
                    this.create(this.vplsName);
                    break;
                }
                case DELETE: {
                    this.delete(this.vplsName);
                    break;
                }
                case LIST: {
                    this.list();
                    break;
                }
                case REMOVE_IFACE: {
                    this.removeIface(this.vplsName, this.optArg);
                    break;
                }
                case SET_ENCAP: {
                    this.setEncap(this.vplsName, this.optArg);
                    break;
                }
                case SHOW: {
                    this.show(this.vplsName);
                    break;
                }
                case CLEAN: {
                    this.cleanVpls();
                    break;
                }
                default: {
                    this.print(VPLS_COMMAND_NOT_FOUND, new Object[]{this.command});
                    break;
                }
            }
        } else {
            this.print(VPLS_COMMAND_NOT_FOUND, new Object[]{this.command});
        }
    }

    protected void addIface(String vplsName, String ifaceName) {
        if (vplsName == null) {
            this.print(INSERT_VPLS_NAME, new Object[0]);
            return;
        }
        if (ifaceName == null) {
            this.print(INSERT_INTERFACE, new Object[0]);
            return;
        }
        Interface iface = this.getInterface(ifaceName);
        VplsData vplsData = vpls.getVpls(vplsName);
        if (vplsData == null) {
            this.print(VPLS_NOT_FOUND, new Object[]{vplsName});
            return;
        }
        if (CHANGING_STATE.contains((Object)vplsData.state())) {
            this.print("VPLS %s still updating, please wait it finished", new Object[]{vplsData.name()});
            return;
        }
        if (iface == null) {
            this.print(IFACE_NOT_FOUND, new Object[]{ifaceName});
            return;
        }
        if (VplsCommand.isIfaceAssociated(iface)) {
            this.print(IFACE_ALREADY_ASSOCIATED, new Object[]{ifaceName, this.getVplsByInterface(iface).name()});
            return;
        }
        vpls.addInterface(vplsData, iface);
    }

    protected void create(String vplsName) {
        if (vplsName == null || vplsName.isEmpty()) {
            this.print(INSERT_VPLS_NAME, new Object[0]);
            return;
        }
        VplsData vplsData = vpls.getVpls(vplsName);
        if (vplsData != null) {
            this.print(VPLS_ALREADY_EXISTS, new Object[]{vplsName});
            return;
        }
        vpls.createVpls(vplsName, EncapsulationType.NONE);
    }

    protected void delete(String vplsName) {
        if (vplsName == null) {
            this.print(INSERT_VPLS_NAME, new Object[0]);
            return;
        }
        VplsData vplsData = vpls.getVpls(vplsName);
        if (vplsData == null) {
            this.print(VPLS_NOT_FOUND, new Object[]{vplsName});
            return;
        }
        if (CHANGING_STATE.contains((Object)vplsData.state())) {
            this.print("VPLS %s still updating, please wait it finished", new Object[]{vplsData.name()});
            return;
        }
        vpls.removeVpls(vplsData);
    }

    protected void list() {
        List<String> vplsNames = VplsCommand.vpls.getAllVpls().stream().map(VplsData::name).collect(Collectors.toList());
        Collections.sort(vplsNames);
        vplsNames.forEach(vpls -> this.print((String)vpls, new Object[0]));
    }

    protected void removeIface(String vplsName, String ifaceName) {
        if (vplsName == null) {
            this.print(INSERT_VPLS_NAME, new Object[0]);
            return;
        }
        if (ifaceName == null) {
            this.print(INSERT_INTERFACE, new Object[0]);
            return;
        }
        VplsData vplsData = vpls.getVpls(vplsName);
        Interface iface = this.getInterface(ifaceName);
        if (vplsData == null) {
            this.print(VPLS_NOT_FOUND, new Object[]{vplsName});
            return;
        }
        if (CHANGING_STATE.contains((Object)vplsData.state())) {
            this.print("VPLS %s still updating, please wait it finished", new Object[]{vplsData.name()});
            return;
        }
        if (iface == null) {
            this.print(IFACE_NOT_FOUND, new Object[]{ifaceName});
            return;
        }
        if (!vplsData.interfaces().contains(iface)) {
            this.print(IFACE_NOT_ASSOCIATED, new Object[]{ifaceName, vplsName});
            return;
        }
        vpls.removeInterface(vplsData, iface);
    }

    protected void setEncap(String vplsName, String encap) {
        if (vplsName == null) {
            this.print(INSERT_VPLS_NAME, new Object[0]);
            return;
        }
        if (encap == null) {
            this.print(INSERT_ENCAP_TYPE, new Object[0]);
            return;
        }
        VplsData vplsData = vpls.getVpls(vplsName);
        if (vplsData == null) {
            this.print(VPLS_NOT_FOUND, new Object[]{vplsName});
            return;
        }
        EncapsulationType encapType = EncapsulationType.enumFromString((String)encap);
        if (encapType.equals((Object)EncapsulationType.NONE) && !encapType.toString().equals(encap)) {
            this.print(ENCAP_NOT_FOUND, new Object[]{encap});
            return;
        }
        vpls.setEncapsulationType(vplsData, encapType);
    }

    protected void show(String vplsName) {
        if (!Strings.isNullOrEmpty((String)vplsName)) {
            VplsData vplsData2 = vpls.getVpls(vplsName);
            if (vplsData2 != null) {
                Set ifaceNames = vplsData2.interfaces().stream().map(Interface::name).collect(Collectors.toSet());
                this.print(VPLS_DISPLAY, new Object[]{vplsName, ifaceNames, vplsData2.encapsulationType().toString(), vplsData2.state()});
            } else {
                this.print(VPLS_NOT_FOUND, new Object[]{vplsName});
            }
        } else {
            Collection<VplsData> vplses = vpls.getAllVpls();
            this.print(SEPARATOR, new Object[0]);
            vplses.forEach(vplsData -> {
                Set ifaceNames = vplsData.interfaces().stream().map(Interface::name).collect(Collectors.toSet());
                this.print(VPLS_DISPLAY, new Object[]{vplsData.name(), ifaceNames, vplsData.encapsulationType().toString(), vplsData.state()});
                this.print(SEPARATOR, new Object[0]);
            });
        }
    }

    protected void cleanVpls() {
        vpls.removeAllVpls();
    }

    private static boolean isIfaceAssociated(Interface iface) {
        return vpls.getAllVpls().stream().map(VplsData::interfaces).flatMap(Collection::stream).anyMatch(arg_0 -> ((Interface)iface).equals(arg_0));
    }

    private Interface getInterface(String interfaceName) {
        return interfaceService.getInterfaces().stream().filter(iface -> iface.name().equals(interfaceName)).findFirst().orElse(null);
    }

    private VplsData getVplsByInterface(Interface iface) {
        return vpls.getAllVpls().stream().filter(vplsData -> vplsData.interfaces().contains(iface)).findFirst().orElse(null);
    }
}

