/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.net.EncapsulationType;

public final class VplsData {
    private String name;
    private Set<Interface> interfaces;
    private EncapsulationType encapsulationType;
    private VplsState state;

    private VplsData(String name, EncapsulationType encapType) {
        this.name = name;
        this.encapsulationType = encapType;
        this.interfaces = Sets.newHashSet();
        this.state = VplsState.ADDING;
    }

    public static VplsData of(String name) {
        Objects.requireNonNull(name);
        return new VplsData(name, EncapsulationType.NONE);
    }

    public static VplsData of(String name, EncapsulationType encapType) {
        Objects.requireNonNull(name);
        if (encapType == null) {
            return new VplsData(name, EncapsulationType.NONE);
        }
        return new VplsData(name, encapType);
    }

    public static VplsData of(VplsData vplsData) {
        Objects.requireNonNull(vplsData);
        VplsData vplsDataCopy = new VplsData(vplsData.name(), vplsData.encapsulationType());
        vplsDataCopy.state(vplsData.state());
        vplsDataCopy.addInterfaces(vplsData.interfaces());
        return vplsData;
    }

    public String name() {
        return this.name;
    }

    public Set<Interface> interfaces() {
        return ImmutableSet.copyOf(this.interfaces);
    }

    public EncapsulationType encapsulationType() {
        return this.encapsulationType;
    }

    public void addInterfaces(Collection<Interface> interfaces) {
        Objects.requireNonNull(interfaces);
        this.interfaces.addAll(interfaces);
    }

    public void addInterface(Interface iface) {
        Objects.requireNonNull(iface);
        this.interfaces.add(iface);
    }

    public void removeInterfaces(Collection<Interface> interfaces) {
        Objects.requireNonNull(interfaces);
        this.interfaces.removeAll(interfaces);
    }

    public void removeInterface(Interface iface) {
        Objects.requireNonNull(iface);
        this.interfaces.remove(iface);
    }

    public void encapsulationType(EncapsulationType encapType) {
        this.encapsulationType = encapType;
    }

    public VplsState state() {
        return this.state;
    }

    public void state(VplsState state) {
        this.state = state;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("interfaces", this.interfaces).add("encap type", (Object)this.encapsulationType).add("state", (Object)this.state).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VplsData)) {
            return false;
        }
        VplsData other = (VplsData)obj;
        return Objects.equals(other.name, this.name) && Objects.equals(other.interfaces, this.interfaces) && Objects.equals(other.encapsulationType, this.encapsulationType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.interfaces, this.encapsulationType);
    }

    public static enum VplsState {
        UPDATING,
        ADDING,
        REMOVING,
        ADDED,
        REMOVED,
        FAILED;

    }
}

