/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.incubator.net.neighbour.NeighbourMessageHandler;
import org.onosproject.incubator.net.neighbour.NeighbourResolutionService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.host.HostService;
import org.onosproject.vpls.api.VplsData;
import org.onosproject.vpls.api.VplsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class VplsNeighbourHandler {
    private static final String UNKNOWN_CONTEXT = "Unknown context type: {}";
    private static final String CAN_NOT_FIND_VPLS = "Cannot find VPLS for port {} with VLAN Id {}.";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NeighbourResolutionService neighbourService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VplsStore vplsStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    private VplsInterfaceListener interfaceListener = new VplsInterfaceListener();
    protected VplsNeighbourMessageHandler neighbourHandler = new VplsNeighbourMessageHandler();
    protected VplsConfigListener configListener = new VplsConfigListener();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationId appId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.vpls");
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.configService.addListener((EventListener)this.configListener);
        this.configNeighbourHandler();
    }

    @Deactivate
    protected void deactivate() {
        this.interfaceService.removeListener((EventListener)this.interfaceListener);
        this.configService.removeListener((EventListener)this.configListener);
        this.neighbourService.unregisterNeighbourHandlers(this.appId);
    }

    protected void configNeighbourHandler() {
        this.neighbourService.unregisterNeighbourHandlers(this.appId);
        this.interfaceService.getInterfaces().forEach(intf -> this.neighbourService.registerNeighbourHandler(intf, (NeighbourMessageHandler)this.neighbourHandler, this.appId));
    }

    protected void handleRequest(NeighbourMessageContext context) {
        VplsData vplsData = this.findVpls(context);
        if (vplsData != null) {
            vplsData.interfaces().stream().filter(intf -> !context.inPort().equals((Object)intf.connectPoint())).forEach(arg_0 -> ((NeighbourMessageContext)context).forward(arg_0));
        } else {
            this.log.warn(CAN_NOT_FIND_VPLS, (Object)context.inPort(), (Object)context.vlan());
            context.drop();
        }
    }

    protected void handleReply(NeighbourMessageContext context, HostService hostService) {
        VplsData vplsData = this.findVpls(context);
        if (vplsData != null) {
            MacAddress dstMac = context.dstMac();
            Set hosts = hostService.getHostsByMac(dstMac);
            hosts = hosts.stream().filter(host -> vplsData.interfaces().contains(this.getHostInterface((Host)host))).collect(Collectors.toSet());
            hosts.stream().map(this::getHostInterface).filter(Objects::nonNull).forEach(arg_0 -> ((NeighbourMessageContext)context).forward(arg_0));
        } else {
            this.log.warn(CAN_NOT_FIND_VPLS, (Object)context.inPort(), (Object)context.vlan());
            context.drop();
        }
    }

    private VplsData findVpls(NeighbourMessageContext context) {
        Collection<VplsData> vplses = this.vplsStore.getAllVpls();
        for (VplsData vplsData : vplses) {
            Set<Interface> interfaces = vplsData.interfaces();
            ConnectPoint port = context.inPort();
            VlanId vlanId = context.vlan();
            boolean match = interfaces.stream().anyMatch(iface -> iface.connectPoint().equals((Object)port) && iface.vlan().equals((Object)vlanId));
            if (!match) continue;
            return vplsData;
        }
        return null;
    }

    private Interface getHostInterface(Host host) {
        Set interfaces = this.interfaceService.getInterfaces();
        return interfaces.stream().filter(iface -> iface.connectPoint().equals((Object)host.location()) && iface.vlan().equals((Object)host.vlan())).findFirst().orElse(null);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindNeighbourService(NeighbourResolutionService neighbourResolutionService) {
        this.neighbourService = neighbourResolutionService;
    }

    protected void unbindNeighbourService(NeighbourResolutionService neighbourResolutionService) {
        if (this.neighbourService == neighbourResolutionService) {
            this.neighbourService = null;
        }
    }

    protected void bindVplsStore(VplsStore vplsStore) {
        this.vplsStore = vplsStore;
    }

    protected void unbindVplsStore(VplsStore vplsStore) {
        if (this.vplsStore == vplsStore) {
            this.vplsStore = null;
        }
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    private class VplsConfigListener
    implements NetworkConfigListener {
        private VplsConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            VplsNeighbourHandler.this.configNeighbourHandler();
        }
    }

    private class VplsInterfaceListener
    implements InterfaceListener {
        private VplsInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            VplsNeighbourHandler.this.configNeighbourHandler();
        }
    }

    private class VplsNeighbourMessageHandler
    implements NeighbourMessageHandler {
        private VplsNeighbourMessageHandler() {
        }

        public void handleMessage(NeighbourMessageContext context, HostService hostService) {
            switch (context.type()) {
                case REQUEST: {
                    VplsNeighbourHandler.this.handleRequest(context);
                    break;
                }
                case REPLY: {
                    VplsNeighbourHandler.this.handleReply(context, hostService);
                    break;
                }
                default: {
                    VplsNeighbourHandler.this.log.warn(VplsNeighbourHandler.UNKNOWN_CONTEXT, (Object)context.type());
                }
            }
        }
    }
}

