/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.netconf;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ControllerConfig;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.TargetConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfControllerConfig
extends AbstractHandlerBehaviour
implements ControllerConfig {
    private final Logger log = LoggerFactory.getLogger(NetconfControllerConfig.class);

    public List<ControllerInfo> getControllers() {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId deviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        ArrayList<ControllerInfo> controllers = new ArrayList<ControllerInfo>();
        if (mastershipService.isLocalMaster(deviceId)) {
            try {
                String reply = controller.getNetconfDevice(deviceId).getSession().getConfig(TargetConfig.RUNNING);
                this.log.debug("Reply XML {}", (Object)reply);
                controllers.addAll(XmlConfigParser.parseStreamControllers((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8)))));
            }
            catch (IOException e) {
                this.log.error("Cannot communicate with device {} ", (Object)deviceId, (Object)e);
            }
        } else {
            this.log.warn("I'm not master for {} please use master, {} to execute command", (Object)deviceId, (Object)mastershipService.getMasterFor(deviceId));
        }
        return controllers;
    }

    public void setControllers(List<ControllerInfo> controllers) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        DeviceId deviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        if (mastershipService.isLocalMaster(deviceId)) {
            try {
                NetconfDevice device = controller.getNetconfDevice(deviceId);
                String config = null;
                try {
                    String reply = device.getSession().getConfig(TargetConfig.RUNNING);
                    this.log.info("reply XML {}", (Object)reply);
                    config = XmlConfigParser.createControllersConfig((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("controllers.xml")), (HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8))), (String)"running", (String)"merge", (String)"create", controllers);
                }
                catch (IOException e) {
                    this.log.error("Cannot comunicate to device {} , exception {}", (Object)deviceId, (Object)e.getMessage());
                }
                device.getSession().editConfig(config.substring(config.indexOf("-->") + 3));
            }
            catch (NullPointerException e) {
                this.log.warn("No NETCONF device with requested parameters " + e);
                throw new NullPointerException("No NETCONF device with requested parameters " + e);
            }
            catch (IOException e) {
                this.log.error("Cannot comunicate to device {} , exception {}", (Object)deviceId, (Object)e.getMessage());
            }
        } else {
            this.log.warn("I'm not master for {} please use master, {} to execute command", (Object)deviceId, (Object)mastershipService.getMasterFor(deviceId));
        }
    }
}

