/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.netconf;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ConfigSetter;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfConfigSetter
extends AbstractHandlerBehaviour
implements ConfigSetter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String UNABLE_TO_READ_FILE = "Configuration cannot be retrieved from file";
    private static final String UNABLE_TO_SET_CONFIG = "Configuration cannot be set";

    public String setConfiguration(String filePath) {
        String request;
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        DeviceId deviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        try {
            request = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        }
        catch (IOException e) {
            this.log.error("Cannot read configuration file", (Throwable)e);
            return UNABLE_TO_READ_FILE;
        }
        try {
            return ((NetconfDevice)controller.getDevicesMap().get(deviceId)).getSession().requestSync(request);
        }
        catch (IOException e) {
            this.log.error("Configuration could not be set", (Throwable)e);
            return UNABLE_TO_SET_CONFIG;
        }
    }
}

