/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel.utils.builtindatatype;

import java.io.Serializable;
import org.onosproject.yangutils.datamodel.DefaultLocationInfo;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.DataTypeException;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangBuiltInDataTypeInfo;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;

public class YangUint16
extends DefaultLocationInfo
implements YangBuiltInDataTypeInfo<YangUint16>,
Serializable {
    private static final long serialVersionUID = 8006201663L;
    private static final String MIN_KEYWORD = "min";
    private static final String MAX_KEYWORD = "max";
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 65535;
    private int value;

    public YangUint16(String valueInString) {
        if (valueInString.matches(MIN_KEYWORD)) {
            this.value = 0;
        } else if (valueInString.matches(MAX_KEYWORD)) {
            this.value = 65535;
        } else {
            try {
                this.value = Integer.parseInt(valueInString);
            }
            catch (Exception e) {
                throw new DataTypeException("YANG file error : Input value \"" + valueInString + "\" is not a valid " + "uint16.");
            }
        }
        if (this.value < 0) {
            throw new DataTypeException("YANG file error : " + valueInString + " is lesser than minimum value " + 0 + ".");
        }
        if (this.value > 65535) {
            throw new DataTypeException("YANG file error : " + valueInString + " is greater than maximum value " + 65535 + ".");
        }
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int compareTo(YangUint16 another) {
        return Integer.compare(this.value, another.value);
    }

    @Override
    public YangDataTypes getYangType() {
        return YangDataTypes.UINT16;
    }
}

