/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel.utils.builtindatatype;

import java.io.Serializable;
import org.onosproject.yangutils.datamodel.DefaultLocationInfo;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.DataTypeException;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangBuiltInDataTypeInfo;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;

public class YangInt16
extends DefaultLocationInfo
implements YangBuiltInDataTypeInfo<YangInt16>,
Serializable {
    private static final long serialVersionUID = 8006201667L;
    private static final String MIN_KEYWORD = "min";
    private static final String MAX_KEYWORD = "max";
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    private final short value;

    public YangInt16(String valueInString) {
        if (valueInString.matches(MIN_KEYWORD)) {
            this.value = Short.MIN_VALUE;
        } else if (valueInString.matches(MAX_KEYWORD)) {
            this.value = Short.MAX_VALUE;
        } else {
            try {
                this.value = Short.parseShort(valueInString);
            }
            catch (Exception e) {
                throw new DataTypeException("YANG file error : Input value \"" + valueInString + "\" is not a valid " + "int16.");
            }
        }
    }

    public short getValue() {
        return this.value;
    }

    @Override
    public int compareTo(YangInt16 anotherYangInt16) {
        return Short.compare(this.value, anotherYangInt16.value);
    }

    @Override
    public YangDataTypes getYangType() {
        return YangDataTypes.INT16;
    }
}

