/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.yangutils.datamodel.CollisionDetector;
import org.onosproject.yangutils.datamodel.YangCommonInfo;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeType;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangSchemaNodeType;
import org.onosproject.yangutils.datamodel.YangStatusType;
import org.onosproject.yangutils.datamodel.YangTranslatorOperatorNode;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangTypeHolder;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.exceptions.ErrorMessages;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;

public abstract class YangTypeDef
extends YangNode
implements YangCommonInfo,
Parsable,
YangTypeHolder,
CollisionDetector,
YangTranslatorOperatorNode {
    private static final long serialVersionUID = 806201615L;
    private String defaultValueInString;
    private String description;
    private String reference;
    private YangStatusType status;
    private String units;
    private final List<YangType<?>> typeList = new LinkedList();

    public YangTypeDef() {
        super(YangNodeType.TYPEDEF_NODE, null);
    }

    @Override
    public void addToChildSchemaMap(YangSchemaNodeIdentifier id, YangSchemaNodeContextInfo yangSchemaNodeContextInfo) throws DataModelException {
    }

    @Override
    public void incrementMandatoryChildCount() {
    }

    @Override
    public void addToDefaultChildMap(YangSchemaNodeIdentifier id, YangSchemaNode node) {
    }

    @Override
    public YangSchemaNodeType getYangSchemaNodeType() {
        return YangSchemaNodeType.YANG_NON_DATA_NODE;
    }

    public String getDefaultValueInString() {
        return this.defaultValueInString;
    }

    public void setDefaultValueInString(String defaultValueInString) {
        this.defaultValueInString = defaultValueInString;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public YangStatusType getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(YangStatusType status) {
        this.status = status;
    }

    public YangType<?> getTypeDefBaseType() {
        if (!this.typeList.isEmpty()) {
            return this.typeList.get(0);
        }
        return null;
    }

    public void setDataType(YangType<?> dataType) {
        this.typeList.add(0, dataType);
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.TYPEDEF_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
        if (this.defaultValueInString != null && !this.defaultValueInString.isEmpty() && this.getTypeDefBaseType() != null) {
            this.getTypeDefBaseType().isValidValue(this.defaultValueInString);
        }
    }

    @Override
    public List<YangType<?>> getTypeList() {
        return Collections.unmodifiableList(this.typeList);
    }

    @Override
    public void detectCollidingChild(String identifierName, YangConstructType dataType) throws DataModelException {
        DataModelUtils.detectCollidingChildUtil(identifierName, dataType, this);
    }

    @Override
    public void detectSelfCollision(String identifierName, YangConstructType dataType) throws DataModelException {
        if (this.getName().equals(identifierName)) {
            throw new DataModelException(ErrorMessages.getErrorMsgCollision("YANG File Error: Identifier collision detected in", this.getName(), this.getLineNumber(), this.getCharPosition(), " typedef ", this.getFileName()));
        }
    }
}

