/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.yangutils.datamodel.CollisionDetector;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangAugmentableNode;
import org.onosproject.yangutils.datamodel.YangCommonInfo;
import org.onosproject.yangutils.datamodel.YangCompilerAnnotation;
import org.onosproject.yangutils.datamodel.YangConfig;
import org.onosproject.yangutils.datamodel.YangGrouping;
import org.onosproject.yangutils.datamodel.YangIfFeature;
import org.onosproject.yangutils.datamodel.YangIfFeatureHolder;
import org.onosproject.yangutils.datamodel.YangIsFilterContentNodes;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangMaxElement;
import org.onosproject.yangutils.datamodel.YangMinElement;
import org.onosproject.yangutils.datamodel.YangMust;
import org.onosproject.yangutils.datamodel.YangMustHolder;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeType;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangSchemaNodeType;
import org.onosproject.yangutils.datamodel.YangStatusType;
import org.onosproject.yangutils.datamodel.YangUses;
import org.onosproject.yangutils.datamodel.YangWhen;
import org.onosproject.yangutils.datamodel.YangWhenHolder;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;

public abstract class YangList
extends YangNode
implements YangLeavesHolder,
YangCommonInfo,
Parsable,
CollisionDetector,
YangAugmentableNode,
YangMustHolder,
YangWhenHolder,
YangIfFeatureHolder,
YangSchemaNode,
YangIsFilterContentNodes,
YangConfig {
    private static final long serialVersionUID = 806201609L;
    private boolean isConfig;
    private String description;
    private List<String> keyList;
    private List<String> uniqueList;
    private List<YangLeaf> listOfLeaf;
    private List<YangLeafList> listOfLeafList;
    private List<YangAugment> yangAugmentedInfo = new ArrayList<YangAugment>();
    private YangMaxElement maxElements;
    private YangMinElement minElements;
    private String reference;
    private YangStatusType status = YangStatusType.CURRENT;
    private List<YangMust> mustConstraintList;
    private YangWhen when;
    private List<YangIfFeature> ifFeatureList;
    private transient YangCompilerAnnotation compilerAnnotation;

    public YangList() {
        super(YangNodeType.LIST_NODE, new HashMap<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo>());
        this.listOfLeaf = new LinkedList<YangLeaf>();
        this.listOfLeafList = new LinkedList<YangLeafList>();
        this.mustConstraintList = new LinkedList<YangMust>();
        this.ifFeatureList = new LinkedList<YangIfFeature>();
        this.uniqueList = new LinkedList<String>();
        this.keyList = new LinkedList<String>();
    }

    @Override
    public void addToChildSchemaMap(YangSchemaNodeIdentifier schemaNodeIdentifier, YangSchemaNodeContextInfo yangSchemaNodeContextInfo) {
        this.getYsnContextInfoMap().put(schemaNodeIdentifier, yangSchemaNodeContextInfo);
    }

    @Override
    public void incrementMandatoryChildCount() {
    }

    @Override
    public void addToDefaultChildMap(YangSchemaNodeIdentifier yangSchemaNodeIdentifier, YangSchemaNode yangSchemaNode) {
    }

    @Override
    public YangSchemaNodeType getYangSchemaNodeType() {
        return YangSchemaNodeType.YANG_MULTI_INSTANCE_NODE;
    }

    public YangCompilerAnnotation getCompilerAnnotation() {
        return this.compilerAnnotation;
    }

    public void setCompilerAnnotation(YangCompilerAnnotation compilerAnnotation) {
        this.compilerAnnotation = compilerAnnotation;
    }

    @Override
    public YangWhen getWhen() {
        return this.when;
    }

    @Override
    public void setWhen(YangWhen when) {
        this.when = when;
    }

    @Override
    public boolean isConfig() {
        return this.isConfig;
    }

    @Override
    public void setConfig(boolean isConfig) {
        this.isConfig = isConfig;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getUniqueList() {
        return this.uniqueList;
    }

    private void setUniqueList(List<String> uniqueList) {
        this.uniqueList = uniqueList;
    }

    public List<String> getKeyList() {
        return this.keyList;
    }

    private void setKeyList(List<String> keyList) {
        this.keyList = keyList;
    }

    public void addKey(String key) throws DataModelException {
        if (this.getKeyList() == null) {
            this.setKeyList(new LinkedList<String>());
        }
        if (this.getKeyList().contains(key)) {
            throw new DataModelException("A leaf identifier must not appear more than once in the\n   key" + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        this.getKeyList().add(key);
    }

    public void addUnique(String unique) throws DataModelException {
        if (this.getUniqueList() == null) {
            this.setUniqueList(new LinkedList<String>());
        }
        if (this.getUniqueList().contains(unique)) {
            throw new DataModelException("A leaf identifier must not appear more than once in the\n   unique" + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        this.getUniqueList().add(unique);
    }

    @Override
    public List<YangLeaf> getListOfLeaf() {
        return this.listOfLeaf;
    }

    @Override
    public void setListOfLeaf(List<YangLeaf> leafsList) {
        this.listOfLeaf = leafsList;
    }

    @Override
    public void addLeaf(YangLeaf leaf) {
        this.getListOfLeaf().add(leaf);
    }

    @Override
    public List<YangLeafList> getListOfLeafList() {
        return this.listOfLeafList;
    }

    @Override
    public void setListOfLeafList(List<YangLeafList> listOfLeafList) {
        this.listOfLeafList = listOfLeafList;
    }

    @Override
    public void addLeafList(YangLeafList leafList) {
        this.getListOfLeafList().add(leafList);
    }

    public YangMaxElement getMaxElements() {
        return this.maxElements;
    }

    public void setMaxElements(YangMaxElement max) {
        this.maxElements = max;
    }

    public YangMinElement getMinElements() {
        return this.minElements;
    }

    public void setMinElements(YangMinElement minElements) {
        this.minElements = minElements;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public YangStatusType getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(YangStatusType status) {
        this.status = status;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.LIST_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
        List<String> keys = this.getKeyList();
        List<YangLeaf> leaves = this.getListOfLeaf();
        List<YangLeafList> leafLists = this.getListOfLeafList();
        this.validateConfig(leaves, leafLists);
        if (this.isConfig && (keys.isEmpty() || leaves.isEmpty()) && !this.isUsesPresentInList() && !this.isListPresentInGrouping()) {
            throw new DataModelException("A list must have atleast one key leaf if config is true; " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (keys != null) {
            this.validateKey(leaves, keys);
        }
    }

    private void validateConfig(List<YangLeaf> leaves, List<YangLeafList> leafLists) throws DataModelException {
        if (!this.isConfig && leaves != null) {
            for (YangLeaf leaf : leaves) {
                if (!leaf.isConfig()) continue;
                throw new DataModelException("If a list has \"config\" set to \"false\", no node underneath it can have \"config\" set to \"true\"." + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
            }
        }
        if (!this.isConfig && leafLists != null) {
            for (YangLeafList leafList : leafLists) {
                if (!leafList.isConfig()) continue;
                throw new DataModelException("If a list has \"config\" set to \"false\", no node underneath it can have \"config\" set to \"true\"." + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
            }
        }
    }

    private void validateKey(List<YangLeaf> leaves, List<String> keys) throws DataModelException {
        boolean leafFound = false;
        LinkedList<YangLeaf> keyLeaves = new LinkedList<YangLeaf>();
        for (String key : keys) {
            if (leaves != null && !leaves.isEmpty()) {
                for (YangLeaf leaf : leaves) {
                    if (!key.equals(leaf.getName())) continue;
                    if (leaf.getDataType().getDataType() == YangDataTypes.EMPTY) {
                        throw new DataModelException(" A leaf that is part of the key must not be the built-in type \"empty\"." + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
                    }
                    leafFound = true;
                    keyLeaves.add(leaf);
                    break;
                }
            }
            if (!(leafFound || this.isUsesPresentInList() || this.isListPresentInGrouping())) {
                throw new DataModelException("An identifier, in key, must refer to a child leaf of the list" + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
            }
            leafFound = false;
        }
        for (YangLeaf keyLeaf : keyLeaves) {
            if (this.isConfig == keyLeaf.isConfig()) continue;
            throw new DataModelException("All key leafs in a list must have the same value for their \"config\" as the list itself." + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
    }

    @Override
    public void detectCollidingChild(String identifierName, YangConstructType dataType) throws DataModelException {
        DataModelUtils.detectCollidingChildUtil(identifierName, dataType, this);
    }

    @Override
    public void detectSelfCollision(String identifierName, YangConstructType dataType) throws DataModelException {
        if (this.getName().equals(identifierName)) {
            throw new DataModelException("YANG file error: Duplicate input identifier detected, same as list \"" + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
    }

    private boolean isUsesPresentInList() {
        for (YangNode node = this.getChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof YangUses)) continue;
            return true;
        }
        return false;
    }

    private boolean isListPresentInGrouping() {
        for (YangNode node = this.getParent(); node != null; node = node.getParent()) {
            if (!(node instanceof YangGrouping)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<YangIfFeature> getIfFeatureList() {
        return this.ifFeatureList;
    }

    @Override
    public void addIfFeatureList(YangIfFeature ifFeature) {
        if (this.getIfFeatureList() == null) {
            this.setIfFeatureList(new LinkedList<YangIfFeature>());
        }
        this.getIfFeatureList().add(ifFeature);
    }

    @Override
    public void setIfFeatureList(List<YangIfFeature> ifFeatureList) {
        this.ifFeatureList = ifFeatureList;
    }

    @Override
    public List<YangMust> getListOfMust() {
        return this.mustConstraintList;
    }

    @Override
    public void setListOfMust(List<YangMust> mustConstraintList) {
        this.mustConstraintList = mustConstraintList;
    }

    @Override
    public void addMust(YangMust must) {
        if (this.getListOfMust() == null) {
            this.setListOfMust(new LinkedList<YangMust>());
        }
        this.getListOfMust().add(must);
    }

    @Override
    public void addAugmentation(YangAugment augmentInfo) {
        this.yangAugmentedInfo.add(augmentInfo);
    }

    @Override
    public void removeAugmentation(YangAugment augmentInfo) {
        this.yangAugmentedInfo.remove(augmentInfo);
    }

    @Override
    public List<YangAugment> getAugmentedInfoList() {
        return this.yangAugmentedInfo;
    }

    @Override
    public void setLeafNameSpaceAndAddToParentSchemaMap() {
        for (YangLeaf yangLeaf : this.getListOfLeaf()) {
            yangLeaf.setLeafNameSpaceAndAddToParentSchemaMap(this.getNameSpace());
        }
        for (YangLeafList yangLeafList : this.getListOfLeafList()) {
            yangLeafList.setLeafNameSpaceAndAddToParentSchemaMap(this.getNameSpace());
        }
    }
}

