/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.scalablegateway.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.onlab.packet.Ip4Address;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.ExtensionTreatmentResolver;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.ExtensionPropertyException;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.scalablegateway.api.GatewayNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectGroupHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String TUNNEL_DESTINATION = "tunnelDst";
    private static final String PORTNAME_PREFIX_TUNNEL = "vxlan";
    private final GroupService groupService;
    private final DeviceService deviceService;
    private final DriverService driverService;
    private final ApplicationId appId;

    public SelectGroupHandler(GroupService targetGroupService, DeviceService targetDeviceService, DriverService targetDriverService, ApplicationId appId) {
        this.groupService = targetGroupService;
        this.deviceService = targetDeviceService;
        this.driverService = targetDriverService;
        this.appId = appId;
    }

    public GroupId createGatewayGroup(DeviceId srcDeviceId, List<GatewayNode> nodeList) {
        List<GroupBucket> bucketList = this.generateBucketsForSelectGroup(srcDeviceId, nodeList);
        GroupId groupId = this.getGroupId(srcDeviceId);
        DefaultGroupDescription groupDescription = new DefaultGroupDescription(srcDeviceId, GroupDescription.Type.SELECT, new GroupBuckets(bucketList), this.getGroupKey(srcDeviceId), (Integer)groupId.id(), this.appId);
        this.groupService.addGroup((GroupDescription)groupDescription);
        return groupId;
    }

    public GroupKey getGroupKey(DeviceId srcDeviceId) {
        return new DefaultGroupKey(srcDeviceId.toString().getBytes());
    }

    private GroupId getGroupId(DeviceId srcDeviceId) {
        return new GroupId(srcDeviceId.toString().hashCode());
    }

    public void updateGatewayGroupBuckets(DeviceId deviceId, List<GatewayNode> nodeList, boolean isInsert) {
        List<GroupBucket> bucketList = this.generateBucketsForSelectGroup(deviceId, nodeList);
        GroupKey groupKey = this.getGroupKey(deviceId);
        if (isInsert) {
            this.groupService.addBucketsToGroup(deviceId, groupKey, new GroupBuckets(bucketList), groupKey, this.appId);
        } else {
            this.groupService.removeBucketsFromGroup(deviceId, groupKey, new GroupBuckets(bucketList), groupKey, this.appId);
        }
    }

    private List<GroupBucket> generateBucketsForSelectGroup(DeviceId deviceId, List<GatewayNode> nodeList) {
        ArrayList bucketList = Lists.newArrayList();
        nodeList.forEach(node -> {
            TrafficTreatment tBuilder = DefaultTrafficTreatment.builder().extension(this.buildNiciraExtenstion(deviceId, node.getDataIpAddress()), deviceId).setOutput(this.getTunnelPort(deviceId)).build();
            bucketList.add(DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)tBuilder));
        });
        return bucketList;
    }

    private ExtensionTreatment buildNiciraExtenstion(DeviceId id, Ip4Address hostIp) {
        Driver driver = this.driverService.getDriver(id);
        DefaultDriverHandler driverHandler = new DefaultDriverHandler((DriverData)new DefaultDriverData(driver, id));
        ExtensionTreatmentResolver resolver = (ExtensionTreatmentResolver)driverHandler.behaviour(ExtensionTreatmentResolver.class);
        ExtensionTreatment extensionInstruction = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type());
        try {
            extensionInstruction.setPropertyValue(TUNNEL_DESTINATION, (Object)hostIp);
        }
        catch (ExtensionPropertyException e) {
            this.log.error("Error setting Nicira extension setting {}", (Throwable)e);
        }
        return extensionInstruction;
    }

    private PortNumber getTunnelPort(DeviceId deviceId) {
        Port port = this.deviceService.getPorts(deviceId).stream().filter(p -> p.annotations().value("portName").equals(PORTNAME_PREFIX_TUNNEL)).findAny().orElse(null);
        if (port == null) {
            this.log.error("No TunnelPort was created.");
            return null;
        }
        return port.number();
    }
}

