/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.scalablegateway.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.scalablegateway.api.GatewayNode;
import org.onosproject.scalablegateway.api.ScalableGatewayService;

@Command(scope="onos", name="gateway-delete", description="Deletes gateway node information for scalablegateway node managements")
public class ScalableGatewayDeleteCommand
extends AbstractShellCommand {
    private static final String SUCCESS = "Process of deleting gateway node is succeed.";
    private static final String FAIL = "Process of deleting gateway node is failed.";
    private static final String UNKNOWN = "Unknown device id is given.";
    @Argument(index=0, name="DeviceId", description="GatewayNode device id", required=true, multiValued=false)
    String deviceId = null;

    protected void execute() {
        ScalableGatewayService service = (ScalableGatewayService)ScalableGatewayDeleteCommand.get(ScalableGatewayService.class);
        GatewayNode gatewayNode = service.getGatewayNode(DeviceId.deviceId((String)this.deviceId));
        if (gatewayNode == null) {
            this.print(UNKNOWN, new Object[0]);
            return;
        }
        if (service.deleteGatewayNode(gatewayNode)) {
            this.print(SUCCESS, new Object[0]);
        } else {
            this.print(FAIL, new Object[0]);
        }
    }
}

