/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.roadm;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.util.Frequency;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.OchSignal;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.roadm.RoadmService;
import org.onosproject.roadm.RoadmUtil;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.table.TableModel;
import org.onosproject.ui.table.TableRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadmPortViewMessageHandler
extends UiMessageHandler {
    private static final String ROADM_PORT_DATA_REQ = "roadmPortDataRequest";
    private static final String ROADM_PORT_DATA_RESP = "roadmPortDataResponse";
    private static final String ROADM_PORTS = "roadmPorts";
    private static final String ROADM_SET_TARGET_POWER_REQ = "roadmSetTargetPowerRequest";
    private static final String ROADM_SET_TARGET_POWER_RESP = "roadmSetTargetPowerResponse";
    private static final String ROADM_SHOW_ITEMS_REQ = "roadmShowPortItemsRequest";
    private static final String ROADM_SHOW_ITEMS_RESP = "roadmShowPortItemsResponse";
    private static final String ROADM_SET_OPS_MODE_REQ = "roadmSetOpsModeRequest";
    private static final String ROADM_SET_OPS_MODE_RESP = "roadmSetOpsModeResponse";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String ENABLED = "enabled";
    private static final String MIN_FREQ = "minFreq";
    private static final String MAX_FREQ = "maxFreq";
    private static final String GRID = "grid";
    private static final String POWER_RANGE = "powerRange";
    private static final String CURRENT_POWER = "currentPower";
    private static final String TARGET_POWER = "targetPower";
    private static final String HAS_TARGET_POWER = "hasTargetPower";
    private static final String SERVICE_STATE = "serviceState";
    private static final String[] COLUMN_IDS = new String[]{"id", "type", "name", "enabled", "minFreq", "maxFreq", "grid", "powerRange", "currentPower", "serviceState", "targetPower", "hasTargetPower"};
    private RoadmService roadmService;
    private DeviceService deviceService;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.roadmService = (RoadmService)this.get(RoadmService.class);
        this.deviceService = (DeviceService)this.get(DeviceService.class);
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new PortTableDataRequestHandler()), (Object)((Object)new SetTargetPowerRequestHandler()), (Object)((Object)new CreateShowItemsRequestHandler()), (Object)((Object)new CreateOpsModeSetRequestHandler()));
    }

    private final class CreateOpsModeSetRequestHandler
    extends RequestHandler {
        private static final String OPS_SWITCH_INDEX = "index";
        private static final String DEVICE_INVALID_ERR_MSG = "Apply failed: device is offline or unavailable.";
        private static final String TYPE_INVALID_ERR_MSG = "Apply failed: invalid device type.";

        private CreateOpsModeSetRequestHandler() {
            super(RoadmPortViewMessageHandler.ROADM_SET_OPS_MODE_REQ);
        }

        public void process(ObjectNode payload) {
            DeviceId did = DeviceId.deviceId((String)this.string(payload, "devId"));
            ObjectNode node = RoadmPortViewMessageHandler.this.objectNode();
            if (!RoadmPortViewMessageHandler.this.deviceService.isAvailable(did)) {
                node.put("valid", false);
                node.put("message", DEVICE_INVALID_ERR_MSG);
                this.sendMessage(RoadmPortViewMessageHandler.ROADM_SET_OPS_MODE_RESP, node);
                return;
            }
            Device.Type devType = RoadmPortViewMessageHandler.this.deviceService.getDevice(did).type();
            if (devType != Device.Type.FIBER_SWITCH) {
                node.put("valid", false);
                node.put("message", TYPE_INVALID_ERR_MSG);
                this.sendMessage(RoadmPortViewMessageHandler.ROADM_SET_OPS_MODE_RESP, node);
                return;
            }
            RoadmPortViewMessageHandler.this.roadmService.setProtectionSwitchWorkingPath(did, (int)this.number(payload, OPS_SWITCH_INDEX));
            node.put("valid", true);
            this.sendMessage(RoadmPortViewMessageHandler.ROADM_SET_OPS_MODE_RESP, node);
        }
    }

    private final class CreateShowItemsRequestHandler
    extends RequestHandler {
        private static final String SHOW_TARGET_POWER = "showTargetPower";
        private static final String SHOW_SERVICE_STATE = "showServiceState";
        private static final String SHOW_FLOW_ICON = "showFlowIcon";

        private CreateShowItemsRequestHandler() {
            super(RoadmPortViewMessageHandler.ROADM_SHOW_ITEMS_REQ);
        }

        public void process(ObjectNode payload) {
            DeviceId did = DeviceId.deviceId((String)this.string(payload, "devId"));
            Device.Type devType = RoadmPortViewMessageHandler.this.deviceService.getDevice(did).type();
            ObjectNode node = RoadmPortViewMessageHandler.this.objectNode();
            node.put(SHOW_TARGET_POWER, devType != Device.Type.FIBER_SWITCH);
            node.put(SHOW_SERVICE_STATE, devType == Device.Type.FIBER_SWITCH);
            node.put(SHOW_FLOW_ICON, devType == Device.Type.ROADM);
            this.sendMessage(RoadmPortViewMessageHandler.ROADM_SHOW_ITEMS_RESP, node);
        }
    }

    private final class SetTargetPowerRequestHandler
    extends RequestHandler {
        private static final String TARGET_POWER_ERR_MSG = "Target power range is %s.";

        private SetTargetPowerRequestHandler() {
            super(RoadmPortViewMessageHandler.ROADM_SET_TARGET_POWER_REQ);
        }

        public void process(ObjectNode payload) {
            DeviceId deviceId = DeviceId.deviceId((String)this.string(payload, "devId"));
            PortNumber portNumber = PortNumber.portNumber((long)payload.get(RoadmPortViewMessageHandler.ID).asLong());
            Range<Long> range = RoadmPortViewMessageHandler.this.roadmService.targetPortPowerRange(deviceId, portNumber);
            if (range == null) {
                RoadmPortViewMessageHandler.this.log.warn("Unable to determine target power range for device {}", (Object)deviceId);
                return;
            }
            Long targetPower = payload.get(RoadmPortViewMessageHandler.TARGET_POWER).asLong();
            boolean validTargetPower = range.contains((Comparable)targetPower);
            if (validTargetPower) {
                RoadmPortViewMessageHandler.this.roadmService.setTargetPortPower(deviceId, portNumber, targetPower);
            }
            ObjectNode rootNode = RoadmPortViewMessageHandler.this.objectNode();
            rootNode.put(RoadmPortViewMessageHandler.ID, payload.get(RoadmPortViewMessageHandler.ID).asText());
            rootNode.put("valid", validTargetPower);
            rootNode.put("message", String.format(TARGET_POWER_ERR_MSG, range.toString()));
            this.sendMessage(RoadmPortViewMessageHandler.ROADM_SET_TARGET_POWER_RESP, rootNode);
        }
    }

    private final class PortTableDataRequestHandler
    extends TableRequestHandler {
        private Frequency minFreq;
        private Frequency maxFreq;
        private Frequency channelSpacing;

        private PortTableDataRequestHandler() {
            super(RoadmPortViewMessageHandler.ROADM_PORT_DATA_REQ, RoadmPortViewMessageHandler.ROADM_PORT_DATA_RESP, RoadmPortViewMessageHandler.ROADM_PORTS);
            this.minFreq = null;
            this.maxFreq = null;
            this.channelSpacing = null;
        }

        protected String[] getColumnIds() {
            return COLUMN_IDS;
        }

        protected String noRowsMessage(ObjectNode payload) {
            return "No items found";
        }

        protected void populateTable(TableModel tm, ObjectNode payload) {
            DeviceId deviceId = DeviceId.deviceId((String)this.string(payload, "devId"));
            if (RoadmPortViewMessageHandler.this.deviceService.isAvailable(deviceId)) {
                List ports = RoadmPortViewMessageHandler.this.deviceService.getPorts(deviceId);
                for (Port port : ports) {
                    this.populateRow(tm.addRow(), port, deviceId);
                }
            }
        }

        private void populateRow(TableModel.Row row, Port port, DeviceId deviceId) {
            PortNumber portNum = port.number();
            this.getFrequencyLimit(deviceId, portNum);
            row.cell(RoadmPortViewMessageHandler.ID, (Object)portNum.toLong()).cell(RoadmPortViewMessageHandler.TYPE, (Object)port.type()).cell(RoadmPortViewMessageHandler.ENABLED, (Object)port.isEnabled()).cell(RoadmPortViewMessageHandler.NAME, (Object)RoadmUtil.getAnnotation(port.annotations(), "portName")).cell(RoadmPortViewMessageHandler.MIN_FREQ, (Object)RoadmUtil.asTHz(this.minFreq)).cell(RoadmPortViewMessageHandler.MAX_FREQ, (Object)RoadmUtil.asTHz(this.maxFreq)).cell(RoadmPortViewMessageHandler.GRID, (Object)RoadmUtil.asGHz(this.channelSpacing)).cell(RoadmPortViewMessageHandler.POWER_RANGE, (Object)this.getPowerRange(deviceId, portNum)).cell(RoadmPortViewMessageHandler.CURRENT_POWER, (Object)this.getCurrentPower(deviceId, portNum)).cell(RoadmPortViewMessageHandler.SERVICE_STATE, (Object)this.getPortServiceState(deviceId, portNum)).cell(RoadmPortViewMessageHandler.TARGET_POWER, (Object)this.getTargetPower(deviceId, portNum)).cell(RoadmPortViewMessageHandler.HAS_TARGET_POWER, (Object)RoadmPortViewMessageHandler.this.roadmService.hasPortTargetPower(deviceId, portNum));
        }

        private String getPortServiceState(DeviceId deviceId, PortNumber portNumber) {
            return RoadmUtil.defaultString(RoadmPortViewMessageHandler.this.roadmService.getProtectionSwitchPortState(deviceId, portNumber), "Unknown");
        }

        private void getFrequencyLimit(DeviceId deviceId, PortNumber portNumber) {
            Set<OchSignal> signals = RoadmPortViewMessageHandler.this.roadmService.queryLambdas(deviceId, portNumber);
            if (signals.isEmpty()) {
                return;
            }
            Comparator compare = (a, b) -> a.spacingMultiplier() - b.spacingMultiplier();
            OchSignal minOch = Collections.min(signals, compare);
            OchSignal maxOch = Collections.max(signals, compare);
            this.minFreq = minOch.centralFrequency();
            this.maxFreq = maxOch.centralFrequency();
            this.channelSpacing = minOch.channelSpacing().frequency();
        }

        private String getPowerRange(DeviceId deviceId, PortNumber portNumber) {
            Range<Long> range = RoadmPortViewMessageHandler.this.roadmService.inputPortPowerRange(deviceId, portNumber);
            if (range == null) {
                range = RoadmPortViewMessageHandler.this.roadmService.targetPortPowerRange(deviceId, portNumber);
            }
            return RoadmUtil.objectToString(range, "N/A");
        }

        private String getCurrentPower(DeviceId deviceId, PortNumber portNumber) {
            Long currentPower = RoadmPortViewMessageHandler.this.roadmService.getCurrentPortPower(deviceId, portNumber);
            return RoadmUtil.objectToString(currentPower, "Unknown");
        }

        private String getTargetPower(DeviceId deviceId, PortNumber portNumber) {
            if (!RoadmPortViewMessageHandler.this.roadmService.hasPortTargetPower(deviceId, portNumber)) {
                return "N/A";
            }
            Long targetPower = RoadmPortViewMessageHandler.this.roadmService.getTargetPortPower(deviceId, portNumber);
            return RoadmUtil.objectToString(targetPower, "Unknown");
        }
    }
}

