/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.roadm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Direction;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.LambdaQuery;
import org.onosproject.net.behaviour.PowerConfig;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointState;
import org.onosproject.net.behaviour.protection.ProtectionConfigBehaviour;
import org.onosproject.net.behaviour.protection.TransportEndpointState;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.roadm.ChannelData;
import org.onosproject.roadm.RoadmService;
import org.onosproject.roadm.RoadmStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class RoadmManager
implements RoadmService {
    private static final String APP_NAME = "org.onosproject.roadm";
    private ApplicationId appId;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DeviceListener deviceListener = new InternalDeviceListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RoadmStore roadmStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.initDevices();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.log.info("Stopped");
    }

    @Override
    public void setProtectionSwitchWorkingPath(DeviceId deviceId, int index) {
        Preconditions.checkNotNull((Object)deviceId);
        ProtectionConfigBehaviour behaviour = this.getProtectionConfig(deviceId);
        if (behaviour == null) {
            return;
        }
        Map<ConnectPoint, ProtectedTransportEndpointState> map = this.getProtectionSwitchStates(behaviour);
        if (map == null) {
            this.log.warn("Failed to get protected transport endpoint state in device {}", (Object)deviceId);
            return;
        }
        if (map.isEmpty()) {
            this.log.warn("No protected transport endpoint state found in device {}", (Object)deviceId);
            return;
        }
        behaviour.switchWorkingPath(map.keySet().toArray(new ConnectPoint[0])[0], index);
    }

    @Override
    public String getProtectionSwitchPortState(DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkNotNull((Object)deviceId);
        ProtectionConfigBehaviour behaviour = this.getProtectionConfig(deviceId);
        if (behaviour == null) {
            return null;
        }
        Map<ConnectPoint, ProtectedTransportEndpointState> map = this.getProtectionSwitchStates(behaviour);
        if (map == null) {
            this.log.warn("Failed to get protected transport endpoint state in device {}", (Object)deviceId);
            return null;
        }
        for (ProtectedTransportEndpointState state : map.values()) {
            for (TransportEndpointState element : state.pathStates()) {
                if (!element.description().output().connectPoint().port().equals((Object)portNumber)) continue;
                return (String)element.attributes().get("inputStatus");
            }
        }
        this.log.debug("Unable to get port status, device: {}, port: {}", (Object)deviceId, (Object)portNumber);
        return null;
    }

    @Override
    public void setTargetPortPower(DeviceId deviceId, PortNumber portNumber, long power) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null) {
            this.roadmStore.setTargetPower(deviceId, portNumber, power);
            powerConfig.setTargetPower(portNumber, (Object)Direction.ALL, power);
        } else {
            this.log.warn("Unable to set target port power for device {}", (Object)deviceId);
        }
    }

    @Override
    public Long getTargetPortPower(DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        return this.roadmStore.getTargetPower(deviceId, portNumber);
    }

    @Override
    public void setAttenuation(DeviceId deviceId, PortNumber portNumber, OchSignal ochSignal, long attenuation) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        Preconditions.checkNotNull((Object)ochSignal);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null) {
            powerConfig.setTargetPower(portNumber, (Object)ochSignal, attenuation);
        } else {
            this.log.warn("Cannot set attenuation for channel index {} on device {}", (Object)ochSignal.spacingMultiplier(), (Object)deviceId);
        }
    }

    @Override
    public Long getAttenuation(DeviceId deviceId, PortNumber portNumber, OchSignal ochSignal) {
        Optional attenuation;
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        Preconditions.checkNotNull((Object)ochSignal);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null && (attenuation = powerConfig.getTargetPower(portNumber, (Object)ochSignal)).isPresent()) {
            return (Long)attenuation.get();
        }
        return null;
    }

    @Override
    public Long getCurrentPortPower(DeviceId deviceId, PortNumber portNumber) {
        Optional currentPower;
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null && (currentPower = powerConfig.currentPower(portNumber, (Object)Direction.ALL)).isPresent()) {
            return (Long)currentPower.get();
        }
        return null;
    }

    @Override
    public Long getCurrentChannelPower(DeviceId deviceId, PortNumber portNumber, OchSignal ochSignal) {
        Optional currentPower;
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        Preconditions.checkNotNull((Object)ochSignal);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null && (currentPower = powerConfig.currentPower(portNumber, (Object)ochSignal)).isPresent()) {
            return (Long)currentPower.get();
        }
        return null;
    }

    @Override
    public Set<OchSignal> queryLambdas(DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        LambdaQuery lambdaQuery = this.getLambdaQuery(deviceId);
        if (lambdaQuery != null) {
            return lambdaQuery.queryLambdas(portNumber);
        }
        return Collections.emptySet();
    }

    @Override
    public FlowId createConnection(DeviceId deviceId, int priority, boolean isPermanent, int timeout, PortNumber inPort, PortNumber outPort, OchSignal ochSignal) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)inPort);
        Preconditions.checkNotNull((Object)outPort);
        TrafficSelector selector = DefaultTrafficSelector.builder().add(Criteria.matchInPort((PortNumber)inPort)).add(Criteria.matchOchSignalType((OchSignalType)OchSignalType.FIXED_GRID)).add(Criteria.matchLambda((Lambda)ochSignal)).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().add((Instruction)Instructions.createOutput((PortNumber)outPort)).build();
        FlowRule.Builder flowBuilder = DefaultFlowRule.builder().forDevice(deviceId).fromApp(this.appId).withPriority(priority).withSelector(selector).withTreatment(treatment);
        if (isPermanent) {
            flowBuilder.makePermanent();
        } else {
            flowBuilder.makeTemporary(timeout);
        }
        FlowRule flowRule = flowBuilder.build();
        this.flowRuleService.applyFlowRules(new FlowRule[]{flowRule});
        this.log.info("Created connection from input port {} to output port {}", (Object)inPort.toLong(), (Object)outPort.toLong());
        return flowRule.id();
    }

    @Override
    public FlowId createConnection(DeviceId deviceId, int priority, boolean isPermanent, int timeout, PortNumber inPort, PortNumber outPort, OchSignal ochSignal, long attenuation) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)inPort);
        Preconditions.checkNotNull((Object)outPort);
        FlowId flowId = this.createConnection(deviceId, priority, isPermanent, timeout, inPort, outPort, ochSignal);
        this.delayedSetAttenuation(deviceId, outPort, ochSignal, attenuation);
        return flowId;
    }

    @Override
    public void removeConnection(DeviceId deviceId, FlowId flowId) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)flowId);
        for (FlowEntry entry : this.flowRuleService.getFlowEntries(deviceId)) {
            if (!entry.id().equals((Object)flowId)) continue;
            this.flowRuleService.removeFlowRules(new FlowRule[]{entry});
            this.log.info("Deleted connection {}", (Object)entry.id());
            break;
        }
    }

    @Override
    public boolean hasPortTargetPower(DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null) {
            Optional range = powerConfig.getTargetPowerRange(portNumber, (Object)Direction.ALL);
            return range.isPresent();
        }
        return false;
    }

    @Override
    public boolean portTargetPowerInRange(DeviceId deviceId, PortNumber portNumber, long power) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null) {
            Optional range = powerConfig.getTargetPowerRange(portNumber, (Object)Direction.ALL);
            return range.isPresent() && ((Range)range.get()).contains((Comparable)Long.valueOf(power));
        }
        return false;
    }

    @Override
    public boolean attenuationInRange(DeviceId deviceId, PortNumber outPort, long att) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)outPort);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null) {
            OchSignal stubOch = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)0);
            Optional range = powerConfig.getTargetPowerRange(outPort, (Object)stubOch);
            return range.isPresent() && ((Range)range.get()).contains((Comparable)Long.valueOf(att));
        }
        return false;
    }

    @Override
    public boolean validInputPort(DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null) {
            Optional range = powerConfig.getInputPowerRange(portNumber, (Object)Direction.ALL);
            return range.isPresent();
        }
        return false;
    }

    @Override
    public boolean validOutputPort(DeviceId deviceId, PortNumber portNumber) {
        return this.hasPortTargetPower(deviceId, portNumber);
    }

    @Override
    public boolean validChannel(DeviceId deviceId, PortNumber portNumber, OchSignal ochSignal) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        Preconditions.checkNotNull((Object)ochSignal);
        LambdaQuery lambdaQuery = this.getLambdaQuery(deviceId);
        if (lambdaQuery != null) {
            Set channels = lambdaQuery.queryLambdas(portNumber);
            return channels.contains(ochSignal);
        }
        return false;
    }

    @Override
    public boolean channelAvailable(DeviceId deviceId, OchSignal ochSignal) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)ochSignal);
        for (FlowEntry entry : this.flowRuleService.getFlowEntries(deviceId)) {
            if (!ChannelData.fromFlow((FlowRule)entry).ochSignal().equals((Object)ochSignal)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validConnection(DeviceId deviceId, PortNumber inPort, PortNumber outPort) {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)inPort);
        Preconditions.checkNotNull((Object)outPort);
        return this.validInputPort(deviceId, inPort) && this.validOutputPort(deviceId, outPort);
    }

    @Override
    public Range<Long> targetPortPowerRange(DeviceId deviceId, PortNumber portNumber) {
        Optional range;
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null && (range = powerConfig.getTargetPowerRange(portNumber, (Object)Direction.ALL)).isPresent()) {
            return (Range)range.get();
        }
        return null;
    }

    @Override
    public Range<Long> attenuationRange(DeviceId deviceId, PortNumber portNumber, OchSignal ochSignal) {
        Optional range;
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        Preconditions.checkNotNull((Object)ochSignal);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null && (range = powerConfig.getTargetPowerRange(portNumber, (Object)ochSignal)).isPresent()) {
            return (Range)range.get();
        }
        return null;
    }

    @Override
    public Range<Long> inputPortPowerRange(DeviceId deviceId, PortNumber portNumber) {
        Optional range;
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)portNumber);
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig != null && (range = powerConfig.getInputPowerRange(portNumber, (Object)Direction.ALL)).isPresent()) {
            return (Range)range.get();
        }
        return null;
    }

    private PowerConfig<Object> getPowerConfig(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device != null && device.is(PowerConfig.class)) {
            return (PowerConfig)device.as(PowerConfig.class);
        }
        this.log.debug("Unable to load PowerConfig for {}", (Object)deviceId);
        return null;
    }

    private LambdaQuery getLambdaQuery(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device != null && device.is(LambdaQuery.class)) {
            return (LambdaQuery)device.as(LambdaQuery.class);
        }
        this.log.debug("Unable to load LambdaQuery for {}", (Object)deviceId);
        return null;
    }

    private ProtectionConfigBehaviour getProtectionConfig(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device != null && device.is(ProtectionConfigBehaviour.class)) {
            return (ProtectionConfigBehaviour)device.as(ProtectionConfigBehaviour.class);
        }
        this.log.debug("Unable to load ProtectionConfigBehaviour for {}", (Object)deviceId);
        return null;
    }

    private void initDevices() {
        for (Device device : this.deviceService.getDevices(Device.Type.ROADM)) {
            this.initDevice(device.id());
        }
    }

    private void initDevice(DeviceId deviceId) {
        if (!this.roadmStore.deviceAvailable(deviceId)) {
            this.roadmStore.addDevice(deviceId);
        }
        this.log.info("Initialized device {}", (Object)deviceId);
    }

    private void setInitialTargetPortPower(DeviceId deviceId, PortNumber portNumber) {
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig == null) {
            this.log.warn("Unable to set default initial powers for port {} on device {}", (Object)portNumber, (Object)deviceId);
            return;
        }
        Optional range = powerConfig.getTargetPowerRange(portNumber, (Object)Direction.ALL);
        if (!range.isPresent()) {
            this.log.warn("No target power range found for port {} on device {}", (Object)portNumber, (Object)deviceId);
            return;
        }
        Long power = this.roadmStore.getTargetPower(deviceId, portNumber);
        if (power == null) {
            power = ((Long)((Range)range.get()).lowerEndpoint() + (Long)((Range)range.get()).upperEndpoint()) / 2L;
            this.roadmStore.setTargetPower(deviceId, portNumber, power);
        }
        powerConfig.setTargetPower(portNumber, (Object)Direction.ALL, power.longValue());
    }

    private void setAllInitialTargetPortPowers(DeviceId deviceId) {
        PowerConfig<Object> powerConfig = this.getPowerConfig(deviceId);
        if (powerConfig == null) {
            this.log.warn("Unable to set default initial powers for device {}", (Object)deviceId);
            return;
        }
        List ports = this.deviceService.getPorts(deviceId);
        for (Port port : ports) {
            Optional range = powerConfig.getTargetPowerRange(port.number(), (Object)Direction.ALL);
            if (range.isPresent()) {
                Long power = this.roadmStore.getTargetPower(deviceId, port.number());
                if (power == null) {
                    power = ((Long)((Range)range.get()).lowerEndpoint() + (Long)((Range)range.get()).upperEndpoint()) / 2L;
                    this.roadmStore.setTargetPower(deviceId, port.number(), power);
                }
                powerConfig.setTargetPower(port.number(), (Object)Direction.ALL, power.longValue());
                continue;
            }
            this.log.warn("No target power range found for port {} on device {}", (Object)port.number(), (Object)deviceId);
        }
    }

    private void delayedSetAttenuation(DeviceId deviceId, PortNumber outPort, OchSignal ochSignal, long attenuation) {
        Runnable setAtt = () -> {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                this.log.warn("Thread interrupted. Setting attenuation early.");
            }
            this.setAttenuation(deviceId, outPort, ochSignal, attenuation);
        };
        new Thread(setAtt).start();
    }

    private Map<ConnectPoint, ProtectedTransportEndpointState> getProtectionSwitchStates(ProtectionConfigBehaviour behaviour) {
        Map map;
        CompletableFuture states = behaviour.getProtectionEndpointStates();
        try {
            map = (Map)states.get();
        }
        catch (InterruptedException e1) {
            this.log.error("Interrupted.", (Throwable)e1);
            return null;
        }
        catch (ExecutionException e1) {
            this.log.error("Exception caught.", (Throwable)e1);
            return null;
        }
        return map;
    }

    protected void bindRoadmStore(RoadmStore roadmStore) {
        this.roadmStore = roadmStore;
    }

    protected void unbindRoadmStore(RoadmStore roadmStore) {
        if (this.roadmStore == roadmStore) {
            this.roadmStore = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent deviceEvent) {
            Device device = (Device)deviceEvent.subject();
            switch ((DeviceEvent.Type)deviceEvent.type()) {
                case DEVICE_ADDED: 
                case DEVICE_UPDATED: {
                    RoadmManager.this.initDevice(device.id());
                    break;
                }
                case PORT_ADDED: 
                case PORT_UPDATED: {
                    break;
                }
            }
        }
    }
}

