/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.roadm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.util.Frequency;
import org.onlab.util.Spectrum;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.roadm.ChannelData;
import org.onosproject.roadm.RoadmService;
import org.onosproject.roadm.RoadmUtil;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.table.TableModel;
import org.onosproject.ui.table.TableRequestHandler;
import org.onosproject.ui.table.cell.HexLongFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadmFlowViewMessageHandler
extends UiMessageHandler {
    private static final String ROADM_FLOW_DATA_REQ = "roadmFlowDataRequest";
    private static final String ROADM_FLOW_DATA_RESP = "roadmFlowDataResponse";
    private static final String ROADM_FLOWS = "roadmFlows";
    private static final String ROADM_SET_ATTENUATION_REQ = "roadmSetAttenuationRequest";
    private static final String ROADM_SET_ATTENUATION_RESP = "roadmSetAttenuationResponse";
    private static final String ROADM_DELETE_FLOW_REQ = "roadmDeleteFlowRequest";
    private static final String ROADM_CREATE_FLOW_REQ = "roadmCreateFlowRequest";
    private static final String ROADM_CREATE_FLOW_RESP = "roadmCreateFlowResponse";
    private static final String ROADM_SHOW_ITEMS_REQ = "roadmShowFlowItemsRequest";
    private static final String ROADM_SHOW_ITEMS_RESP = "roadmShowFlowItemsResponse";
    private static final String ID = "id";
    private static final String FLOW_ID = "flowId";
    private static final String APP_ID = "appId";
    private static final String GROUP_ID = "groupId";
    private static final String TABLE_ID = "tableId";
    private static final String PRIORITY = "priority";
    private static final String PERMANENT = "permanent";
    private static final String TIMEOUT = "timeout";
    private static final String STATE = "state";
    private static final String IN_PORT = "inPort";
    private static final String OUT_PORT = "outPort";
    private static final String CHANNEL_SPACING = "spacing";
    private static final String CHANNEL_MULTIPLIER = "multiplier";
    private static final String CURRENT_POWER = "currentPower";
    private static final String ATTENUATION = "attenuation";
    private static final String HAS_ATTENUATION = "hasAttenuation";
    private static final String CHANNEL_FREQUENCY = "channelFrequency";
    private static final String[] COLUMN_IDS = new String[]{"id", "flowId", "appId", "groupId", "tableId", "priority", "timeout", "permanent", "state", "inPort", "outPort", "spacing", "multiplier", "channelFrequency", "currentPower", "attenuation", "hasAttenuation"};
    private RoadmService roadmService;
    private DeviceService deviceService;
    private FlowRuleService flowRuleService;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.roadmService = (RoadmService)this.get(RoadmService.class);
        this.deviceService = (DeviceService)this.get(DeviceService.class);
        this.flowRuleService = (FlowRuleService)this.get(FlowRuleService.class);
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new FlowTableDataRequestHandler()), (Object)((Object)new SetAttenuationRequestHandler()), (Object)((Object)new DeleteConnectionRequestHandler()), (Object)((Object)new CreateConnectionRequestHandler()), (Object)((Object)new CreateShowItemsRequestHandler()));
    }

    private final class CreateShowItemsRequestHandler
    extends RequestHandler {
        private static final String SHOW_CHANNEL = "showChannel";
        private static final String SHOW_ATTENUATION = "showAttenuation";

        private CreateShowItemsRequestHandler() {
            super(RoadmFlowViewMessageHandler.ROADM_SHOW_ITEMS_REQ);
        }

        public void process(ObjectNode payload) {
            DeviceId did = DeviceId.deviceId((String)this.string(payload, "devId"));
            Device.Type devType = RoadmFlowViewMessageHandler.this.deviceService.getDevice(did).type();
            ObjectNode node = RoadmFlowViewMessageHandler.this.objectNode();
            node.put(SHOW_CHANNEL, devType != Device.Type.FIBER_SWITCH);
            node.put(SHOW_ATTENUATION, devType == Device.Type.ROADM);
            this.sendMessage(RoadmFlowViewMessageHandler.ROADM_SHOW_ITEMS_RESP, node);
        }
    }

    private final class CreateConnectionRequestHandler
    extends RequestHandler {
        private static final String FORM_DATA = "formData";
        private static final String CHANNEL_SPACING_INDEX = "index";
        private static final String CONNECTION = "connection";
        private static final String CHANNEL_AVAILABLE = "channelAvailable";
        private static final String IN_PORT_ERR_MSG = "Invalid input port.";
        private static final String OUT_PORT_ERR_MSG = "Invalid output port.";
        private static final String CONNECTION_ERR_MSG = "Invalid connection from input port to output port.";
        private static final String CHANNEL_SPACING_ERR_MSG = "Channel spacing not supported.";
        private static final String CHANNEL_ERR_MSG = "Channel index must be in range %s.";
        private static final String CHANNEL_AVAILABLE_ERR_MSG = "Channel is already being used.";
        private static final String ATTENUATION_ERR_MSG = "Attenuation must be in range %s.";

        private CreateConnectionRequestHandler() {
            super(RoadmFlowViewMessageHandler.ROADM_CREATE_FLOW_REQ);
        }

        public void process(ObjectNode payload) {
            DeviceId did = DeviceId.deviceId((String)this.string(payload, "devId"));
            ObjectNode flowNode = JsonUtils.node((ObjectNode)payload, (String)FORM_DATA);
            int priority = (int)this.number(flowNode, RoadmFlowViewMessageHandler.PRIORITY);
            boolean permanent = this.bool(flowNode, RoadmFlowViewMessageHandler.PERMANENT);
            int timeout = (int)this.number(flowNode, RoadmFlowViewMessageHandler.TIMEOUT);
            PortNumber inPort = PortNumber.portNumber((long)this.number(flowNode, RoadmFlowViewMessageHandler.IN_PORT));
            PortNumber outPort = PortNumber.portNumber((long)this.number(flowNode, RoadmFlowViewMessageHandler.OUT_PORT));
            ObjectNode chNode = JsonUtils.node((ObjectNode)flowNode, (String)RoadmFlowViewMessageHandler.CHANNEL_SPACING);
            ChannelSpacing spacing = this.channelSpacing((int)this.number(chNode, CHANNEL_SPACING_INDEX));
            int multiplier = (int)this.number(flowNode, RoadmFlowViewMessageHandler.CHANNEL_MULTIPLIER);
            OchSignal och = OchSignal.newDwdmSlot((ChannelSpacing)spacing, (int)multiplier);
            long att = this.number(flowNode, RoadmFlowViewMessageHandler.ATTENUATION);
            boolean showItems = RoadmFlowViewMessageHandler.this.deviceService.getDevice(did).type() != Device.Type.FIBER_SWITCH;
            boolean validInPort = RoadmFlowViewMessageHandler.this.roadmService.validInputPort(did, inPort);
            boolean validOutPort = RoadmFlowViewMessageHandler.this.roadmService.validOutputPort(did, outPort);
            boolean validConnect = RoadmFlowViewMessageHandler.this.roadmService.validConnection(did, inPort, outPort);
            boolean validSpacing = true;
            boolean validChannel = RoadmFlowViewMessageHandler.this.roadmService.validChannel(did, inPort, och);
            boolean channelAvailable = RoadmFlowViewMessageHandler.this.roadmService.channelAvailable(did, och);
            boolean validAttenuation = RoadmFlowViewMessageHandler.this.roadmService.attenuationInRange(did, outPort, att);
            if (validConnect && validChannel && channelAvailable) {
                if (validAttenuation) {
                    RoadmFlowViewMessageHandler.this.roadmService.createConnection(did, priority, permanent, timeout, inPort, outPort, och, att);
                } else {
                    RoadmFlowViewMessageHandler.this.roadmService.createConnection(did, priority, permanent, timeout, inPort, outPort, och);
                }
            }
            String channelMessage = "Invalid channel";
            String attenuationMessage = "Invalid attenuation";
            if (showItems) {
                Range<Long> range;
                Set<OchSignal> lambdas;
                if (!validChannel && (lambdas = RoadmFlowViewMessageHandler.this.roadmService.queryLambdas(did, outPort)) != null) {
                    Range<Integer> range2 = this.channelRange(lambdas);
                    if (range2.contains((Comparable)Integer.valueOf(och.spacingMultiplier()))) {
                        validSpacing = false;
                    } else {
                        channelMessage = String.format(CHANNEL_ERR_MSG, range2.toString());
                    }
                }
                if (!validAttenuation && (range = RoadmFlowViewMessageHandler.this.roadmService.attenuationRange(did, outPort, och)) != null) {
                    attenuationMessage = String.format(ATTENUATION_ERR_MSG, range.toString());
                }
            }
            ObjectNode node = RoadmFlowViewMessageHandler.this.objectNode();
            node.set(RoadmFlowViewMessageHandler.IN_PORT, (JsonNode)this.validationObject(validInPort, IN_PORT_ERR_MSG));
            node.set(RoadmFlowViewMessageHandler.OUT_PORT, (JsonNode)this.validationObject(validOutPort, OUT_PORT_ERR_MSG));
            node.set(CONNECTION, (JsonNode)this.validationObject(validConnect, CONNECTION_ERR_MSG));
            node.set(RoadmFlowViewMessageHandler.CHANNEL_SPACING, (JsonNode)this.validationObject(validChannel || validSpacing, CHANNEL_SPACING_ERR_MSG));
            node.set(RoadmFlowViewMessageHandler.CHANNEL_MULTIPLIER, (JsonNode)this.validationObject(validChannel || !validSpacing, channelMessage));
            node.set(CHANNEL_AVAILABLE, (JsonNode)this.validationObject(!validChannel || channelAvailable, CHANNEL_AVAILABLE_ERR_MSG));
            node.set(RoadmFlowViewMessageHandler.ATTENUATION, (JsonNode)this.validationObject(validAttenuation, attenuationMessage));
            this.sendMessage(RoadmFlowViewMessageHandler.ROADM_CREATE_FLOW_RESP, node);
        }

        private ChannelSpacing channelSpacing(int selectionIndex) {
            switch (selectionIndex) {
                case 0: {
                    return ChannelSpacing.CHL_100GHZ;
                }
                case 1: {
                    return ChannelSpacing.CHL_50GHZ;
                }
                case 2: {
                    return ChannelSpacing.CHL_25GHZ;
                }
                case 3: {
                    return ChannelSpacing.CHL_12P5GHZ;
                }
            }
            return ChannelSpacing.CHL_50GHZ;
        }

        private ObjectNode validationObject(boolean result, String message) {
            ObjectNode node = RoadmFlowViewMessageHandler.this.objectNode();
            node.put("valid", result);
            if (!result) {
                node.put("message", message);
            }
            return node;
        }

        private Range<Integer> channelRange(Set<OchSignal> signals) {
            Comparator compare = (a, b) -> a.spacingMultiplier() - b.spacingMultiplier();
            OchSignal minOch = Collections.min(signals, compare);
            OchSignal maxOch = Collections.max(signals, compare);
            return Range.closed((Comparable)Integer.valueOf(minOch.spacingMultiplier()), (Comparable)Integer.valueOf(maxOch.spacingMultiplier()));
        }
    }

    private final class DeleteConnectionRequestHandler
    extends RequestHandler {
        private DeleteConnectionRequestHandler() {
            super(RoadmFlowViewMessageHandler.ROADM_DELETE_FLOW_REQ);
        }

        public void process(ObjectNode payload) {
            DeviceId deviceId = DeviceId.deviceId((String)this.string(payload, "devId"));
            FlowId flowId = FlowId.valueOf((long)payload.get(RoadmFlowViewMessageHandler.ID).asLong());
            RoadmFlowViewMessageHandler.this.roadmService.removeConnection(deviceId, flowId);
        }
    }

    private final class SetAttenuationRequestHandler
    extends RequestHandler {
        private static final String ATTENUATION_RANGE_MSG = "Attenuation must be in range %s.";
        private static final String NO_ATTENUATION_MSG = "Cannot set attenuation for this connection";

        private SetAttenuationRequestHandler() {
            super(RoadmFlowViewMessageHandler.ROADM_SET_ATTENUATION_REQ);
        }

        public void process(ObjectNode payload) {
            boolean validAttenuation;
            FlowId flowId;
            DeviceId deviceId = DeviceId.deviceId((String)this.string(payload, "devId"));
            FlowEntry entry = this.findFlow(deviceId, flowId = FlowId.valueOf((long)this.number(payload, RoadmFlowViewMessageHandler.FLOW_ID)));
            if (entry == null) {
                RoadmFlowViewMessageHandler.this.log.error("Unable to find flow rule to set attenuation for device {}", (Object)deviceId);
                return;
            }
            ChannelData channelData = ChannelData.fromFlow((FlowRule)entry);
            PortNumber port = channelData.outPort();
            OchSignal signal = channelData.ochSignal();
            Range<Long> range = RoadmFlowViewMessageHandler.this.roadmService.attenuationRange(deviceId, port, signal);
            Long attenuation = payload.get(RoadmFlowViewMessageHandler.ATTENUATION).asLong();
            boolean bl = validAttenuation = range != null && range.contains((Comparable)attenuation);
            if (validAttenuation) {
                RoadmFlowViewMessageHandler.this.roadmService.setAttenuation(deviceId, port, signal, attenuation);
            }
            ObjectNode rootNode = RoadmFlowViewMessageHandler.this.objectNode();
            rootNode.put(RoadmFlowViewMessageHandler.FLOW_ID, payload.get(RoadmFlowViewMessageHandler.FLOW_ID).asText());
            rootNode.put("valid", validAttenuation);
            if (range == null) {
                rootNode.put("message", NO_ATTENUATION_MSG);
            } else {
                rootNode.put("message", String.format(ATTENUATION_RANGE_MSG, range.toString()));
            }
            this.sendMessage(RoadmFlowViewMessageHandler.ROADM_SET_ATTENUATION_RESP, rootNode);
        }

        private FlowEntry findFlow(DeviceId deviceId, FlowId flowId) {
            for (FlowEntry entry : RoadmFlowViewMessageHandler.this.flowRuleService.getFlowEntries(deviceId)) {
                if (!entry.id().equals((Object)flowId)) continue;
                return entry;
            }
            return null;
        }
    }

    private final class FlowTableDataRequestHandler
    extends TableRequestHandler {
        private FlowTableDataRequestHandler() {
            super(RoadmFlowViewMessageHandler.ROADM_FLOW_DATA_REQ, RoadmFlowViewMessageHandler.ROADM_FLOW_DATA_RESP, RoadmFlowViewMessageHandler.ROADM_FLOWS);
        }

        protected String[] getColumnIds() {
            return COLUMN_IDS;
        }

        protected String noRowsMessage(ObjectNode payload) {
            return "No items found";
        }

        protected TableModel createTableModel() {
            TableModel tm = super.createTableModel();
            tm.setFormatter(RoadmFlowViewMessageHandler.FLOW_ID, HexLongFormatter.INSTANCE);
            return tm;
        }

        protected void populateTable(TableModel tm, ObjectNode payload) {
            DeviceId deviceId = DeviceId.deviceId((String)this.string(payload, "devId"));
            Iterable flowEntries = RoadmFlowViewMessageHandler.this.flowRuleService.getFlowEntries(deviceId);
            for (FlowEntry flowEntry : flowEntries) {
                this.populateRow(tm.addRow(), flowEntry, deviceId);
            }
        }

        private void populateRow(TableModel.Row row, FlowEntry entry, DeviceId deviceId) {
            ChannelData cd = ChannelData.fromFlow((FlowRule)entry);
            String spacing = "N/A";
            String multiplier = "N/A";
            String channelFrequency = "";
            OchSignal ochSignal = cd.ochSignal();
            if (ochSignal != null) {
                Frequency spacingFreq = ochSignal.channelSpacing().frequency();
                spacing = RoadmUtil.asGHz(spacingFreq);
                int spacingMult = ochSignal.spacingMultiplier();
                multiplier = String.valueOf(spacingMult);
                channelFrequency = String.format(" (%sGHz)", RoadmUtil.asGHz(Spectrum.CENTER_FREQUENCY.add(spacingFreq.multiply((long)spacingMult))));
            }
            row.cell(RoadmFlowViewMessageHandler.ID, (Object)entry.id().value()).cell(RoadmFlowViewMessageHandler.FLOW_ID, (Object)entry.id().value()).cell(RoadmFlowViewMessageHandler.APP_ID, (Object)entry.appId()).cell(RoadmFlowViewMessageHandler.PRIORITY, (Object)entry.priority()).cell(RoadmFlowViewMessageHandler.TIMEOUT, (Object)entry.timeout()).cell(RoadmFlowViewMessageHandler.PERMANENT, (Object)entry.isPermanent()).cell(RoadmFlowViewMessageHandler.STATE, (Object)entry.state().toString()).cell(RoadmFlowViewMessageHandler.IN_PORT, (Object)cd.inPort().toLong()).cell(RoadmFlowViewMessageHandler.OUT_PORT, (Object)cd.outPort().toLong()).cell(RoadmFlowViewMessageHandler.CHANNEL_SPACING, (Object)spacing).cell(RoadmFlowViewMessageHandler.CHANNEL_MULTIPLIER, (Object)multiplier).cell(RoadmFlowViewMessageHandler.CHANNEL_FREQUENCY, (Object)channelFrequency).cell(RoadmFlowViewMessageHandler.CURRENT_POWER, (Object)this.getCurrentPower(deviceId, cd)).cell(RoadmFlowViewMessageHandler.HAS_ATTENUATION, (Object)this.hasAttenuation(deviceId, cd)).cell(RoadmFlowViewMessageHandler.ATTENUATION, (Object)this.getAttenuation(deviceId, cd));
        }

        private String getCurrentPower(DeviceId deviceId, ChannelData channelData) {
            if (this.hasAttenuation(deviceId, channelData)) {
                Long currentPower = RoadmFlowViewMessageHandler.this.roadmService.getCurrentChannelPower(deviceId, channelData.outPort(), channelData.ochSignal());
                return RoadmUtil.objectToString(currentPower, "Unknown");
            }
            Device.Type devType = RoadmFlowViewMessageHandler.this.deviceService.getDevice(deviceId).type();
            PortNumber port = devType == Device.Type.FIBER_SWITCH ? channelData.inPort() : channelData.outPort();
            Long currentPower = RoadmFlowViewMessageHandler.this.roadmService.getCurrentPortPower(deviceId, port);
            return RoadmUtil.objectToString(currentPower, "Unknown");
        }

        private String getAttenuation(DeviceId deviceId, ChannelData channelData) {
            OchSignal signal = channelData.ochSignal();
            if (signal == null) {
                return "N/A";
            }
            Long attenuation = RoadmFlowViewMessageHandler.this.roadmService.getAttenuation(deviceId, channelData.outPort(), signal);
            return RoadmUtil.objectToString(attenuation, "Unknown");
        }

        private boolean hasAttenuation(DeviceId deviceId, ChannelData channelData) {
            OchSignal signal = channelData.ochSignal();
            if (signal == null) {
                return false;
            }
            return RoadmFlowViewMessageHandler.this.roadmService.attenuationRange(deviceId, channelData.outPort(), signal) != null;
        }
    }
}

