/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.roadm;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.roadm.RoadmUtil;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.table.TableModel;
import org.onosproject.ui.table.TableRequestHandler;

public class RoadmDeviceViewMessageHandler
extends UiMessageHandler {
    private static final String ROADM_DEVICE_DATA_REQ = "roadmDeviceDataRequest";
    private static final String ROADM_DEVICE_DATA_RESP = "roadmDeviceDataResponse";
    private static final String ROADM_DEVICES = "roadmDevices";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String MASTER = "master";
    private static final String PORTS = "ports";
    private static final String VENDOR = "vendor";
    private static final String HW_VERSION = "hwVersion";
    private static final String SW_VERSION = "swVersion";
    private static final String PROTOCOL = "protocol";
    private static final String[] COLUMN_IDS = new String[]{"id", "name", "type", "master", "ports", "vendor", "hwVersion", "swVersion", "protocol"};
    private DeviceService deviceService;
    private MastershipService mastershipService;

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.deviceService = (DeviceService)this.get(DeviceService.class);
        this.mastershipService = (MastershipService)this.get(MastershipService.class);
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new DeviceTableDataRequestHandler()));
    }

    private final class DeviceTableDataRequestHandler
    extends TableRequestHandler {
        private DeviceTableDataRequestHandler() {
            super(RoadmDeviceViewMessageHandler.ROADM_DEVICE_DATA_REQ, RoadmDeviceViewMessageHandler.ROADM_DEVICE_DATA_RESP, RoadmDeviceViewMessageHandler.ROADM_DEVICES);
        }

        protected String[] getColumnIds() {
            return COLUMN_IDS;
        }

        protected String noRowsMessage(ObjectNode payload) {
            return "No items found";
        }

        protected void populateTable(TableModel tm, ObjectNode payload) {
            for (Device device : RoadmDeviceViewMessageHandler.this.deviceService.getDevices()) {
                Device.Type type = device.type();
                if (type != Device.Type.ROADM && type != Device.Type.OPTICAL_AMPLIFIER && type != Device.Type.FIBER_SWITCH) continue;
                this.populateRow(tm.addRow(), device);
            }
        }

        private void populateRow(TableModel.Row row, Device device) {
            DeviceId devId = device.id();
            String id = devId.toString();
            row.cell(RoadmDeviceViewMessageHandler.ID, (Object)id).cell(RoadmDeviceViewMessageHandler.NAME, (Object)RoadmUtil.getAnnotation(device.annotations(), "portName", id)).cell(RoadmDeviceViewMessageHandler.TYPE, (Object)RoadmUtil.objectToString(device.type(), "Unknown")).cell(RoadmDeviceViewMessageHandler.MASTER, (Object)RoadmDeviceViewMessageHandler.this.mastershipService.getMasterFor(devId)).cell(RoadmDeviceViewMessageHandler.PORTS, (Object)RoadmDeviceViewMessageHandler.this.deviceService.getPorts(devId).size()).cell(RoadmDeviceViewMessageHandler.VENDOR, (Object)device.manufacturer()).cell(RoadmDeviceViewMessageHandler.HW_VERSION, (Object)device.hwVersion()).cell(RoadmDeviceViewMessageHandler.SW_VERSION, (Object)device.swVersion()).cell(RoadmDeviceViewMessageHandler.PROTOCOL, (Object)RoadmUtil.getAnnotation(device.annotations(), RoadmDeviceViewMessageHandler.PROTOCOL));
        }
    }
}

