/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.roadm;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.roadm.RoadmDeviceViewMessageHandler;
import org.onosproject.roadm.RoadmFlowViewMessageHandler;
import org.onosproject.roadm.RoadmPortViewMessageHandler;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.onosproject.ui.UiView;
import org.onosproject.ui.UiViewHidden;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class RoadmComponent {
    private static final String DEVICE_VIEW_ID = "roadmDevice";
    private static final String DEVICE_VIEW_TEXT = "ROADM";
    private static final String RESOURCE_PATH = "webgui";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected UiExtensionService uiExtensionService;
    private final List<UiView> deviceViews = ImmutableList.of((Object)new UiView(UiView.Category.OTHER, "roadmDevice", "ROADM"), (Object)new UiViewHidden("roadmPort"), (Object)new UiViewHidden("roadmFlow"));
    private final UiMessageHandlerFactory messageHandlerFactory = () -> ImmutableList.of((Object)((Object)new RoadmDeviceViewMessageHandler()), (Object)((Object)new RoadmPortViewMessageHandler()), (Object)((Object)new RoadmFlowViewMessageHandler()));
    protected UiExtension deviceExtension = new UiExtension.Builder(this.getClass().getClassLoader(), this.deviceViews).resourcePath("webgui").messageHandlerFactory(this.messageHandlerFactory).build();

    @Activate
    protected void activate() {
        this.uiExtensionService.register(this.deviceExtension);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.uiExtensionService.unregister(this.deviceExtension);
        this.log.info("Stopped");
    }

    protected void bindUiExtensionService(UiExtensionService uiExtensionService) {
        this.uiExtensionService = uiExtensionService;
    }

    protected void unbindUiExtensionService(UiExtensionService uiExtensionService) {
        if (this.uiExtensionService == uiExtensionService) {
            this.uiExtensionService = null;
        }
    }
}

