/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.roadm;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.roadm.RoadmStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedRoadmStore
implements RoadmStore {
    private static Logger log = LoggerFactory.getLogger(DistributedRoadmStore.class);
    private ConsistentMap<DeviceId, Map<PortNumber, Long>> distPowerMap;
    private Map<DeviceId, Map<PortNumber, Long>> powerMap;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;

    @Activate
    public void activate() {
        this.distPowerMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-roadm-distributed-store")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build();
        this.powerMap = this.distPowerMap.asJavaMap();
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        log.info("Stopped");
    }

    @Override
    public void addDevice(DeviceId deviceId) {
        this.powerMap.putIfAbsent(deviceId, new HashMap());
        log.info("Initializing {}", (Object)deviceId);
    }

    @Override
    public boolean deviceAvailable(DeviceId deviceId) {
        return this.powerMap.get(deviceId) != null;
    }

    @Override
    public void setTargetPower(DeviceId deviceId, PortNumber portNumber, long targetPower) {
        Map<PortNumber, Long> portMap = this.powerMap.get(deviceId);
        if (portMap != null) {
            portMap.put(portNumber, targetPower);
            this.powerMap.put(deviceId, portMap);
        } else {
            log.info("Device {} not found in store", (Object)deviceId);
        }
    }

    @Override
    public Long getTargetPower(DeviceId deviceId, PortNumber portNumber) {
        Map<PortNumber, Long> portMap = this.powerMap.get(deviceId);
        if (portMap != null) {
            return portMap.get(portNumber);
        }
        return null;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

