/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.roadm;

import com.google.common.base.Preconditions;
import java.util.List;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.OchSignalCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;

public final class ChannelData {
    private PortNumber inPort;
    private PortNumber outPort;
    private OchSignal ochSignal;

    private ChannelData(PortNumber inPort, PortNumber outPort, OchSignal ochSignal) {
        this.inPort = inPort;
        this.outPort = outPort;
        this.ochSignal = ochSignal;
    }

    public static ChannelData fromFlow(FlowRule rule) {
        Preconditions.checkNotNull((Object)rule);
        Criterion in = rule.selector().getCriterion(Criterion.Type.IN_PORT);
        Preconditions.checkNotNull((Object)in);
        PortNumber inPort = ((PortCriterion)in).port();
        Criterion och = rule.selector().getCriterion(Criterion.Type.OCH_SIGID);
        OchSignal ochSignal = och == null ? null : ((OchSignalCriterion)och).lambda();
        PortNumber outPort = null;
        List instructions = rule.treatment().allInstructions();
        for (Instruction ins : instructions) {
            if (ins.type() != Instruction.Type.OUTPUT) continue;
            outPort = ((Instructions.OutputInstruction)ins).port();
        }
        Preconditions.checkNotNull(outPort);
        return new ChannelData(inPort, outPort, ochSignal);
    }

    public PortNumber inPort() {
        return this.inPort;
    }

    public PortNumber outPort() {
        return this.outPort;
    }

    public OchSignal ochSignal() {
        return this.ochSignal;
    }
}

