/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPrefixAttrRouteTag
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(BgpPrefixAttrRouteTag.class);
    public static final short ATTR_PREFIX_ROUTETAG = 1153;
    public static final short SIZE = 4;
    private List<Integer> pfxRouteTag = new ArrayList<Integer>();

    public BgpPrefixAttrRouteTag(List<Integer> pfxRouteTag) {
        this.pfxRouteTag = pfxRouteTag;
    }

    public static BgpPrefixAttrRouteTag of(ArrayList<Integer> pfxRouteTag) {
        return new BgpPrefixAttrRouteTag(pfxRouteTag);
    }

    public static BgpPrefixAttrRouteTag read(ChannelBuffer cb) throws BgpParseException {
        ArrayList<Integer> pfxRouteTag = new ArrayList<Integer>();
        short lsAttrLength = cb.readShort();
        int len = lsAttrLength / 4;
        if (cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        for (int i = 0; i < len; ++i) {
            int tmp = cb.readInt();
            pfxRouteTag.add(new Integer(tmp));
        }
        return BgpPrefixAttrRouteTag.of(pfxRouteTag);
    }

    public List<Integer> getPfxRouteTag() {
        return this.pfxRouteTag;
    }

    @Override
    public short getType() {
        return 1153;
    }

    public int hashCode() {
        return Objects.hash(this.pfxRouteTag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpPrefixAttrRouteTag) {
            BgpPrefixAttrRouteTag other = (BgpPrefixAttrRouteTag)obj;
            return Objects.equals(this.pfxRouteTag, other.pfxRouteTag);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("pfxRouteTag", this.pfxRouteTag).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

