/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.attr.WideCommunity;

public class WideCommunityParameter
implements BgpValueType {
    public static final byte TYPE = 3;
    private List<BgpValueType> parameterTlv;

    public WideCommunityParameter(List<BgpValueType> parameterTlv) {
        this.parameterTlv = parameterTlv;
    }

    public static WideCommunityParameter of(List<BgpValueType> parameterTlv) {
        return new WideCommunityParameter(parameterTlv);
    }

    public List<BgpValueType> parameterTlv() {
        return this.parameterTlv;
    }

    public void setParameterTlv(List<BgpValueType> parameterTlv) {
        this.parameterTlv = parameterTlv;
    }

    public int hashCode() {
        return Objects.hash(this.parameterTlv);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WideCommunityParameter) {
            WideCommunityParameter other = (WideCommunityParameter)obj;
            return Objects.equals(this.parameterTlv, other.parameterTlv);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        WideCommunity.encodeWideCommunityTlv(c, this.parameterTlv());
        return c.writerIndex() - iLenStartIndex;
    }

    public static WideCommunityParameter read(ChannelBuffer c) throws BgpParseException {
        return new WideCommunityParameter(WideCommunity.decodeWideCommunityTlv(c));
    }

    @Override
    public short getType() {
        return 3;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("Type", 3).add("parameterTlv", this.parameterTlv).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

