/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip4Address;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class NextHop
implements BgpValueType {
    public static final byte NEXTHOP_TYPE = 3;
    public static final byte FLAGS = 64;
    private boolean isNextHop = false;
    private Ip4Address nextHop;

    public NextHop(Ip4Address nextHop) {
        this.nextHop = (Ip4Address)Preconditions.checkNotNull((Object)nextHop);
        this.isNextHop = true;
    }

    public NextHop() {
        this.nextHop = null;
    }

    public boolean isNextHopSet() {
        return this.isNextHop;
    }

    public static NextHop read(ChannelBuffer cb) throws BgpParseException {
        ChannelBuffer tempCb = cb.copy();
        Validation parseFlags = Validation.parseAttributeHeader(cb);
        if (cb.readableBytes() < parseFlags.getLength()) {
            Validation.validateLen((byte)3, (byte)5, parseFlags.getLength());
        }
        int len = parseFlags.isShort() ? parseFlags.getLength() + 4 : parseFlags.getLength() + 3;
        ChannelBuffer data = tempCb.readBytes(len);
        if (parseFlags.getFirstBit() && !parseFlags.getSecondBit() && parseFlags.getThirdBit()) {
            throw new BgpParseException(3, 4, data);
        }
        InetAddress ipAddress = Validation.toInetAddress(parseFlags.getLength(), cb);
        if (ipAddress.isMulticastAddress()) {
            throw new BgpParseException("Multicast address is not supported");
        }
        Ip4Address nextHop = Ip4Address.valueOf((InetAddress)ipAddress);
        return new NextHop(nextHop);
    }

    public Ip4Address nextHop() {
        return this.nextHop;
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeByte(64);
        cb.writeByte((int)this.getType());
        if (!this.isNextHopSet()) {
            cb.writeByte(0);
        } else {
            cb.writeInt(this.nextHop.toInt());
        }
        return cb.writerIndex() - iLenStartIndex;
    }

    public int hashCode() {
        return Objects.hash(this.nextHop);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NextHop) {
            NextHop other = (NextHop)obj;
            return Objects.equals(this.nextHop, other.nextHop);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("nextHop", (Object)this.nextHop).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

