/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;

public class BgpFsActionReDirect
implements BgpValueType {
    public static final short TYPE = -32760;
    private byte[] routeTarget;
    public static final byte ROUTE_TARGET_LEN = 6;

    public BgpFsActionReDirect(byte[] routeTarget) {
        this.routeTarget = Arrays.copyOf(routeTarget, routeTarget.length);
    }

    @Override
    public short getType() {
        return -32760;
    }

    public int hashCode() {
        return Arrays.hashCode(this.routeTarget);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpFsActionReDirect) {
            BgpFsActionReDirect other = (BgpFsActionReDirect)obj;
            return Arrays.equals(this.routeTarget, other.routeTarget);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeShort(-32760);
        cb.writeBytes(this.routeTarget);
        return cb.writerIndex() - iLenStartIndex;
    }

    public static BgpFsActionReDirect read(ChannelBuffer cb) throws BgpParseException {
        byte[] routeTarget = cb.readBytes(6).array();
        return new BgpFsActionReDirect(routeTarget);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("TYPE", -32760).add("routeTarget", (Object)this.routeTarget).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

