/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.AsPath;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class As4Path
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(AsPath.class);
    public static final byte AS4PATH_TYPE = 17;
    public static final byte ASNUM_SIZE = 4;
    public static final byte FLAGS = 64;
    private List<Integer> as4pathSet;
    private List<Integer> as4pathSeq;

    public As4Path() {
        this.as4pathSeq = null;
        this.as4pathSet = null;
    }

    public As4Path(List<Integer> as4pathSet, List<Integer> as4pathSeq) {
        this.as4pathSeq = as4pathSeq;
        this.as4pathSet = as4pathSet;
    }

    public static As4Path read(ChannelBuffer cb) throws BgpParseException {
        ArrayList<Integer> as4pathSet = new ArrayList<Integer>();
        ArrayList<Integer> as4pathSeq = new ArrayList<Integer>();
        ChannelBuffer tempCb = cb.copy();
        Validation validation = Validation.parseAttributeHeader(cb);
        if (cb.readableBytes() < validation.getLength()) {
            Validation.validateLen((byte)3, (byte)5, validation.getLength());
        }
        int len = validation.isShort() ? validation.getLength() + 4 : validation.getLength() + 3;
        ChannelBuffer data = tempCb.readBytes(len);
        if (validation.getFirstBit() && !validation.getSecondBit() && validation.getThirdBit()) {
            throw new BgpParseException(3, 4, data);
        }
        ChannelBuffer tempBuf = cb.readBytes(validation.getLength());
        while (tempBuf.readableBytes() > 0) {
            byte pathSegType = tempBuf.readByte();
            byte pathSegLen = tempBuf.readByte();
            int length = pathSegLen * 4;
            if (tempBuf.readableBytes() < length) {
                Validation.validateLen((byte)3, (byte)5, length);
            }
            ChannelBuffer aspathBuf = tempBuf.readBytes(length);
            block5: while (aspathBuf.readableBytes() > 0) {
                int asNum = aspathBuf.readInt();
                switch (pathSegType) {
                    case 1: {
                        as4pathSet.add(asNum);
                        continue block5;
                    }
                    case 2: {
                        as4pathSeq.add(asNum);
                        continue block5;
                    }
                }
                log.debug("Other type Not Supported:" + pathSegType);
            }
        }
        return new As4Path(as4pathSet, as4pathSeq);
    }

    @Override
    public short getType() {
        return 17;
    }

    public List<Integer> as4PathSeq() {
        return this.as4pathSeq;
    }

    public List<Integer> as4PathSet() {
        return this.as4pathSet;
    }

    public int hashCode() {
        return Objects.hash(this.as4pathSet, this.as4pathSeq);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof As4Path) {
            As4Path other = (As4Path)obj;
            return Objects.equals(this.as4pathSet, other.as4pathSet) && Objects.equals(this.as4pathSeq, other.as4pathSeq);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("as4pathSet", this.as4pathSet).add("as4pathSeq", this.as4pathSeq).toString();
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeByte(64);
        cb.writeByte((int)this.getType());
        if (this.as4pathSet != null && this.as4pathSeq != null) {
            int iAsLenIndex = cb.writerIndex();
            cb.writeByte(0);
            if (!this.as4pathSeq.isEmpty()) {
                cb.writeByte(2);
                cb.writeByte(this.as4pathSeq.size());
                for (int j = 0; j < this.as4pathSeq.size(); ++j) {
                    cb.writeInt(this.as4pathSeq.get(j).intValue());
                }
                int asLen = cb.writerIndex() - iAsLenIndex;
                cb.setByte(iAsLenIndex, (int)((byte)(asLen - 1)));
            }
        } else {
            cb.writeByte(0);
        }
        return cb.writerIndex() - iLenStartIndex;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

