/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.topology.impl;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pcep.api.DeviceCapability;
import org.onosproject.pcep.api.PcepController;
import org.onosproject.pcep.api.PcepDpid;
import org.onosproject.pcep.api.PcepLink;
import org.onosproject.pcep.api.PcepLinkListener;
import org.onosproject.pcep.api.PcepOperator;
import org.onosproject.pcep.api.PcepSwitch;
import org.onosproject.pcep.api.PcepSwitchListener;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepClientController;
import org.onosproject.pcep.controller.PcepNodeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class PcepTopologyProvider
extends AbstractProvider
implements LinkProvider,
DeviceProvider {
    private static final Logger log = LoggerFactory.getLogger(PcepTopologyProvider.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry linkProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry deviceProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PcepController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PcepClientController pcepClientController;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry netConfigRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService netConfigService;
    private DeviceProviderService deviceProviderService;
    private LinkProviderService linkProviderService;
    private HashMap<Long, List<PortDescription>> portMap = new HashMap();
    private InternalLinkProvider listener = new InternalLinkProvider();
    private final ConfigFactory<DeviceId, DeviceCapability> configFactory = new ConfigFactory<DeviceId, DeviceCapability>(SubjectFactories.DEVICE_SUBJECT_FACTORY, DeviceCapability.class, "deviceCapability", false){

        public DeviceCapability createConfig() {
            return new DeviceCapability();
        }
    };

    public PcepTopologyProvider() {
        super(new ProviderId("l3", "org.onosproject.provider.pcep", true));
    }

    @Activate
    public void activate() {
        this.linkProviderService = (LinkProviderService)this.linkProviderRegistry.register((Provider)this);
        this.deviceProviderService = (DeviceProviderService)this.deviceProviderRegistry.register((Provider)this);
        this.controller.addListener((PcepSwitchListener)this.listener);
        this.controller.addLinkListener((PcepLinkListener)this.listener);
        this.pcepClientController.addNodeListener((PcepNodeListener)this.listener);
        this.netConfigRegistry.registerConfigFactory(this.configFactory);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.linkProviderRegistry.unregister((Provider)this);
        this.linkProviderService = null;
        this.controller.removeListener((PcepSwitchListener)this.listener);
        this.controller.removeLinkListener((PcepLinkListener)this.listener);
        this.pcepClientController.removeNodeListener((PcepNodeListener)this.listener);
        this.netConfigRegistry.unregisterConfigFactory(this.configFactory);
        log.info("Stopped");
    }

    private List<PortDescription> buildPortDescriptions(PcepDpid dpid, Port port) {
        List<Object> portList = this.portMap.containsKey(dpid.value()) ? this.portMap.get(dpid.value()) : new ArrayList();
        if (port != null) {
            DefaultAnnotations annotations = DefaultAnnotations.builder().putAll(port.annotations()).build();
            portList.add((PortDescription)new DefaultPortDescription(port.number(), port.isEnabled(), port.type(), port.portSpeed(), new SparseAnnotations[]{annotations}));
        }
        this.portMap.put(dpid.value(), portList);
        return portList;
    }

    private LinkDescription buildLinkDescription(PcepLink pceLink) {
        Preconditions.checkNotNull((Object)pceLink);
        DeviceId srcDeviceID = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pceLink.linkSrcDeviceID()));
        DeviceId dstDeviceID = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pceLink.linkDstDeviceId()));
        this.deviceProviderService.updatePorts(srcDeviceID, this.buildPortDescriptions(pceLink.linkSrcDeviceID(), pceLink.linkSrcPort()));
        this.deviceProviderService.updatePorts(dstDeviceID, this.buildPortDescriptions(pceLink.linkDstDeviceId(), pceLink.linkDstPort()));
        ConnectPoint src = new ConnectPoint((ElementId)srcDeviceID, pceLink.linkSrcPort().number());
        ConnectPoint dst = new ConnectPoint((ElementId)dstDeviceID, pceLink.linkDstPort().number());
        DefaultAnnotations extendedAttributes = DefaultAnnotations.builder().set("subType", String.valueOf(pceLink.linkSubType())).set("workState", pceLink.linkState()).set("distance", String.valueOf(pceLink.linkDistance())).set("capType", pceLink.linkCapacityType().toLowerCase()).set("avail_" + pceLink.linkCapacityType().toLowerCase(), String.valueOf(pceLink.linkAvailValue())).set("max_" + pceLink.linkCapacityType().toLowerCase(), String.valueOf(pceLink.linkMaxValue())).build();
        DefaultLinkDescription ld = new DefaultLinkDescription(src, dst, Link.Type.OPTICAL, new SparseAnnotations[]{extendedAttributes});
        return ld;
    }

    public void triggerProbe(DeviceId deviceId) {
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
    }

    public boolean isReachable(DeviceId deviceId) {
        return true;
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
    }

    protected void bindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.linkProviderRegistry = linkProviderRegistry;
    }

    protected void unbindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.linkProviderRegistry == linkProviderRegistry) {
            this.linkProviderRegistry = null;
        }
    }

    protected void bindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.deviceProviderRegistry = deviceProviderRegistry;
    }

    protected void unbindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.deviceProviderRegistry == deviceProviderRegistry) {
            this.deviceProviderRegistry = null;
        }
    }

    protected void bindController(PcepController pcepController) {
        this.controller = pcepController;
    }

    protected void unbindController(PcepController pcepController) {
        if (this.controller == pcepController) {
            this.controller = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindPcepClientController(PcepClientController pcepClientController) {
        this.pcepClientController = pcepClientController;
    }

    protected void unbindPcepClientController(PcepClientController pcepClientController) {
        if (this.pcepClientController == pcepClientController) {
            this.pcepClientController = null;
        }
    }

    protected void bindNetConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.netConfigRegistry = networkConfigRegistry;
    }

    protected void unbindNetConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.netConfigRegistry == networkConfigRegistry) {
            this.netConfigRegistry = null;
        }
    }

    protected void bindNetConfigService(NetworkConfigService networkConfigService) {
        this.netConfigService = networkConfigService;
    }

    protected void unbindNetConfigService(NetworkConfigService networkConfigService) {
        if (this.netConfigService == networkConfigService) {
            this.netConfigService = null;
        }
    }

    private class InternalLinkProvider
    implements PcepSwitchListener,
    PcepLinkListener,
    PcepNodeListener {
        private InternalLinkProvider() {
        }

        public void switchAdded(PcepDpid dpid) {
            Device.Type deviceType;
            if (PcepTopologyProvider.this.deviceProviderService == null) {
                return;
            }
            DeviceId deviceId = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)dpid));
            PcepSwitch sw = PcepTopologyProvider.this.controller.getSwitch(dpid);
            Preconditions.checkNotNull((Object)sw, (Object)"device should not null.");
            ChassisId cId = new ChassisId(dpid.value());
            switch (sw.getDeviceType()) {
                case ROADM: {
                    deviceType = Device.Type.ROADM;
                    break;
                }
                case OTN: {
                    deviceType = Device.Type.SWITCH;
                    break;
                }
                case ROUTER: {
                    deviceType = Device.Type.ROUTER;
                    break;
                }
                default: {
                    deviceType = Device.Type.OTHER;
                }
            }
            DefaultDeviceDescription description = new DefaultDeviceDescription(deviceId.uri(), deviceType, sw.manufacturerDescription(), sw.hardwareDescription(), sw.softwareDescription(), sw.serialNumber(), cId, new SparseAnnotations[0]);
            PcepTopologyProvider.this.deviceProviderService.deviceConnected(deviceId, (DeviceDescription)description);
        }

        public void switchRemoved(PcepDpid dpid) {
            if (PcepTopologyProvider.this.deviceProviderService == null || PcepTopologyProvider.this.linkProviderService == null) {
                return;
            }
            PcepTopologyProvider.this.deviceProviderService.deviceDisconnected(DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)dpid)));
            PcepTopologyProvider.this.linkProviderService.linksVanished(DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)dpid)));
        }

        public void switchChanged(PcepDpid dpid) {
        }

        public void handlePceplink(PcepLink link) {
            PcepOperator.OperationType operType = link.getOperationType();
            LinkDescription ld = PcepTopologyProvider.this.buildLinkDescription(link);
            if (ld == null) {
                log.error("Invalid link info.");
                return;
            }
            switch (operType) {
                case ADD: 
                case UPDATE: {
                    PcepTopologyProvider.this.linkProviderService.linkDetected(ld);
                    break;
                }
                case DELETE: {
                    PcepTopologyProvider.this.linkProviderService.linkVanished(ld);
                    break;
                }
            }
        }

        public void addDevicePcepConfig(PcepClient pc) {
            if (PcepTopologyProvider.this.netConfigRegistry == null) {
                log.error("Cannot add PCEP device capability as network config service is not available.");
                return;
            }
            DeviceId pccDeviceId = DeviceId.deviceId((String)String.valueOf(pc.getPccId().ipAddress()));
            DeviceCapability deviceCap = (DeviceCapability)PcepTopologyProvider.this.netConfigService.addConfig((Object)pccDeviceId, DeviceCapability.class);
            deviceCap.setLabelStackCap(pc.capability().labelStackCapability()).setLocalLabelCap(pc.capability().pceccCapability()).setSrCap(pc.capability().srCapability()).apply();
        }

        public void deleteDevicePcepConfig(PccId pccId) {
            if (PcepTopologyProvider.this.netConfigRegistry == null) {
                log.error("Cannot remove PCEP device capability as network config service is not available.");
                return;
            }
            DeviceId pccDeviceId = DeviceId.deviceId((String)String.valueOf(pccId.ipAddress()));
            PcepTopologyProvider.this.netConfigService.removeConfig((Object)pccDeviceId, DeviceCapability.class);
        }
    }
}

