/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.List;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.Router;
import org.onosproject.vtnweb.web.RouterGatewayInfoCodec;

public class RouterCodec
extends JsonCodec<Router> {
    public ObjectNode encode(Router router, CodecContext context) {
        Preconditions.checkNotNull((Object)router, (Object)"router cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put("id", router.id().routerId()).put("status", router.status().toString()).put("name", router.name().toString()).put("admin_state_up", router.adminStateUp()).put("tenant_id", router.tenantId().toString()).put("routes", router.routes() == null ? null : router.routes().toString());
        result.set("external_gateway_info", router.externalGatewayInfo() == null ? null : new RouterGatewayInfoCodec().encode(router.externalGatewayInfo(), context));
        return result;
    }

    public ObjectNode extracFields(Router router, CodecContext context, List<String> fields) {
        Preconditions.checkNotNull((Object)router, (Object)"router cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        for (String s : fields) {
            if ("id".equals(s)) {
                result.put("id", router.id().routerId());
            }
            if ("status".equals(s)) {
                result.put("status", router.status().toString());
            }
            if ("name".equals(s)) {
                result.put("name", router.name().toString());
            }
            if ("admin_state_up".equals(s)) {
                result.put("admin_state_up", router.adminStateUp());
            }
            if ("tenant_id".equals(s)) {
                result.put("tenant_id", router.tenantId().toString());
            }
            if ("routes".equals(s)) {
                result.put("routes", router.routes() == null ? null : router.routes().toString());
            }
            if (!"external_gateway_info".equals(s)) continue;
            result.set("external_gateway_info", router.externalGatewayInfo() == null ? null : new RouterGatewayInfoCodec().encode(router.externalGatewayInfo(), context));
        }
        return result;
    }
}

