/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.CoreService;
import org.onosproject.vtnrsc.DefaultPortPairGroup;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.TenantId;

public final class PortPairGroupCodec
extends JsonCodec<PortPairGroup> {
    private static final String ID = "id";
    private static final String TENANT_ID = "tenant_id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String PORT_PAIRS = "port_pairs";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in PortPairGroup";

    public PortPairGroup decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        DefaultPortPairGroup.Builder resultBuilder = new DefaultPortPairGroup.Builder();
        CoreService coreService = (CoreService)context.getService(CoreService.class);
        String id = ((JsonNode)Tools.nullIsIllegal((Object)json.get(ID), (String)"id member is required in PortPairGroup")).asText();
        resultBuilder.setId(PortPairGroupId.of((String)id));
        String tenantId = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TENANT_ID), (String)"tenant_id member is required in PortPairGroup")).asText();
        resultBuilder.setTenantId(TenantId.tenantId((String)tenantId));
        String name = ((JsonNode)Tools.nullIsIllegal((Object)json.get(NAME), (String)"name member is required in PortPairGroup")).asText();
        resultBuilder.setName(name);
        String description = ((JsonNode)Tools.nullIsIllegal((Object)json.get(DESCRIPTION), (String)"description member is required in PortPairGroup")).asText();
        resultBuilder.setDescription(description);
        ArrayList list = Lists.newArrayList();
        ArrayNode arrayNode = (ArrayNode)json.path(PORT_PAIRS);
        arrayNode.forEach(i -> list.add(PortPairId.of((String)i.asText())));
        resultBuilder.setPortPairs((List)list);
        return resultBuilder.build();
    }

    public ObjectNode encode(PortPairGroup portPairGroup, CodecContext context) {
        Preconditions.checkNotNull((Object)portPairGroup, (Object)"port pair group cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(ID, portPairGroup.portPairGroupId().toString()).put(TENANT_ID, portPairGroup.tenantId().toString()).put(NAME, portPairGroup.name()).put(DESCRIPTION, portPairGroup.description()).put(PORT_PAIRS, portPairGroup.portPairs().toString());
        return result;
    }
}

