/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.DefaultPortChain;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.TenantId;

public final class PortChainCodec
extends JsonCodec<PortChain> {
    private static final String ID = "id";
    private static final String TENANT_ID = "tenant_id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String PORT_PAIR_GROUPS = "port_pair_groups";
    private static final String FLOW_CLASSIFIERS = "flow_classifiers";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in PortChain";

    public PortChain decode(ObjectNode json, CodecContext context) {
        ArrayList list;
        if (json == null || !json.isObject()) {
            return null;
        }
        DefaultPortChain.Builder resultBuilder = new DefaultPortChain.Builder();
        String id = ((JsonNode)Tools.nullIsIllegal((Object)json.get(ID), (String)"id member is required in PortChain")).asText();
        resultBuilder.setId(PortChainId.of((String)id));
        String tenantId = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TENANT_ID), (String)"tenant_id member is required in PortChain")).asText();
        resultBuilder.setTenantId(TenantId.tenantId((String)tenantId));
        String name = ((JsonNode)Tools.nullIsIllegal((Object)json.get(NAME), (String)"name member is required in PortChain")).asText();
        resultBuilder.setName(name);
        String description = ((JsonNode)Tools.nullIsIllegal((Object)json.get(DESCRIPTION), (String)"description member is required in PortChain")).asText();
        resultBuilder.setDescription(description);
        ArrayNode arrayNode = (ArrayNode)json.path(PORT_PAIR_GROUPS);
        if (arrayNode != null) {
            list = Lists.newArrayList();
            arrayNode.forEach(i -> list.add(PortPairGroupId.of((String)i.asText())));
            resultBuilder.setPortPairGroups((List)list);
        }
        if ((arrayNode = (ArrayNode)json.path(FLOW_CLASSIFIERS)) != null) {
            list = Lists.newArrayList();
            arrayNode.forEach(i -> list.add(FlowClassifierId.of((UUID)UUID.fromString(i.asText()))));
            resultBuilder.setFlowClassifiers((List)list);
        }
        return resultBuilder.build();
    }

    public ObjectNode encode(PortChain portChain, CodecContext context) {
        Preconditions.checkNotNull((Object)portChain, (Object)"port pair cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(ID, portChain.portChainId().toString()).put(TENANT_ID, portChain.tenantId().toString()).put(NAME, portChain.name()).put(DESCRIPTION, portChain.description()).put(PORT_PAIR_GROUPS, portChain.portPairGroups().toString()).put(FLOW_CLASSIFIERS, portChain.flowClassifiers().toString());
        return result;
    }
}

