/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.vtnrsc.AllocationPool;
import org.onosproject.vtnrsc.DefaultAllocationPool;
import org.onosproject.vtnrsc.DefaultHostRoute;
import org.onosproject.vtnrsc.DefaultSubnet;
import org.onosproject.vtnrsc.HostRoute;
import org.onosproject.vtnrsc.Subnet;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.subnet.SubnetService;
import org.onosproject.vtnweb.web.SubnetCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="subnets")
public class SubnetWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(SubnetWebResource.class);
    public static final String SUBNET_NOT_CREATED = "Subnet failed to create!";
    public static final String SUBNET_NOT_FOUND = "Subnet is not found";
    public static final String JSON_NOT_NULL = "JsonNode can not be null";

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response listSubnets() {
        Iterable subnets = ((SubnetService)this.get(SubnetService.class)).getSubnets();
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("subnets", (JsonNode)new SubnetCodec().encode(subnets, (CodecContext)this));
        return SubnetWebResource.ok((Object)result.toString()).build();
    }

    @GET
    @Path(value="{subnetUUID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getSubnet(@PathParam(value="subnetUUID") String id) {
        if (!((SubnetService)this.get(SubnetService.class)).exists(SubnetId.subnetId((String)id))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Subnet is not found").build();
        }
        Subnet sub = (Subnet)this.nullIsNotFound((Object)((SubnetService)this.get(SubnetService.class)).getSubnet(SubnetId.subnetId((String)id)), "Subnet is not found");
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("subnet", (JsonNode)new SubnetCodec().encode(sub, (CodecContext)this));
        return SubnetWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createSubnet(InputStream input) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode subnode = mapper.readTree(input);
            Iterable subnets = this.createOrUpdateByInputStream(subnode);
            Boolean result = (Boolean)this.nullIsNotFound((Object)((SubnetService)this.get(SubnetService.class)).createSubnets(subnets), "Subnet failed to create!");
            if (!result.booleanValue()) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Subnet failed to create!").build();
            }
            return Response.status((int)202).entity((Object)result.toString()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString()).build();
        }
    }

    @PUT
    @Path(value="{subnetUUID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateSubnet(@PathParam(value="id") String id, InputStream input) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode subnode = mapper.readTree(input);
            Iterable subnets = this.createOrUpdateByInputStream(subnode);
            Boolean result = (Boolean)this.nullIsNotFound((Object)((SubnetService)this.get(SubnetService.class)).updateSubnets(subnets), "Subnet is not found");
            if (!result.booleanValue()) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Subnet is not found").build();
            }
            return Response.status((int)203).entity((Object)result.toString()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString()).build();
        }
    }

    @DELETE
    @Path(value="{subnetUUID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteSingleSubnet(@PathParam(value="subnetUUID") String id) throws IOException {
        try {
            SubnetId subId = SubnetId.subnetId((String)id);
            HashSet<SubnetId> subIds = new HashSet<SubnetId>();
            subIds.add(subId);
            ((SubnetService)this.get(SubnetService.class)).removeSubnets(subIds);
            return Response.noContent().entity((Object)"SUCCESS").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString()).build();
        }
    }

    private Iterable<Subnet> createOrUpdateByInputStream(JsonNode subnode) {
        Preconditions.checkNotNull((Object)subnode, (Object)"JsonNode can not be null");
        Iterable subnets = null;
        JsonNode subnetNodes = subnode.get("subnets");
        if (subnetNodes == null) {
            subnetNodes = subnode.get("subnet");
        }
        this.log.debug("subnetNodes is {}", (Object)subnetNodes.toString());
        subnets = subnetNodes.isArray() ? this.changeJsonToSubs(subnetNodes) : this.changeJsonToSub(subnetNodes);
        return subnets;
    }

    public Iterable<Subnet> changeJsonToSubs(JsonNode subnetNodes) {
        Preconditions.checkNotNull((Object)subnetNodes, (Object)"JsonNode can not be null");
        HashMap<SubnetId, DefaultSubnet> subMap = new HashMap<SubnetId, DefaultSubnet>();
        for (JsonNode subnetNode : subnetNodes) {
            IpAddress.Version ipVersion;
            String version;
            if (!subnetNode.hasNonNull("id")) {
                return null;
            }
            SubnetId id = SubnetId.subnetId((String)subnetNode.get("id").asText());
            String subnetName = subnetNode.get("name").asText();
            TenantId tenantId = TenantId.tenantId((String)subnetNode.get("tenant_id").asText());
            TenantNetworkId networkId = TenantNetworkId.networkId((String)subnetNode.get("network_id").asText());
            switch (version = subnetNode.get("ip_version").asText()) {
                case "4": {
                    ipVersion = IpAddress.Version.INET;
                    break;
                }
                case "6": {
                    ipVersion = IpAddress.Version.INET;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ipVersion should be 4 or 6.");
                }
            }
            IpPrefix cidr = IpPrefix.valueOf((String)subnetNode.get("cidr").asText());
            IpAddress gatewayIp = IpAddress.valueOf((String)subnetNode.get("gateway_ip").asText());
            Boolean dhcpEnabled = subnetNode.get("enable_dhcp").asBoolean();
            Boolean shared = subnetNode.get("shared").asBoolean();
            JsonNode hostRoutes = subnetNode.get("host_routes");
            Iterable hostRoutesIt = this.jsonNodeToHostRoutes(hostRoutes);
            JsonNode allocationPools = subnetNode.get("allocation_pools");
            Iterable allocationPoolsIt = this.jsonNodeToAllocationPools(allocationPools);
            Subnet.Mode ipV6AddressMode = Subnet.Mode.valueOf((String)subnetNode.get("ipv6_address_mode").asText());
            Subnet.Mode ipV6RaMode = Subnet.Mode.valueOf((String)subnetNode.get("ipv6_ra_mode").asText());
            DefaultSubnet subnet = new DefaultSubnet(id, subnetName, networkId, tenantId, ipVersion, cidr, gatewayIp, dhcpEnabled.booleanValue(), shared.booleanValue(), (Set)Sets.newHashSet((Iterable)hostRoutesIt), ipV6AddressMode, ipV6RaMode, (Set)Sets.newHashSet((Iterable)allocationPoolsIt));
            subMap.put(id, subnet);
        }
        return Collections.unmodifiableCollection(subMap.values());
    }

    public Iterable<Subnet> changeJsonToSub(JsonNode subnetNodes) {
        IpAddress.Version ipVersion;
        String version;
        Preconditions.checkNotNull((Object)subnetNodes, (Object)"JsonNode can not be null");
        Preconditions.checkArgument((boolean)subnetNodes.get("enable_dhcp").isBoolean(), (Object)"enable_dhcp should be boolean");
        Preconditions.checkArgument((boolean)subnetNodes.get("shared").isBoolean(), (Object)"shared should be boolean");
        HashMap<SubnetId, DefaultSubnet> subMap = new HashMap<SubnetId, DefaultSubnet>();
        if (!subnetNodes.hasNonNull("id")) {
            return null;
        }
        SubnetId id = SubnetId.subnetId((String)subnetNodes.get("id").asText());
        String subnetName = subnetNodes.get("name").asText();
        TenantId tenantId = TenantId.tenantId((String)subnetNodes.get("tenant_id").asText());
        TenantNetworkId networkId = TenantNetworkId.networkId((String)subnetNodes.get("network_id").asText());
        switch (version = subnetNodes.get("ip_version").asText()) {
            case "4": {
                ipVersion = IpAddress.Version.INET;
                break;
            }
            case "6": {
                ipVersion = IpAddress.Version.INET;
                break;
            }
            default: {
                throw new IllegalArgumentException("ipVersion should be 4 or 6.");
            }
        }
        IpPrefix cidr = IpPrefix.valueOf((String)subnetNodes.get("cidr").asText());
        IpAddress gatewayIp = IpAddress.valueOf((String)subnetNodes.get("gateway_ip").asText());
        Boolean dhcpEnabled = subnetNodes.get("enable_dhcp").asBoolean();
        Boolean shared = subnetNodes.get("shared").asBoolean();
        JsonNode hostRoutes = subnetNodes.get("host_routes");
        Iterable hostRoutesIt = this.jsonNodeToHostRoutes(hostRoutes);
        JsonNode allocationPools = subnetNodes.get("allocation_pools");
        Iterable allocationPoolsIt = this.jsonNodeToAllocationPools(allocationPools);
        Subnet.Mode ipV6AddressMode = this.getMode(subnetNodes.get("ipv6_address_mode").asText());
        Subnet.Mode ipV6RaMode = this.getMode(subnetNodes.get("ipv6_ra_mode").asText());
        DefaultSubnet subnet = new DefaultSubnet(id, subnetName, networkId, tenantId, ipVersion, cidr, gatewayIp, dhcpEnabled.booleanValue(), shared.booleanValue(), (Set)Sets.newHashSet((Iterable)hostRoutesIt), ipV6AddressMode, ipV6RaMode, (Set)Sets.newHashSet((Iterable)allocationPoolsIt));
        subMap.put(id, subnet);
        return Collections.unmodifiableCollection(subMap.values());
    }

    private Subnet.Mode getMode(String mode) {
        Subnet.Mode ipV6Mode;
        if (mode == null) {
            return null;
        }
        switch (mode) {
            case "dhcpv6-stateful": {
                ipV6Mode = Subnet.Mode.DHCPV6_STATEFUL;
                break;
            }
            case "dhcpv6-stateless": {
                ipV6Mode = Subnet.Mode.DHCPV6_STATELESS;
                break;
            }
            case "slaac": {
                ipV6Mode = Subnet.Mode.SLAAC;
                break;
            }
            default: {
                ipV6Mode = null;
            }
        }
        return ipV6Mode;
    }

    public Iterable<AllocationPool> jsonNodeToAllocationPools(JsonNode allocationPools) {
        Preconditions.checkNotNull((Object)allocationPools, (Object)"JsonNode can not be null");
        ConcurrentMap alocplMaps = Maps.newConcurrentMap();
        Integer i = 0;
        for (JsonNode node : allocationPools) {
            IpAddress startIp = IpAddress.valueOf((String)node.get("start").asText());
            IpAddress endIp = IpAddress.valueOf((String)node.get("end").asText());
            DefaultAllocationPool alocPls = new DefaultAllocationPool(startIp, endIp);
            alocplMaps.putIfAbsent(i, alocPls);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return Collections.unmodifiableCollection(alocplMaps.values());
    }

    public Iterable<HostRoute> jsonNodeToHostRoutes(JsonNode hostRoutes) {
        Preconditions.checkNotNull((Object)hostRoutes, (Object)"JsonNode can not be null");
        ConcurrentMap hostRouteMaps = Maps.newConcurrentMap();
        Integer i = 0;
        for (JsonNode node : hostRoutes) {
            IpAddress nexthop = IpAddress.valueOf((String)node.get("nexthop").asText());
            IpPrefix destination = IpPrefix.valueOf((String)node.get("destination").asText());
            DefaultHostRoute hostRoute = new DefaultHostRoute(nexthop, destination);
            hostRouteMaps.putIfAbsent(i, hostRoute);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return Collections.unmodifiableCollection(hostRouteMaps.values());
    }

    protected <T> T nullIsNotFound(T item, String message) {
        if (item == null) {
            throw new ItemNotFoundException(message);
        }
        return item;
    }
}

