/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.portpair.PortPairService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="port_pairs")
public class PortPairWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(PortPairWebResource.class);
    public static final String PORT_PAIR_NOT_FOUND = "Port pair not found";
    public static final String PORT_PAIR_ID_EXIST = "Port pair exists";
    public static final String PORT_PAIR_ID_NOT_EXIST = "Port pair does not exist with identifier";

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getPortPairs() {
        Iterable portPairs = ((PortPairService)this.get(PortPairService.class)).getPortPairs();
        ObjectNode result = this.mapper().createObjectNode();
        ArrayNode portPairEntry = result.putArray("port_pairs");
        if (portPairs != null) {
            for (PortPair portPair : portPairs) {
                portPairEntry.add((JsonNode)this.codec(PortPair.class).encode((Object)portPair, (CodecContext)this));
            }
        }
        return PortPairWebResource.ok((Object)result.toString()).build();
    }

    @GET
    @Path(value="{pair_id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getPortPair(@PathParam(value="pair_id") String id) {
        PortPair portPair = (PortPair)Tools.nullIsNotFound((Object)((PortPairService)this.get(PortPairService.class)).getPortPair(PortPairId.of((String)id)), (String)"Port pair not found");
        ObjectNode result = this.mapper().createObjectNode();
        result.set("port_pair", (JsonNode)this.codec(PortPair.class).encode((Object)portPair, (CodecContext)this));
        return PortPairWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createPortPair(InputStream stream) {
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode port = jsonTree.get("port_pair");
            PortPair portPair = (PortPair)this.codec(PortPair.class).decode((ObjectNode)port, (CodecContext)this);
            Boolean isSuccess = (Boolean)Tools.nullIsNotFound((Object)((PortPairService)this.get(PortPairService.class)).createPortPair(portPair), (String)"Port pair not found");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)isSuccess.toString()).build();
        }
        catch (IOException e) {
            this.log.error("Exception while creating port pair {}.", (Object)e.toString());
            throw new IllegalArgumentException(e);
        }
    }

    @PUT
    @Path(value="{pair_id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updatePortPair(@PathParam(value="pair_id") String id, InputStream stream) {
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode port = jsonTree.get("port_pair");
            PortPair portPair = (PortPair)this.codec(PortPair.class).decode((ObjectNode)port, (CodecContext)this);
            Boolean isSuccess = (Boolean)Tools.nullIsNotFound((Object)((PortPairService)this.get(PortPairService.class)).updatePortPair(portPair), (String)"Port pair not found");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)isSuccess.toString()).build();
        }
        catch (IOException e) {
            this.log.error("Update port pair failed because of exception {}.", (Object)e.toString());
            throw new IllegalArgumentException(e);
        }
    }

    @Path(value="{pair_id}")
    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deletePortPair(@PathParam(value="pair_id") String id) {
        PortPairId portPairId = PortPairId.of((String)id);
        Boolean isSuccess = (Boolean)Tools.nullIsNotFound((Object)((PortPairService)this.get(PortPairService.class)).removePortPair(portPairId), (String)"Port pair not found");
        if (!isSuccess.booleanValue()) {
            this.log.debug("Port pair identifier {} does not exist", (Object)id);
        }
        return Response.noContent().build();
    }
}

