/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.controller.impl;

import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.onosproject.pcep.controller.impl.Controller;
import org.onosproject.pcep.controller.impl.PcepChannelHandler;
import org.onosproject.pcep.controller.impl.PcepMessageDecoder;
import org.onosproject.pcep.controller.impl.PcepMessageEncoder;

public class PcepPipelineFactory
implements ChannelPipelineFactory,
ExternalResourceReleasable {
    protected Controller controller;
    static final Timer TIMER = new HashedWheelTimer();
    protected IdleStateHandler idleHandler;
    protected ReadTimeoutHandler readTimeoutHandler;
    static final int DEFAULT_KEEP_ALIVE_TIME = 30;
    static final int DEFAULT_DEAD_TIME = 120;
    static final int DEFAULT_WAIT_TIME = 60;

    public PcepPipelineFactory(Controller controller) {
        this.controller = controller;
        this.idleHandler = new IdleStateHandler(TIMER, 120, 30, 0);
        this.readTimeoutHandler = new ReadTimeoutHandler(TIMER, 60);
    }

    public ChannelPipeline getPipeline() throws Exception {
        PcepChannelHandler handler = new PcepChannelHandler(this.controller);
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("pcepmessagedecoder", (ChannelHandler)new PcepMessageDecoder());
        pipeline.addLast("pcepmessageencoder", (ChannelHandler)new PcepMessageEncoder());
        pipeline.addLast("idle", (ChannelHandler)this.idleHandler);
        pipeline.addLast("waittimeout", (ChannelHandler)this.readTimeoutHandler);
        pipeline.addLast("handler", (ChannelHandler)handler);
        return pipeline;
    }

    public void releaseExternalResources() {
        TIMER.stop();
    }
}

