/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.controller.impl;

import java.util.LinkedList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.onosproject.pcepio.exceptions.PcepOutOfBoundMessageException;
import org.onosproject.pcepio.protocol.PcepFactories;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.util.HexDump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepMessageDecoder
extends FrameDecoder {
    protected static final Logger log = LoggerFactory.getLogger(PcepMessageDecoder.class);

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        log.debug("Message received.");
        if (!channel.isConnected()) {
            log.info("Channel is not connected.");
            return null;
        }
        HexDump.pcepHexDump((ChannelBuffer)buffer);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        LinkedList<PcepMessage> msgList = (LinkedList<PcepMessage>)ctx.getAttachment();
        if (msgList == null) {
            msgList = new LinkedList<PcepMessage>();
        }
        try {
            while (buffer.readableBytes() > 0) {
                buffer.markReaderIndex();
                PcepMessage message = (PcepMessage)reader.readFrom(buffer);
                msgList.add(message);
            }
            ctx.setAttachment(null);
            return msgList;
        }
        catch (PcepOutOfBoundMessageException e) {
            log.debug("PCEP message decode error");
            buffer.resetReaderIndex();
            buffer.discardReadBytes();
            ctx.setAttachment(msgList);
            return null;
        }
    }
}

