/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.controller.impl;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.netty.channel.Channel;
import org.onlab.packet.IpAddress;
import org.onosproject.pcep.controller.ClientCapability;
import org.onosproject.pcep.controller.LspKey;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepPacketStats;
import org.onosproject.pcep.controller.PcepSyncStatus;
import org.onosproject.pcep.controller.driver.PcepAgent;
import org.onosproject.pcep.controller.driver.PcepClientDriver;
import org.onosproject.pcep.controller.impl.PcepPacketStatsImpl;
import org.onosproject.pcepio.protocol.PcepFactories;
import org.onosproject.pcepio.protocol.PcepFactory;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepStateReport;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepClientImpl
implements PcepClientDriver {
    protected final Logger log = LoggerFactory.getLogger(PcepClientImpl.class);
    private static final String SHUTDOWN_MSG = "Worker has already been shutdown";
    private Channel channel;
    protected String channelId;
    private boolean connected;
    protected boolean startDriverHandshakeCalled;
    protected boolean isHandShakeComplete;
    private PcepSyncStatus lspDbSyncStatus;
    private PcepSyncStatus labelDbSyncStatus;
    private PccId pccId;
    private PcepAgent agent;
    private ClientCapability capability;
    private PcepVersion pcepVersion;
    private byte keepAliveTime;
    private byte deadTime;
    private byte sessionId;
    private PcepPacketStatsImpl pktStats;
    private Map<LspKey, Boolean> lspDelegationInfo = new HashMap<LspKey, Boolean>();
    private Map<PccId, List<PcepStateReport>> syncRptCache = new HashMap<PccId, List<PcepStateReport>>();

    public void init(PccId pccId, PcepVersion pcepVersion, PcepPacketStats pktStats) {
        this.pccId = pccId;
        this.pcepVersion = pcepVersion;
        this.pktStats = (PcepPacketStatsImpl)pktStats;
    }

    public final void disconnectClient() {
        this.channel.close();
    }

    public void setCapability(ClientCapability capability) {
        this.capability = capability;
    }

    public ClientCapability capability() {
        return this.capability;
    }

    public final void sendMessage(PcepMessage m) {
        block2: {
            this.log.debug("Sending message to {}", (Object)this.channel.getRemoteAddress());
            try {
                this.channel.write(Collections.singletonList(m));
                this.pktStats.addOutPacket();
            }
            catch (RejectedExecutionException e) {
                this.log.warn(e.getMessage());
                if (e.getMessage().contains(SHUTDOWN_MSG)) break block2;
                throw e;
            }
        }
    }

    public final void sendMessage(List<PcepMessage> msgs) {
        block2: {
            try {
                this.channel.write(msgs);
                this.pktStats.addOutPacket(msgs.size());
            }
            catch (RejectedExecutionException e) {
                this.log.warn(e.getMessage());
                if (e.getMessage().contains(SHUTDOWN_MSG)) break block2;
                throw e;
            }
        }
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public final void setConnected(boolean connected) {
        this.connected = connected;
    }

    public final void setChannel(Channel channel) {
        this.channel = channel;
        SocketAddress address = channel.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            IpAddress ipAddress = IpAddress.valueOf((InetAddress)inetAddress.getAddress());
            this.channelId = ipAddress.isIp4() ? ipAddress.toString() + ':' + inetAddress.getPort() : '[' + ipAddress.toString() + "]:" + inetAddress.getPort();
        }
    }

    public String channelId() {
        return this.channelId;
    }

    public final PccId getPccId() {
        return this.pccId;
    }

    public final String getStringId() {
        return this.pccId.toString();
    }

    public final void setPcVersion(PcepVersion pcepVersion) {
        this.pcepVersion = pcepVersion;
    }

    public void setPcKeepAliveTime(byte keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setPcDeadTime(byte deadTime) {
        this.deadTime = deadTime;
    }

    public void setPcSessionId(byte sessionId) {
        this.sessionId = sessionId;
    }

    public void setLspDbSyncStatus(PcepSyncStatus syncStatus) {
        this.log.debug("LSP DB sync status set from {} to {}", (Object)this.lspDbSyncStatus, (Object)syncStatus);
        this.lspDbSyncStatus = syncStatus;
    }

    public PcepSyncStatus lspDbSyncStatus() {
        return this.lspDbSyncStatus;
    }

    public void setLabelDbSyncStatus(PcepSyncStatus syncStatus) {
        PcepSyncStatus syncOldStatus = this.labelDbSyncStatus();
        this.labelDbSyncStatus = syncStatus;
        this.log.debug("Label DB sync status set from {} to {}", (Object)syncOldStatus, (Object)syncStatus);
        if (syncOldStatus == PcepSyncStatus.IN_SYNC && syncStatus == PcepSyncStatus.SYNCED) {
            this.agent.analyzeSyncMsgList(this.pccId);
        }
    }

    public PcepSyncStatus labelDbSyncStatus() {
        return this.labelDbSyncStatus;
    }

    public final void handleMessage(PcepMessage m) {
        this.pktStats.addInPacket();
        this.agent.processPcepMessage(this.pccId, m);
    }

    public void addNode(PcepClient pc) {
        this.agent.addNode(pc);
    }

    public void deleteNode(PccId pccId) {
        this.agent.deleteNode(pccId);
    }

    public final boolean connectClient() {
        return this.agent.addConnectedClient(this.pccId, (PcepClient)this);
    }

    public final void removeConnectedClient() {
        this.agent.removeConnectedClient(this.pccId);
    }

    public PcepFactory factory() {
        return PcepFactories.getFactory((PcepVersion)this.pcepVersion);
    }

    public boolean isHandshakeComplete() {
        return this.isHandShakeComplete;
    }

    public final void setAgent(PcepAgent ag) {
        if (this.agent == null) {
            this.agent = ag;
        }
    }

    public void setLspAndDelegationInfo(LspKey lspKey, boolean dFlag) {
        this.lspDelegationInfo.put(lspKey, dFlag);
    }

    public Boolean delegationInfo(LspKey lspKey) {
        return this.lspDelegationInfo.get(lspKey);
    }

    public void initializeSyncMsgList(PccId pccId) {
        LinkedList rptMsgList = new LinkedList();
        this.syncRptCache.put(pccId, rptMsgList);
    }

    public List<PcepStateReport> getSyncMsgList(PccId pccId) {
        return this.syncRptCache.get(pccId);
    }

    public void removeSyncMsgList(PccId pccId) {
        this.syncRptCache.remove(pccId);
    }

    public void addSyncMsgToList(PccId pccId, PcepStateReport rptMsg) {
        List<PcepStateReport> rptMsgList = this.syncRptCache.get(pccId);
        rptMsgList.add(rptMsg);
        this.syncRptCache.put(pccId, rptMsgList);
    }

    public boolean isOptical() {
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("channel", (Object)this.channelId()).add("pccId", (Object)this.getPccId()).toString();
    }
}

