/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.controller.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.resource.label.LabelResourceAdminService;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.incubator.net.tunnel.DefaultLabelStack;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.LabelStack;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.Path;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkService;
import org.onosproject.pcelabelstore.PcepLabelOp;
import org.onosproject.pcelabelstore.api.PceLabelStore;
import org.onosproject.pcep.api.DeviceCapability;
import org.onosproject.pcep.controller.LspKey;
import org.onosproject.pcep.controller.LspType;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepClientController;
import org.onosproject.pcep.controller.PcepClientListener;
import org.onosproject.pcep.controller.PcepEventListener;
import org.onosproject.pcep.controller.PcepLspStatus;
import org.onosproject.pcep.controller.PcepLspSyncAction;
import org.onosproject.pcep.controller.PcepNodeListener;
import org.onosproject.pcep.controller.PcepSyncStatus;
import org.onosproject.pcep.controller.SrpIdGenerators;
import org.onosproject.pcep.controller.driver.PcepAgent;
import org.onosproject.pcep.controller.impl.BasicPceccHandler;
import org.onosproject.pcep.controller.impl.Controller;
import org.onosproject.pcep.controller.impl.PceccSrTeBeHandler;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcInitiatedLspRequest;
import org.onosproject.pcepio.protocol.PcepError;
import org.onosproject.pcepio.protocol.PcepErrorInfo;
import org.onosproject.pcepio.protocol.PcepErrorMsg;
import org.onosproject.pcepio.protocol.PcepErrorObject;
import org.onosproject.pcepio.protocol.PcepFactory;
import org.onosproject.pcepio.protocol.PcepInitiateMsg;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepNai;
import org.onosproject.pcepio.protocol.PcepReportMsg;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.protocol.PcepStateReport;
import org.onosproject.pcepio.types.PathSetupTypeTlv;
import org.onosproject.pcepio.types.PcepNaiIpv4Adjacency;
import org.onosproject.pcepio.types.PcepNaiIpv4NodeId;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.SrEroSubObject;
import org.onosproject.pcepio.types.StatefulIPv4LspIdentifiersTlv;
import org.onosproject.pcepio.types.SymbolicPathNameTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PcepClientControllerImpl
implements PcepClientController {
    private static final Logger log = LoggerFactory.getLogger(PcepClientControllerImpl.class);
    private static final long IDENTIFIER_SET = 0x100000000L;
    private static final long SET = 0xFFFFFFFFL;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelService tunnelService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService netCfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LabelResourceAdminService labelRsrcAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LabelResourceService labelRsrcService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PceLabelStore pceStore;
    protected ConcurrentHashMap<PccId, PcepClient> connectedClients = new ConcurrentHashMap();
    protected PcepClientAgent agent = new PcepClientAgent();
    protected Set<PcepClientListener> pcepClientListener = new HashSet<PcepClientListener>();
    protected Set<PcepEventListener> pcepEventListener = Sets.newHashSet();
    protected Set<PcepNodeListener> pcepNodeListener = Sets.newHashSet();
    private Map<String, DeviceId> lsrIdDeviceIdMap = new HashMap<String, DeviceId>();
    private final Controller ctrl = new Controller();
    public static final long GLOBAL_LABEL_SPACE_MIN = 4097L;
    public static final long GLOBAL_LABEL_SPACE_MAX = 5121L;
    private static final String LSRID = "lsrId";
    private static final String DEVICE_NULL = "Device-cannot be null";
    private static final String LINK_NULL = "Link-cannot be null";
    private BasicPceccHandler crHandler;
    private PceccSrTeBeHandler srTeHandler;
    private DeviceListener deviceListener = new InternalDeviceListener();
    private LinkListener linkListener = new InternalLinkListener();
    private InternalConfigListener cfgListener = new InternalConfigListener();
    private Map<Integer, Integer> pcepErrorMsg = new TreeMap<Integer, Integer>();

    @Activate
    public void activate() {
        this.ctrl.start(this.agent);
        this.crHandler = BasicPceccHandler.getInstance();
        this.crHandler.initialize(this.labelRsrcService, this.deviceService, this.pceStore, this);
        this.srTeHandler = PceccSrTeBeHandler.getInstance();
        this.srTeHandler.initialize(this.labelRsrcAdminService, this.labelRsrcService, this, this.pceStore, this.deviceService);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.linkService.addListener((EventListener)this.linkListener);
        this.netCfgService.addListener((EventListener)this.cfgListener);
        if (!this.srTeHandler.reserveGlobalPool(4097L, 5121L)) {
            log.debug("Global node pool was already reserved.");
        }
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.closeConnectedClients();
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.linkService.removeListener((EventListener)this.linkListener);
        this.netCfgService.removeListener((EventListener)this.cfgListener);
        this.ctrl.stop();
        log.info("Stopped");
    }

    public void peerErrorMsg(String peerId, Integer errorType, Integer errValue) {
        if (peerId == null) {
            this.pcepErrorMsg.put(errorType, errValue);
        } else {
            if (this.pcepErrorMsg.size() > 10) {
                this.pcepErrorMsg.clear();
            }
            this.pcepErrorMsg.put(errorType, errValue);
        }
    }

    public Map<String, List<String>> getPcepExceptions() {
        return this.ctrl.exceptionsMap();
    }

    public Map<Integer, Integer> getPcepErrorMsg() {
        return this.pcepErrorMsg;
    }

    public Map<String, String> getPcepSessionMap() {
        return this.ctrl.mapPeer();
    }

    public Map<String, Byte> getPcepSessionIdMap() {
        return this.ctrl.mapSession();
    }

    public Collection<PcepClient> getClients() {
        return this.connectedClients.values();
    }

    public PcepClient getClient(PccId pccId) {
        return this.connectedClients.get(pccId);
    }

    public void addListener(PcepClientListener listener) {
        if (!this.pcepClientListener.contains(listener)) {
            this.pcepClientListener.add(listener);
        }
    }

    public void removeListener(PcepClientListener listener) {
        this.pcepClientListener.remove(listener);
    }

    public void addEventListener(PcepEventListener listener) {
        this.pcepEventListener.add(listener);
    }

    public void removeEventListener(PcepEventListener listener) {
        this.pcepEventListener.remove(listener);
    }

    public void writeMessage(PccId pccId, PcepMessage msg) {
        this.getClient(pccId).sendMessage(msg);
    }

    public void addNodeListener(PcepNodeListener listener) {
        this.pcepNodeListener.add(listener);
    }

    public void removeNodeListener(PcepNodeListener listener) {
        this.pcepNodeListener.remove(listener);
    }

    public void processClientMessage(PccId pccId, PcepMessage msg) {
        PcepClient pc = this.getClient(pccId);
        switch (msg.getType()) {
            case NONE: {
                break;
            }
            case OPEN: {
                break;
            }
            case KEEP_ALIVE: {
                break;
            }
            case PATH_COMPUTATION_REQUEST: {
                break;
            }
            case PATH_COMPUTATION_REPLY: {
                break;
            }
            case NOTIFICATION: {
                break;
            }
            case ERROR: {
                break;
            }
            case INITIATE: {
                if (pc.capability().pcInstantiationCapability()) break;
                pc.sendMessage(Collections.singletonList(this.getErrMsg(pc.factory(), (byte)19, (byte)5)));
                break;
            }
            case UPDATE: {
                if (pc.capability().statefulPceCapability()) break;
                pc.sendMessage(Collections.singletonList(this.getErrMsg(pc.factory(), (byte)19, (byte)5)));
                break;
            }
            case LABEL_UPDATE: {
                if (pc.capability().pceccCapability()) break;
                pc.sendMessage(Collections.singletonList(this.getErrMsg(pc.factory(), (byte)19, (byte)5)));
                break;
            }
            case CLOSE: {
                log.info("Sending Close Message  to {" + pccId.toString() + "}");
                pc.sendMessage(Collections.singletonList(pc.factory().buildCloseMsg().build()));
                pc.disconnectClient();
                break;
            }
            case REPORT: {
                if (pc.capability().statefulPceCapability()) {
                    ListIterator listIterator = ((PcepReportMsg)msg).getStateReportList().listIterator();
                    while (listIterator.hasNext()) {
                        PcepStateReport stateRpt = (PcepStateReport)listIterator.next();
                        PcepLspObject lspObj = stateRpt.getLspObject();
                        if (lspObj.getSFlag()) {
                            if (pc.lspDbSyncStatus() != PcepSyncStatus.IN_SYNC) {
                                log.debug("LSP DB sync started for PCC {}", (Object)((IpAddress)pc.getPccId().id()).toString());
                                pc.setLspDbSyncStatus(PcepSyncStatus.IN_SYNC);
                                pc.initializeSyncMsgList(pccId);
                            }
                            pc.addSyncMsgToList(pccId, stateRpt);
                            continue;
                        }
                        if (lspObj.getPlspId() == 0 && (pc.lspDbSyncStatus() == PcepSyncStatus.IN_SYNC || pc.lspDbSyncStatus() == PcepSyncStatus.NOT_SYNCED)) {
                            log.debug("LSP DB sync completed for PCC {}", (Object)((IpAddress)pc.getPccId().id()).toString());
                            pc.setLspDbSyncStatus(PcepSyncStatus.SYNCED);
                            if (pc.capability().pceccCapability()) {
                                log.debug("Trigger label DB sync for PCC {}", (Object)((IpAddress)pc.getPccId().id()).toString());
                                pc.setLabelDbSyncStatus(PcepSyncStatus.IN_SYNC);
                                String lsrId = String.valueOf(pccId.ipAddress());
                                DeviceId pccDeviceId = DeviceId.deviceId((String)lsrId);
                                try {
                                    this.syncLabelDb(pccDeviceId);
                                    pc.setLabelDbSyncStatus(PcepSyncStatus.SYNCED);
                                }
                                catch (PcepParseException e) {
                                    log.error("Exception caught in sending label masg to PCC while in sync.");
                                }
                                continue;
                            }
                            this.agent.analyzeSyncMsgList(pccId);
                            continue;
                        }
                        PcepLspStatus pcepLspStatus = PcepLspStatus.values()[lspObj.getOFlag()];
                        LspType lspType = this.getLspType(stateRpt.getSrpObject());
                        if (lspType.equals((Object)LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR)) {
                            boolean isRemove = lspObj.getRFlag();
                            Tunnel tunnel = null;
                            if (isRemove || pcepLspStatus.equals((Object)PcepLspStatus.GOING_UP)) {
                                tunnel = this.getTunnel(lspObj);
                            }
                            if (tunnel != null) {
                                if (isRemove) {
                                    this.crHandler.releaseLabel(tunnel);
                                } else {
                                    this.crHandler.allocateLabel(tunnel);
                                }
                            }
                        }
                        LinkedList<PcepStateReport> llPcRptList = new LinkedList<PcepStateReport>();
                        llPcRptList.add(stateRpt);
                        PcepReportMsg pcReportMsg = pc.factory().buildReportMsg().setStateReportList(llPcRptList).build();
                        for (PcepEventListener l : this.pcepEventListener) {
                            l.handleMessage(pccId, (PcepMessage)pcReportMsg);
                        }
                    }
                    break;
                }
                pc.sendMessage(Collections.singletonList(this.getErrMsg(pc.factory(), (byte)19, (byte)5)));
                break;
            }
            case LABEL_RANGE_RESERV: {
                break;
            }
            case LS_REPORT: {
                break;
            }
            case MAX: {
                break;
            }
            case END: {
                break;
            }
        }
    }

    private LspType getLspType(PcepSrpObject srpObj) {
        LspType lspType = LspType.WITH_SIGNALLING;
        if (null != srpObj) {
            LinkedList llOptionalTlv = srpObj.getOptionalTlv();
            ListIterator listIterator = llOptionalTlv.listIterator();
            while (listIterator.hasNext()) {
                PcepValueType tlv = (PcepValueType)listIterator.next();
                switch (tlv.getType()) {
                    case 28: {
                        lspType = LspType.values()[Integer.valueOf(((PathSetupTypeTlv)tlv).getPst())];
                        break;
                    }
                }
            }
        }
        return lspType;
    }

    private Tunnel getTunnel(PcepLspObject lspObj) {
        ListIterator listTlvIterator = lspObj.getOptionalTlv().listIterator();
        StatefulIPv4LspIdentifiersTlv ipv4LspIdenTlv = null;
        SymbolicPathNameTlv pathNameTlv = null;
        Tunnel tunnel = null;
        while (listTlvIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listTlvIterator.next();
            switch (tlv.getType()) {
                case 18: {
                    ipv4LspIdenTlv = (StatefulIPv4LspIdentifiersTlv)tlv;
                    break;
                }
                case 17: {
                    pathNameTlv = (SymbolicPathNameTlv)tlv;
                    break;
                }
            }
        }
        if (ipv4LspIdenTlv == null) {
            log.error("Stateful IPv4 identifier TLV is null in PCRpt msg.");
            return null;
        }
        IpTunnelEndPoint tunnelEndPointSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)ipv4LspIdenTlv.getIpv4IngressAddress()));
        IpTunnelEndPoint tunnelEndPointDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)ipv4LspIdenTlv.getIpv4EgressAddress()));
        Collection tunnelQueryResult = this.tunnelService.queryTunnel((TunnelEndPoint)tunnelEndPointSrc, (TunnelEndPoint)tunnelEndPointDst);
        for (Tunnel tunnelObj : tunnelQueryResult) {
            if (tunnelObj.annotations().value("PLspId") == null) {
                if (pathNameTlv == null || !Arrays.equals(tunnelObj.tunnelName().value().getBytes(), pathNameTlv.getValue())) continue;
                tunnel = tunnelObj;
                break;
            }
            if (Integer.valueOf(tunnelObj.annotations().value("PLspId")).intValue() != lspObj.getPlspId() || Integer.valueOf(tunnelObj.annotations().value("localLspId")).intValue() != ipv4LspIdenTlv.getLspId()) continue;
            tunnel = tunnelObj;
            break;
        }
        if (tunnel == null || tunnel.annotations().value("PLspId") != null) {
            return tunnel;
        }
        DefaultAnnotations.Builder annotationBuilder = DefaultAnnotations.builder();
        annotationBuilder.set("bandwidth", tunnel.annotations().value("bandwidth"));
        annotationBuilder.set("costType", tunnel.annotations().value("costType"));
        annotationBuilder.set("lspSigType", tunnel.annotations().value("lspSigType"));
        annotationBuilder.set("pceInit", tunnel.annotations().value("pceInit"));
        annotationBuilder.set("delegate", tunnel.annotations().value("delegate"));
        annotationBuilder.set("PLspId", String.valueOf(lspObj.getPlspId()));
        annotationBuilder.set("PccTunnelId", String.valueOf(ipv4LspIdenTlv.getTunnelId()));
        annotationBuilder.set("localLspId", tunnel.annotations().value("localLspId"));
        DefaultTunnel updatedTunnel = new DefaultTunnel(tunnel.providerId(), tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.state(), tunnel.groupId(), tunnel.tunnelId(), tunnel.tunnelName(), tunnel.path(), tunnel.resource(), new Annotations[]{annotationBuilder.build()});
        return updatedTunnel;
    }

    public void closeConnectedClients() {
        for (PccId id : this.connectedClients.keySet()) {
            PcepClient pc = this.getClient(id);
            pc.disconnectClient();
        }
    }

    public PcepErrorMsg getErrMsg(PcepFactory factory, byte errorType, byte errorValue) {
        LinkedList<PcepError> llPcepErr = new LinkedList<PcepError>();
        LinkedList<PcepErrorObject> llerrObj = new LinkedList<PcepErrorObject>();
        PcepErrorObject errObj = factory.buildPcepErrorObject().setErrorValue(errorValue).setErrorType(errorType).build();
        llerrObj.add(errObj);
        PcepError pcepErr = factory.buildPcepError().setErrorObjList(llerrObj).build();
        llPcepErr.add(pcepErr);
        PcepErrorInfo errInfo = factory.buildPcepErrorInfo().setPcepErrorList(llPcepErr).build();
        PcepErrorMsg errMsg = factory.buildPcepErrorMsg().setPcepErrorInfo(errInfo).build();
        return errMsg;
    }

    private boolean syncLabelDb(DeviceId deviceId) throws PcepParseException {
        Preconditions.checkNotNull((Object)deviceId);
        DeviceId actualDevcieId = this.pceStore.getLsrIdDevice(deviceId.toString());
        if (actualDevcieId == null) {
            log.error("Device not available {}.", (Object)deviceId.toString());
            this.pceStore.addPccLsr(deviceId);
            return false;
        }
        PcepClient pc = this.connectedClients.get(PccId.pccId((IpAddress)IpAddress.valueOf((String)deviceId.toString())));
        Device specificDevice = this.deviceService.getDevice(actualDevcieId);
        if (specificDevice == null) {
            log.error("Unable to find device for specific device id {}.", (Object)actualDevcieId.toString());
            return false;
        }
        if (this.pceStore.getGlobalNodeLabel(actualDevcieId) != null) {
            Map<DeviceId, LabelResourceId> globalNodeLabelMap = this.pceStore.getGlobalNodeLabels();
            for (Map.Entry<DeviceId, LabelResourceId> entry : globalNodeLabelMap.entrySet()) {
                String srcLsrId;
                Device device = this.deviceService.getDevice(entry.getKey());
                if (device == null || (srcLsrId = device.annotations().value(LSRID)) == null) continue;
                this.srTeHandler.pushGlobalNodeLabel(pc, (LabelResourceId)entry.getValue(), IpAddress.valueOf((String)srcLsrId).getIp4Address().toInt(), PcepLabelOp.ADD, false);
            }
            Map<Link, LabelResourceId> adjLabelMap = this.pceStore.getAdjLabels();
            for (Map.Entry entry : adjLabelMap.entrySet()) {
                if (!((Link)entry.getKey()).src().deviceId().equals((Object)actualDevcieId)) continue;
                this.srTeHandler.pushAdjacencyLabel(pc, (LabelResourceId)entry.getValue(), (int)((Link)entry.getKey()).src().port().toLong(), (int)((Link)entry.getKey()).dst().port().toLong(), PcepLabelOp.ADD);
            }
        }
        this.srTeHandler.pushGlobalNodeLabel(pc, LabelResourceId.labelResourceId((long)0L), 0, PcepLabelOp.ADD, true);
        log.debug("End of label DB sync for device {}", (Object)actualDevcieId);
        if (this.mastershipService.getLocalRole(specificDevice.id()) == MastershipRole.MASTER) {
            this.allocateNodeLabel(specificDevice);
            Set links = this.linkService.getDeviceEgressLinks(specificDevice.id());
            if (links != null) {
                for (Link link : links) {
                    this.allocateAdjacencyLabel(link);
                }
            }
        }
        return true;
    }

    public void allocateNodeLabel(Device specificDevice) {
        Preconditions.checkNotNull((Object)specificDevice, (Object)DEVICE_NULL);
        DeviceId deviceId = specificDevice.id();
        if (specificDevice.annotations() == null) {
            log.debug("Device {} does not have annotations.", (Object)specificDevice.toString());
            return;
        }
        String lsrId = specificDevice.annotations().value(LSRID);
        if (lsrId == null) {
            log.debug("Unable to retrieve lsr-id of a device {}.", (Object)specificDevice.toString());
            return;
        }
        DeviceCapability cfg = (DeviceCapability)this.netCfgService.getConfig((Object)DeviceId.deviceId((String)lsrId), DeviceCapability.class);
        if (cfg == null) {
            log.error("Unable to find corresponding capability for a lsrd {} from NetConfig.", (Object)lsrId);
            this.lsrIdDeviceIdMap.put(lsrId, specificDevice.id());
            return;
        }
        if (cfg.labelStackCap()) {
            this.srTeHandler.allocateNodeLabel(deviceId, lsrId);
        }
    }

    public void releaseNodeLabel(Device specificDevice) {
        Preconditions.checkNotNull((Object)specificDevice, (Object)DEVICE_NULL);
        DeviceId deviceId = specificDevice.id();
        if (specificDevice.annotations() == null) {
            log.debug("Device {} does not have annotations.", (Object)specificDevice.toString());
            return;
        }
        String lsrId = specificDevice.annotations().value(LSRID);
        if (lsrId == null) {
            log.debug("Unable to retrieve lsr-id of a device {}.", (Object)specificDevice.toString());
            return;
        }
        DeviceCapability cfg = (DeviceCapability)this.netCfgService.getConfig((Object)DeviceId.deviceId((String)lsrId), DeviceCapability.class);
        if (cfg == null) {
            log.error("Unable to find corresponding capabilty for a lsrd {} from NetConfig.", (Object)lsrId);
            return;
        }
        if (cfg.labelStackCap() && !this.srTeHandler.releaseNodeLabel(deviceId, lsrId)) {
            log.error("Unable to release node label for a device id {}.", (Object)deviceId.toString());
        }
    }

    public void allocateAdjacencyLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        Device specificDevice = this.deviceService.getDevice(link.src().deviceId());
        if (specificDevice.annotations() == null) {
            log.debug("Device {} does not have annotations.", (Object)specificDevice.toString());
            return;
        }
        String lsrId = specificDevice.annotations().value(LSRID);
        if (lsrId == null) {
            log.debug("Unable to retrieve lsr-id of a device {}.", (Object)specificDevice.toString());
            return;
        }
        DeviceCapability cfg = (DeviceCapability)this.netCfgService.getConfig((Object)DeviceId.deviceId((String)lsrId), DeviceCapability.class);
        if (cfg == null) {
            log.error("Unable to find corresponding capabilty for a lsrd {} from NetConfig.", (Object)lsrId);
            if (this.lsrIdDeviceIdMap.get(lsrId) != null) {
                this.lsrIdDeviceIdMap.put(lsrId, specificDevice.id());
            }
            return;
        }
        if (cfg.labelStackCap()) {
            this.srTeHandler.allocateAdjacencyLabel(link);
        }
    }

    public void releaseAdjacencyLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        Device specificDevice = this.deviceService.getDevice(link.src().deviceId());
        if (specificDevice.annotations() == null) {
            log.debug("Device {} does not have annotations.", (Object)specificDevice.toString());
            return;
        }
        String lsrId = specificDevice.annotations().value(LSRID);
        if (lsrId == null) {
            log.debug("Unable to retrieve lsr-id of a device {}.", (Object)specificDevice.toString());
            return;
        }
        DeviceCapability cfg = (DeviceCapability)this.netCfgService.getConfig((Object)DeviceId.deviceId((String)lsrId), DeviceCapability.class);
        if (cfg == null) {
            log.error("Unable to find corresponding capabilty for a lsrd {} from NetConfig.", (Object)lsrId);
            return;
        }
        if (cfg.labelStackCap() && !this.srTeHandler.releaseAdjacencyLabel(link)) {
            log.error("Unable to release adjacency labels for a link {}.", (Object)link.toString());
        }
    }

    public LabelStack computeLabelStack(Path path) {
        return this.srTeHandler.computeLabelStack(path);
    }

    public boolean allocateLocalLabel(Tunnel tunnel) {
        return this.crHandler.allocateLabel(tunnel);
    }

    public LinkedList<PcepValueType> createPcepLabelStack(DefaultLabelStack labelStack, Path path) {
        Preconditions.checkNotNull((Object)labelStack);
        LinkedList<PcepValueType> llSubObjects = new LinkedList<PcepValueType>();
        Iterator links = path.links().iterator();
        LabelResourceId label = null;
        Link link = null;
        SrEroSubObject subObj = null;
        PcepNaiIpv4Adjacency nai = null;
        Device dstNode = null;
        ListIterator labelListIterator = labelStack.labelResources().listIterator();
        while (labelListIterator.hasNext()) {
            label = (LabelResourceId)labelListIterator.next();
            link = (Link)links.next();
            long srcPortNo = link.src().port().toLong();
            srcPortNo = (srcPortNo & 0x100000000L) == 0x100000000L ? srcPortNo & 0xFFFFFFFFL : srcPortNo;
            long dstPortNo = link.dst().port().toLong();
            dstPortNo = (dstPortNo & 0x100000000L) == 0x100000000L ? dstPortNo & 0xFFFFFFFFL : dstPortNo;
            nai = new PcepNaiIpv4Adjacency((int)srcPortNo, (int)dstPortNo);
            subObj = new SrEroSubObject(3, false, false, false, true, (int)label.labelId(), (PcepNai)nai);
            llSubObjects.add((PcepValueType)subObj);
            dstNode = this.deviceService.getDevice(link.dst().deviceId());
            nai = new PcepNaiIpv4NodeId(Ip4Address.valueOf((String)dstNode.annotations().value(LSRID)).toInt());
            if (!labelListIterator.hasNext()) {
                log.error("Malformed label stack.");
            }
            label = (LabelResourceId)labelListIterator.next();
            subObj = new SrEroSubObject(1, false, false, false, true, (int)label.labelId(), (PcepNai)nai);
            llSubObjects.add((PcepValueType)subObj);
        }
        return llSubObjects;
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindTunnelService(TunnelService tunnelService) {
        this.tunnelService = tunnelService;
    }

    protected void unbindTunnelService(TunnelService tunnelService) {
        if (this.tunnelService == tunnelService) {
            this.tunnelService = null;
        }
    }

    protected void bindNetCfgService(NetworkConfigService networkConfigService) {
        this.netCfgService = networkConfigService;
    }

    protected void unbindNetCfgService(NetworkConfigService networkConfigService) {
        if (this.netCfgService == networkConfigService) {
            this.netCfgService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindLabelRsrcAdminService(LabelResourceAdminService labelResourceAdminService) {
        this.labelRsrcAdminService = labelResourceAdminService;
    }

    protected void unbindLabelRsrcAdminService(LabelResourceAdminService labelResourceAdminService) {
        if (this.labelRsrcAdminService == labelResourceAdminService) {
            this.labelRsrcAdminService = null;
        }
    }

    protected void bindLabelRsrcService(LabelResourceService labelResourceService) {
        this.labelRsrcService = labelResourceService;
    }

    protected void unbindLabelRsrcService(LabelResourceService labelResourceService) {
        if (this.labelRsrcService == labelResourceService) {
            this.labelRsrcService = null;
        }
    }

    protected void bindPceStore(PceLabelStore pceLabelStore) {
        this.pceStore = pceLabelStore;
    }

    protected void unbindPceStore(PceLabelStore pceLabelStore) {
        if (this.pceStore == pceLabelStore) {
            this.pceStore = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.type() == NetworkConfigEvent.Type.CONFIG_ADDED && event.configClass().equals(DeviceCapability.class)) {
                DeviceId deviceIdLsrId = (DeviceId)event.subject();
                String lsrId = deviceIdLsrId.toString();
                DeviceId deviceId = (DeviceId)PcepClientControllerImpl.this.lsrIdDeviceIdMap.get(lsrId);
                if (deviceId == null) {
                    log.debug("Unable to find device id for a lsr-id {} from lsr-id and device-id map.", (Object)lsrId);
                    return;
                }
                DeviceCapability cfg = (DeviceCapability)PcepClientControllerImpl.this.netCfgService.getConfig((Object)DeviceId.deviceId((String)lsrId), DeviceCapability.class);
                if (cfg == null) {
                    log.error("Unable to find corresponding capabilty for a lsrd {}.", (Object)lsrId);
                    return;
                }
                if (cfg.labelStackCap() && PcepClientControllerImpl.this.mastershipService.getLocalRole(deviceId) == MastershipRole.MASTER) {
                    PcepClientControllerImpl.this.srTeHandler.allocateNodeLabel(deviceId, lsrId);
                    Set links = PcepClientControllerImpl.this.linkService.getDeviceEgressLinks(deviceId);
                    for (Link link : links) {
                        if (PcepClientControllerImpl.this.srTeHandler.allocateAdjacencyLabel(link)) continue;
                        return;
                    }
                }
                PcepClientControllerImpl.this.lsrIdDeviceIdMap.remove(lsrId);
            }
        }
    }

    private class InternalLinkListener
    implements LinkListener {
        private InternalLinkListener() {
        }

        public void event(LinkEvent event) {
            Link link = (Link)event.subject();
            switch ((LinkEvent.Type)event.type()) {
                case LINK_ADDED: {
                    if (PcepClientControllerImpl.this.mastershipService.getLocalRole(link.src().deviceId()) != MastershipRole.MASTER) break;
                    PcepClientControllerImpl.this.allocateAdjacencyLabel(link);
                    break;
                }
                case LINK_REMOVED: {
                    if (PcepClientControllerImpl.this.mastershipService.getLocalRole(link.src().deviceId()) != MastershipRole.MASTER) break;
                    PcepClientControllerImpl.this.releaseAdjacencyLabel(link);
                    break;
                }
            }
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            Device specificDevice = (Device)event.subject();
            if (specificDevice == null) {
                log.error("Unable to find device from device event.");
                return;
            }
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: {
                    String lsrId = specificDevice.annotations().value(PcepClientControllerImpl.LSRID);
                    if (lsrId == null) break;
                    PcepClientControllerImpl.this.pceStore.addLsrIdDevice(lsrId, specificDevice.id());
                    DeviceId pccDeviceId = DeviceId.deviceId((String)lsrId);
                    if (!PcepClientControllerImpl.this.pceStore.hasPccLsr(pccDeviceId)) break;
                    log.debug("Continue to perform label DB sync for device {}.", (Object)pccDeviceId.toString());
                    try {
                        PcepClientControllerImpl.this.syncLabelDb(pccDeviceId);
                    }
                    catch (PcepParseException e) {
                        log.error("Exception caught in sending label masg to PCC while in sync.");
                    }
                    PcepClientControllerImpl.this.pceStore.removePccLsr(pccDeviceId);
                    break;
                }
                case DEVICE_REMOVED: {
                    if (PcepClientControllerImpl.this.mastershipService.getLocalRole(specificDevice.id()) == MastershipRole.MASTER) {
                        PcepClientControllerImpl.this.releaseNodeLabel(specificDevice);
                    }
                    if (specificDevice.annotations().value(PcepClientControllerImpl.LSRID) == null) break;
                    PcepClientControllerImpl.this.pceStore.removeLsrIdDevice(specificDevice.annotations().value(PcepClientControllerImpl.LSRID));
                    break;
                }
            }
        }
    }

    public class PcepClientAgent
    implements PcepAgent {
        private final Logger log = LoggerFactory.getLogger(PcepClientAgent.class);

        public boolean addConnectedClient(PccId pccId, PcepClient pc) {
            if (PcepClientControllerImpl.this.connectedClients.get(pccId) != null) {
                this.log.error("Trying to add connectedClient but found a previous value for pcc ip: {}", (Object)pccId.toString());
                return false;
            }
            this.log.debug("Added Client {}", (Object)pccId.toString());
            PcepClientControllerImpl.this.connectedClients.put(pccId, pc);
            for (PcepClientListener l : PcepClientControllerImpl.this.pcepClientListener) {
                l.clientConnected(pccId);
            }
            return true;
        }

        public boolean validActivation(PccId pccId) {
            if (PcepClientControllerImpl.this.connectedClients.get(pccId) == null) {
                this.log.error("Trying to activate client but is not in connected client: pccIp {}. Aborting ..", (Object)pccId.toString());
                return false;
            }
            return true;
        }

        public void removeConnectedClient(PccId pccId) {
            PcepClientControllerImpl.this.connectedClients.remove(pccId);
            for (PcepClientListener l : PcepClientControllerImpl.this.pcepClientListener) {
                this.log.warn("Removal for {}", (Object)pccId.toString());
                l.clientDisconnected(pccId);
            }
        }

        public void processPcepMessage(PccId pccId, PcepMessage m) {
            PcepClientControllerImpl.this.processClientMessage(pccId, m);
        }

        public void addNode(PcepClient pc) {
            for (PcepNodeListener l : PcepClientControllerImpl.this.pcepNodeListener) {
                l.addDevicePcepConfig(pc);
            }
        }

        public void deleteNode(PccId pccId) {
            for (PcepNodeListener l : PcepClientControllerImpl.this.pcepNodeListener) {
                l.deleteDevicePcepConfig(pccId);
            }
        }

        public boolean analyzeSyncMsgList(PccId pccId) {
            PcepClient pc = PcepClientControllerImpl.this.getClient(pccId);
            HashMap<Object, Tunnel> preSyncLspDbByKey = new HashMap<Object, Tunnel>();
            HashMap<String, Tunnel> preSyncLspDbByName = new HashMap<String, Tunnel>();
            Collection queriedTunnels = PcepClientControllerImpl.this.tunnelService.queryTunnel(Tunnel.Type.MPLS);
            for (Tunnel tunnel : queriedTunnels) {
                if (!((IpTunnelEndPoint)tunnel.src()).ip().equals((Object)pccId.ipAddress())) continue;
                String pLspId = tunnel.annotations().value("PLspId");
                if (pLspId != null) {
                    String localLspId = tunnel.annotations().value("localLspId");
                    Preconditions.checkNotNull((Object)localLspId);
                    LspKey lspKey = new LspKey(Integer.valueOf(pLspId).intValue(), Short.valueOf(localLspId).shortValue());
                    preSyncLspDbByKey.put(lspKey, tunnel);
                    continue;
                }
                preSyncLspDbByName.put(tunnel.tunnelName().value(), tunnel);
            }
            List syncStateRptList = pc.getSyncMsgList(pccId);
            if (syncStateRptList == null) {
                syncStateRptList = Collections.EMPTY_LIST;
                this.log.debug("No LSPs reported from PCC during sync.");
            }
            for (PcepStateReport stateRpt : syncStateRptList) {
                Tunnel tunnel = null;
                PcepLspObject lspObj = stateRpt.getLspObject();
                ListIterator listTlvIterator = lspObj.getOptionalTlv().listIterator();
                StatefulIPv4LspIdentifiersTlv ipv4LspIdenTlv = null;
                SymbolicPathNameTlv pathNameTlv = null;
                while (listTlvIterator.hasNext()) {
                    PcepValueType tlv = (PcepValueType)listTlvIterator.next();
                    switch (tlv.getType()) {
                        case 18: {
                            ipv4LspIdenTlv = (StatefulIPv4LspIdentifiersTlv)tlv;
                            break;
                        }
                        case 17: {
                            pathNameTlv = (SymbolicPathNameTlv)tlv;
                            break;
                        }
                    }
                }
                LspKey lspKeyOfRpt = new LspKey(lspObj.getPlspId(), ipv4LspIdenTlv.getLspId());
                tunnel = (Tunnel)preSyncLspDbByKey.get(lspKeyOfRpt);
                if (tunnel != null) {
                    preSyncLspDbByKey.remove(lspKeyOfRpt);
                } else if (pathNameTlv != null && (tunnel = (Tunnel)preSyncLspDbByName.get(Arrays.toString(pathNameTlv.getValue()))) != null) {
                    preSyncLspDbByName.remove(tunnel.tunnelName().value());
                }
                if (tunnel == null && lspObj.getCFlag() && !lspObj.getRFlag()) {
                    try {
                        PcepSrpObject srpobj = pc.factory().buildSrpObject().setSrpID(SrpIdGenerators.create()).setRFlag(true).build();
                        PcInitiatedLspRequest releaseLspRequest = pc.factory().buildPcInitiatedLspRequest().setLspObject(lspObj).setSrpObject(srpobj).build();
                        LinkedList llPcInitiatedLspRequestList = new LinkedList();
                        llPcInitiatedLspRequestList.add(releaseLspRequest);
                        PcepInitiateMsg pcInitiateMsg = pc.factory().buildPcepInitiateMsg().setPcInitiatedLspRequestList(llPcInitiatedLspRequestList).build();
                        pc.sendMessage(Collections.singletonList(pcInitiateMsg));
                    }
                    catch (PcepParseException e) {
                        this.log.error("Exception occured while sending initiate delete message {}", (Object)e.getMessage());
                    }
                    continue;
                }
                if (!lspObj.getCFlag()) {
                    LinkedList<PcepStateReport> llPcRptList = new LinkedList<PcepStateReport>();
                    llPcRptList.add(stateRpt);
                    PcepReportMsg pcReportMsg = pc.factory().buildReportMsg().setStateReportList(llPcRptList).build();
                    for (PcepEventListener l : PcepClientControllerImpl.this.pcepEventListener) {
                        l.handleMessage(pccId, (PcepMessage)pcReportMsg);
                    }
                    continue;
                }
                Tunnel.State tunnelState = PcepLspStatus.getTunnelStatusFromLspStatus((PcepLspStatus)PcepLspStatus.values()[lspObj.getOFlag()]);
                if (tunnelState == tunnel.state()) continue;
                for (PcepEventListener l : PcepClientControllerImpl.this.pcepEventListener) {
                    l.handleEndOfSyncAction(tunnel, PcepLspSyncAction.SEND_UPDATE);
                }
            }
            HashMap<Object, Tunnel> preSyncLspDb = preSyncLspDbByKey;
            this.handleResidualTunnels(preSyncLspDb);
            preSyncLspDbByKey = null;
            preSyncLspDb = preSyncLspDbByName;
            this.handleResidualTunnels(preSyncLspDb);
            preSyncLspDbByName = null;
            preSyncLspDb = null;
            pc.removeSyncMsgList(pccId);
            return true;
        }

        private void handleResidualTunnels(Map<Object, Tunnel> preSyncLspDb) {
            for (Tunnel pceExtraTunnel : preSyncLspDb.values()) {
                if (pceExtraTunnel.annotations().value("pceInit") == null || "false".equalsIgnoreCase(pceExtraTunnel.annotations().value("pceInit"))) {
                    for (PcepEventListener l : PcepClientControllerImpl.this.pcepEventListener) {
                        l.handleEndOfSyncAction(pceExtraTunnel, PcepLspSyncAction.REMOVE);
                    }
                    continue;
                }
                for (PcepEventListener l : PcepClientControllerImpl.this.pcepEventListener) {
                    l.handleEndOfSyncAction(pceExtraTunnel, PcepLspSyncAction.UNSTABLE);
                }
            }
        }
    }
}

