/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.controller.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.onlab.packet.IpAddress;
import org.onosproject.pcep.controller.ClientCapability;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepCfg;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepSyncStatus;
import org.onosproject.pcep.controller.driver.PcepClientDriver;
import org.onosproject.pcep.controller.impl.Controller;
import org.onosproject.pcep.controller.impl.PcepPacketStatsImpl;
import org.onosproject.pcep.controller.impl.PcepPipelineFactory;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepError;
import org.onosproject.pcepio.protocol.PcepErrorInfo;
import org.onosproject.pcepio.protocol.PcepErrorMsg;
import org.onosproject.pcepio.protocol.PcepErrorObject;
import org.onosproject.pcepio.protocol.PcepFactory;
import org.onosproject.pcepio.protocol.PcepKeepaliveMsg;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepOpenMsg;
import org.onosproject.pcepio.protocol.PcepOpenObject;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.IPv4RouterIdOfLocalNodeSubTlv;
import org.onosproject.pcepio.types.NodeAttributesTlv;
import org.onosproject.pcepio.types.PceccCapabilityTlv;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.StatefulPceCapabilityTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PcepChannelHandler
extends IdleStateAwareChannelHandler {
    static final byte DEADTIMER_MAXIMUM_VALUE = -1;
    static final byte KEEPALIVE_MULTIPLE_FOR_DEADTIMER = 4;
    private static final Logger log = LoggerFactory.getLogger(PcepChannelHandler.class);
    private final Controller controller;
    private PcepClientDriver pc;
    private PccId thispccId;
    private Channel channel;
    private byte sessionId = 0;
    private byte keepAliveTime;
    private byte deadTime;
    private ClientCapability capability;
    private PcepPacketStatsImpl pcepPacketStats;
    static final int MAX_WRONG_COUNT_PACKET = 5;
    static final int BYTE_MASK = 255;
    private volatile ChannelState state;
    private String peerAddr;
    private SocketAddress address;
    private InetSocketAddress inetAddress;
    private volatile Boolean duplicatePccIdFound;
    protected PcepVersion pcepVersion;
    protected PcepFactory factory1;

    PcepChannelHandler(Controller controller) {
        this.controller = controller;
        this.state = ChannelState.INIT;
        this.factory1 = controller.getPcepMessageFactory1();
        this.duplicatePccIdFound = Boolean.FALSE;
        this.pcepPacketStats = new PcepPacketStatsImpl();
    }

    public void disconnectClient() {
        this.pc.disconnectClient();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channel = e.getChannel();
        log.info("PCC connected from {}", (Object)this.channel.getRemoteAddress());
        this.address = this.channel.getRemoteAddress();
        if (!(this.address instanceof InetSocketAddress)) {
            throw new IOException("Invalid peer connection.");
        }
        this.inetAddress = (InetSocketAddress)this.address;
        this.peerAddr = IpAddress.valueOf((InetAddress)this.inetAddress.getAddress()).toString();
        this.setState(ChannelState.OPENWAIT);
        this.controller.peerStatus(this.peerAddr, PcepCfg.State.OPENWAIT.toString(), this.sessionId);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        log.info("Pcc disconnected callback for pc:{}. Cleaning up ...", (Object)this.getClientInfoString());
        this.controller.peerStatus(this.peerAddr, PcepCfg.State.DOWN.toString(), this.sessionId);
        this.channel = e.getChannel();
        this.address = this.channel.getRemoteAddress();
        if (!(this.address instanceof InetSocketAddress)) {
            throw new IOException("Invalid peer connection.");
        }
        this.inetAddress = (InetSocketAddress)this.address;
        this.peerAddr = IpAddress.valueOf((InetAddress)this.inetAddress.getAddress()).toString();
        if (this.thispccId != null) {
            if (!this.duplicatePccIdFound.booleanValue()) {
                log.debug("{}:removal called", (Object)this.getClientInfoString());
                if (this.pc != null) {
                    this.pc.removeConnectedClient();
                }
            } else {
                log.debug("{}:duplicate found", (Object)this.getClientInfoString());
                this.duplicatePccIdFound = Boolean.FALSE;
            }
        } else {
            log.warn("no pccip in channelHandler registered for disconnected client {}", (Object)this.getClientInfoString());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        log.info("exceptionCaught: " + e.toString());
        if (e.getCause() instanceof ReadTimeoutException) {
            if (ChannelState.OPENWAIT == this.state) {
                PcepErrorMsg errMsg = this.getErrorMsg((byte)1, (byte)2);
                log.debug("Sending PCEP-ERROR message to PCC.");
                this.controller.peerExceptions(this.peerAddr, e.getCause().toString());
                this.channel.write(Collections.singletonList(errMsg));
                this.channel.close();
                this.state = ChannelState.INIT;
                return;
            }
            if (ChannelState.KEEPWAIT == this.state) {
                PcepErrorMsg errMsg = this.getErrorMsg((byte)1, (byte)7);
                log.debug("Sending PCEP-ERROR message to PCC.");
                this.controller.peerExceptions(this.peerAddr, e.getCause().toString());
                this.channel.write(Collections.singletonList(errMsg));
                this.channel.close();
                this.state = ChannelState.INIT;
                return;
            }
        } else if (e.getCause() instanceof ClosedChannelException) {
            this.controller.peerExceptions(this.peerAddr, e.getCause().toString());
            log.debug("Channel for pc {} already closed", (Object)this.getClientInfoString());
        } else if (e.getCause() instanceof IOException) {
            this.controller.peerExceptions(this.peerAddr, e.getCause().toString());
            log.error("Disconnecting client {} due to IO Error: {}", (Object)this.getClientInfoString(), (Object)e.getCause().getMessage());
            if (log.isDebugEnabled()) {
                log.debug("StackTrace for previous Exception: ", e.getCause());
            }
            this.channel.close();
        } else if (e.getCause() instanceof PcepParseException) {
            this.controller.peerExceptions(this.peerAddr, e.getCause().toString());
            PcepParseException errMsgParse = (PcepParseException)e.getCause();
            byte errorType = errMsgParse.getErrorType();
            byte errorValue = errMsgParse.getErrorValue();
            if (errorType == 0 && errorValue == 0) {
                this.processUnknownMsg();
            } else {
                PcepErrorMsg errMsg = this.getErrorMsg(errorType, errorValue);
                log.debug("Sending PCEP-ERROR message to PCC.");
                this.channel.write(Collections.singletonList(errMsg));
            }
        } else if (e.getCause() instanceof RejectedExecutionException) {
            log.warn("Could not process message: queue full");
            this.controller.peerExceptions(this.peerAddr, e.getCause().toString());
        } else {
            log.error("Error while processing message from client " + this.getClientInfoString() + "state " + (Object)((Object)this.state));
            this.controller.peerExceptions(this.peerAddr, e.getCause().toString());
            this.channel.close();
        }
    }

    public String toString() {
        return this.getClientInfoString();
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
        if (!this.isHandshakeComplete()) {
            return;
        }
        if (e.getState() == IdleState.READER_IDLE) {
            log.info("Disconnecting client {} due to read timeout", (Object)this.getClientInfoString());
            ctx.getChannel().close();
        } else if (e.getState() == IdleState.WRITER_IDLE) {
            log.debug("Sending keep alive message due to IdleState timeout " + this.pc.toString());
            this.pc.sendMessage(Collections.singletonList(this.pc.factory().buildKeepaliveMsg().build()));
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof List) {
            List msglist = (List)e.getMessage();
            for (PcepMessage pm : msglist) {
                this.state.processPcepMessage(this, pm);
            }
        } else {
            this.state.processPcepMessage(this, (PcepMessage)e.getMessage());
        }
    }

    public boolean isHandshakeComplete() {
        return this.state.isHandshakeComplete();
    }

    public void setHandshakeComplete(boolean handshakeComplete) {
        this.state.setHandshakeComplete(handshakeComplete);
    }

    private void dispatchMessage(PcepMessage m) {
        this.pc.handleMessage(m);
    }

    private void addNode() {
        this.pc.addNode((PcepClient)this.pc);
    }

    private void deleteNode() {
        this.pc.deleteNode(this.pc.getPccId());
    }

    private String getClientInfoString() {
        if (this.pc != null) {
            return this.pc.toString();
        }
        String channelString = this.channel == null || this.channel.getRemoteAddress() == null ? "?" : this.channel.getRemoteAddress().toString();
        String pccIpString = "?";
        return String.format("[%s PCCIP[%s]]", channelString, pccIpString);
    }

    private void setState(ChannelState state) {
        this.state = state;
    }

    private void sendHandshakeOpenMessage() throws IOException, PcepParseException {
        PcepOpenObject pcepOpenobj = this.factory1.buildOpenObject().setSessionId(this.sessionId).setKeepAliveTime(this.keepAliveTime).setDeadTime(this.deadTime).build();
        PcepOpenMsg msg = this.factory1.buildOpenMsg().setPcepOpenObj(pcepOpenobj).build();
        log.debug("Sending OPEN message to {}", (Object)this.channel.getRemoteAddress());
        this.channel.write(Collections.singletonList(msg));
    }

    private void capabilityNegotiation(PcepOpenMsg pOpenmsg) {
        LinkedList tlvList = pOpenmsg.getPcepOpenObject().getOptionalTlv();
        boolean pceccCapability = false;
        boolean statefulPceCapability = false;
        boolean pcInstantiationCapability = false;
        boolean labelStackCapability = false;
        boolean srCapability = false;
        ListIterator listIterator = tlvList.listIterator();
        block5: while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            switch (tlv.getType()) {
                case -249: {
                    pceccCapability = true;
                    if (!((PceccCapabilityTlv)tlv).sBit()) continue block5;
                    labelStackCapability = true;
                    continue block5;
                }
                case 16: {
                    statefulPceCapability = true;
                    StatefulPceCapabilityTlv stetefulPcCapTlv = (StatefulPceCapabilityTlv)tlv;
                    if (!stetefulPcCapTlv.getIFlag()) continue block5;
                    pcInstantiationCapability = true;
                    continue block5;
                }
                case 26: {
                    srCapability = true;
                    continue block5;
                }
            }
        }
        this.capability = new ClientCapability(pceccCapability, statefulPceCapability, pcInstantiationCapability, labelStackCapability, srCapability);
    }

    private void sendKeepAliveMessage() throws IOException, PcepParseException {
        PcepKeepaliveMsg msg = this.factory1.buildKeepaliveMsg().build();
        log.debug("Sending KEEPALIVE message to {}", (Object)this.channel.getRemoteAddress());
        this.channel.write(Collections.singletonList(msg));
    }

    private void sendErrMsgAndCloseChannel() {
        this.deleteNode();
        this.channel.close();
    }

    private void sendErrMsgForInvalidMsg() throws PcepParseException {
        byte errorType = 2;
        byte errorValue = 0;
        PcepErrorMsg errMsg = this.getErrorMsg(errorType, errorValue);
        this.channel.write(Collections.singletonList(errMsg));
    }

    public PcepErrorMsg getErrorMsg(byte errorType, byte errorValue) throws PcepParseException {
        LinkedList<PcepErrorObject> llerrObj = new LinkedList<PcepErrorObject>();
        PcepErrorObject errObj = this.factory1.buildPcepErrorObject().setErrorValue(errorValue).setErrorType(errorType).build();
        llerrObj.add(errObj);
        LinkedList<PcepError> llPcepErr = new LinkedList<PcepError>();
        PcepError pcepErr = this.factory1.buildPcepError().setErrorObjList(llerrObj).build();
        llPcepErr.add(pcepErr);
        PcepErrorInfo errInfo = this.factory1.buildPcepErrorInfo().setPcepErrorList(llPcepErr).build();
        PcepErrorMsg errMsg = this.factory1.buildPcepErrorMsg().setPcepErrorInfo(errInfo).build();
        return errMsg;
    }

    public void processUnknownMsg() throws PcepParseException {
        Date now = null;
        if (this.pcepPacketStats.wrongPacketCount() == 0) {
            now = new Date();
            this.pcepPacketStats.setTime(now.getTime());
            this.pcepPacketStats.addWrongPacket();
            this.sendErrMsgForInvalidMsg();
        }
        if (this.pcepPacketStats.wrongPacketCount() > 1) {
            Date lastest = new Date();
            this.pcepPacketStats.addWrongPacket();
            if ((lastest.getTime() - this.pcepPacketStats.getTime()) / 1000L > 60L) {
                now = lastest;
                this.pcepPacketStats.setTime(now.getTime());
                this.pcepPacketStats.resetWrongPacket();
                this.pcepPacketStats.addWrongPacket();
            } else if ((int)(lastest.getTime() - now.getTime()) / 1000 < 60 && 5 <= this.pcepPacketStats.wrongPacketCount()) {
                this.pcepPacketStats.resetWrongPacket();
                this.sendErrMsgAndCloseChannel();
            }
        }
    }

    static enum ChannelState {
        INIT(false){}
        ,
        OPENWAIT(false){

            @Override
            void processPcepMessage(PcepChannelHandler h, PcepMessage m) throws IOException, PcepParseException {
                log.info("Message received in OPEN WAIT State");
                if (m.getType() != PcepType.OPEN) {
                    h.processUnknownMsg();
                    log.debug("Message is not OPEN message");
                } else {
                    h.pcepPacketStats.addInPacket();
                    PcepOpenMsg pOpenmsg = (PcepOpenMsg)m;
                    h.capabilityNegotiation(pOpenmsg);
                    log.debug("Sending handshake OPEN message");
                    h.sessionId = pOpenmsg.getPcepOpenObject().getSessionId();
                    h.pcepVersion = pOpenmsg.getPcepOpenObject().getVersion();
                    byte yKeepalive = pOpenmsg.getPcepOpenObject().getKeepAliveTime();
                    byte yDeadTimer = pOpenmsg.getPcepOpenObject().getDeadTime();
                    h.keepAliveTime = yKeepalive;
                    if (yKeepalive < yDeadTimer) {
                        h.deadTime = yDeadTimer;
                    } else if (-1 > yKeepalive * 4) {
                        h.deadTime = (byte)(yKeepalive * 4);
                    } else {
                        h.deadTime = (byte)-1;
                    }
                    LinkedList optionalTlvs = pOpenmsg.getPcepOpenObject().getOptionalTlv();
                    if (optionalTlvs != null) {
                        block0: for (PcepValueType optionalTlv : optionalTlvs) {
                            if (!(optionalTlv instanceof NodeAttributesTlv)) continue;
                            List subTlvs = ((NodeAttributesTlv)optionalTlv).getllNodeAttributesSubTLVs();
                            if (subTlvs == null) break;
                            for (PcepValueType subTlv : subTlvs) {
                                if (!(subTlv instanceof IPv4RouterIdOfLocalNodeSubTlv)) continue;
                                h.thispccId = PccId.pccId((IpAddress)IpAddress.valueOf((int)((IPv4RouterIdOfLocalNodeSubTlv)subTlv).getInt()));
                                break block0;
                            }
                        }
                    }
                    if (h.thispccId == null) {
                        SocketAddress address = h.channel.getRemoteAddress();
                        if (!(address instanceof InetSocketAddress)) {
                            throw new IOException("Invalid client connection. Pcc is indentifed based on IP");
                        }
                        InetSocketAddress inetAddress = (InetSocketAddress)address;
                        h.thispccId = PccId.pccId((IpAddress)IpAddress.valueOf((InetAddress)inetAddress.getAddress()));
                    }
                    h.sendHandshakeOpenMessage();
                    h.pcepPacketStats.addOutPacket();
                    h.setState(2.KEEPWAIT);
                    h.controller.peerStatus(h.peerAddr.toString(), PcepCfg.State.KEEPWAIT.toString(), h.sessionId);
                }
            }
        }
        ,
        KEEPWAIT(false){

            @Override
            void processPcepMessage(PcepChannelHandler h, PcepMessage m) throws IOException, PcepParseException {
                log.info("Message received in KEEPWAIT state");
                if (m.getType() != PcepType.KEEP_ALIVE) {
                    h.processUnknownMsg();
                    log.error("Message is not KEEPALIVE message");
                } else {
                    h.pcepPacketStats.addInPacket();
                    log.debug("sending keep alive message in KEEPWAIT state");
                    h.pc = h.controller.getPcepClientInstance(h.thispccId, h.sessionId, h.pcepVersion, h.pcepPacketStats);
                    h.pc.setCapability(h.capability);
                    h.pc.setLspDbSyncStatus(PcepSyncStatus.NOT_SYNCED);
                    h.pc.setLabelDbSyncStatus(PcepSyncStatus.NOT_SYNCED);
                    h.pc.setConnected(true);
                    h.pc.setChannel(h.channel);
                    h.pc.setPcVersion(h.pcepVersion);
                    h.pc.setPcSessionId(h.sessionId);
                    h.pc.setPcKeepAliveTime(h.keepAliveTime);
                    h.pc.setPcDeadTime(h.deadTime);
                    int keepAliveTimer = h.keepAliveTime & 0xFF;
                    int deadTimer = h.deadTime & 0xFF;
                    if (0 == h.keepAliveTime) {
                        h.deadTime = (byte)0;
                    }
                    if (keepAliveTimer != 30 || deadTimer != 120) {
                        h.channel.getPipeline().replace("idle", "idle", (ChannelHandler)new IdleStateHandler(PcepPipelineFactory.TIMER, deadTimer, keepAliveTimer, 0));
                    }
                    log.debug("Dead timer : " + deadTimer);
                    log.debug("Keep alive time : " + keepAliveTimer);
                    h.sendKeepAliveMessage();
                    h.pcepPacketStats.addOutPacket();
                    h.setHandshakeComplete(true);
                    if (!h.pc.connectClient()) {
                        this.disconnectDuplicate(h);
                    } else {
                        h.setState(3.ESTABLISHED);
                        h.controller.peerStatus(h.peerAddr.toString(), PcepCfg.State.ESTABLISHED.toString(), h.sessionId);
                        h.addNode();
                    }
                }
            }
        }
        ,
        ESTABLISHED(true){

            @Override
            void processPcepMessage(PcepChannelHandler h, PcepMessage m) throws IOException, PcepParseException {
                log.debug("Message received in established state " + m.getType());
                h.dispatchMessage(m);
            }
        };

        private boolean handshakeComplete;

        private ChannelState(boolean handshakeComplete) {
            this.handshakeComplete = handshakeComplete;
        }

        void processPcepMessage(PcepChannelHandler h, PcepMessage m) throws IOException, PcepParseException {
        }

        public boolean isHandshakeComplete() {
            return this.handshakeComplete;
        }

        public void setHandshakeComplete(boolean handshakeComplete) {
            this.handshakeComplete = handshakeComplete;
        }

        protected void disconnectDuplicate(PcepChannelHandler h) {
            log.error("Duplicated Pcc IP or incompleted cleanup - disconnecting channel {}", (Object)h.getClientInfoString());
            h.duplicatePccIdFound = Boolean.TRUE;
            h.channel.disconnect();
        }
    }
}

