/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.controller.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.onlab.packet.IpAddress;
import org.onosproject.incubator.net.resource.label.DefaultLabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceAdminService;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.incubator.net.tunnel.DefaultLabelStack;
import org.onosproject.incubator.net.tunnel.LabelStack;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.device.DeviceService;
import org.onosproject.pcelabelstore.PcepLabelOp;
import org.onosproject.pcelabelstore.api.PceLabelStore;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepClientController;
import org.onosproject.pcep.controller.PcepSyncStatus;
import org.onosproject.pcep.controller.SrpIdGenerators;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFecObject;
import org.onosproject.pcepio.protocol.PcepFecObjectIPv4;
import org.onosproject.pcepio.protocol.PcepFecObjectIPv4Adjacency;
import org.onosproject.pcepio.protocol.PcepLabelObject;
import org.onosproject.pcepio.protocol.PcepLabelUpdate;
import org.onosproject.pcepio.protocol.PcepLabelUpdateMsg;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.types.PcepLabelMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PceccSrTeBeHandler {
    private static final Logger log = LoggerFactory.getLogger(PceccSrTeBeHandler.class);
    private static final String LABEL_RESOURCE_ADMIN_SERVICE_NULL = "Label Resource Admin Service cannot be null";
    private static final String LABEL_RESOURCE_SERVICE_NULL = "Label Resource Service cannot be null";
    private static final String PCE_STORE_NULL = "PCE Store cannot be null";
    private static final String DEVICE_ID_NULL = "Device-Id cannot be null";
    private static final String LSR_ID_NULL = "LSR-Id cannot be null";
    private static final String LINK_NULL = "Link cannot be null";
    private static final String PATH_NULL = "Path cannot be null";
    private static final String LSR_ID = "lsrId";
    private static PceccSrTeBeHandler srTeHandlerInstance = null;
    private LabelResourceAdminService labelRsrcAdminService;
    private LabelResourceService labelRsrcService;
    private DeviceService deviceService;
    private PcepClientController clientController;
    private PceLabelStore pceStore;

    private PceccSrTeBeHandler() {
    }

    public static PceccSrTeBeHandler getInstance() {
        if (srTeHandlerInstance == null) {
            srTeHandlerInstance = new PceccSrTeBeHandler();
        }
        return srTeHandlerInstance;
    }

    public void initialize(LabelResourceAdminService labelRsrcAdminService, LabelResourceService labelRsrcService, PcepClientController clientController, PceLabelStore pceStore, DeviceService deviceService) {
        this.labelRsrcAdminService = labelRsrcAdminService;
        this.labelRsrcService = labelRsrcService;
        this.clientController = clientController;
        this.pceStore = pceStore;
        this.deviceService = deviceService;
    }

    public boolean reserveGlobalPool(long beginLabel, long endLabel) {
        Preconditions.checkNotNull((Object)this.labelRsrcAdminService, (Object)LABEL_RESOURCE_ADMIN_SERVICE_NULL);
        return this.labelRsrcAdminService.createGlobalPool(LabelResourceId.labelResourceId((long)beginLabel), LabelResourceId.labelResourceId((long)endLabel));
    }

    public String getLsrId(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        Device device = this.deviceService.getDevice(deviceId);
        if (device == null) {
            log.debug("Device is not available for device id {} in device service.", (Object)deviceId.toString());
            return null;
        }
        if (device.annotations() == null) {
            log.debug("Device {} does not have annotation.", (Object)device.toString());
            return null;
        }
        String lsrId = device.annotations().value(LSR_ID);
        if (lsrId == null) {
            log.debug("The lsr-id of device {} is null.", (Object)device.toString());
            return null;
        }
        return lsrId;
    }

    public boolean allocateNodeLabel(DeviceId specificDeviceId, String specificLsrId) {
        long applyNum = 1L;
        LabelResourceId specificLabelId = null;
        Preconditions.checkNotNull((Object)specificDeviceId, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)specificLsrId, (Object)LSR_ID_NULL);
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        if (this.pceStore.getGlobalNodeLabel(specificDeviceId) != null) {
            log.debug("Node label was already configured for device {}.", (Object)specificDeviceId.toString());
            return false;
        }
        Collection result = this.labelRsrcService.applyFromGlobalPool(applyNum);
        if (!result.isEmpty()) {
            Iterator iterator = result.iterator();
            DefaultLabelResource defaultLabelResource = (DefaultLabelResource)iterator.next();
            specificLabelId = defaultLabelResource.labelResourceId();
            if (specificLabelId == null) {
                log.error("Unable to retrieve global node label for a device id {}.", (Object)specificDeviceId.toString());
                return false;
            }
        } else {
            log.error("Unable to allocate global node label for a device id {}.", (Object)specificDeviceId.toString());
            return false;
        }
        this.pceStore.addGlobalNodeLabel(specificDeviceId, specificLabelId);
        PcepClient pcc = this.getPcepClient(specificDeviceId);
        try {
            this.pushGlobalNodeLabel(pcc, specificLabelId, IpAddress.valueOf((String)specificLsrId).getIp4Address().toInt(), PcepLabelOp.ADD, false);
        }
        catch (PcepParseException e) {
            log.error("Failed to push global node label for LSR {}.", (Object)specificLsrId.toString());
        }
        for (Map.Entry<DeviceId, LabelResourceId> element : this.pceStore.getGlobalNodeLabels().entrySet()) {
            DeviceId otherDevId = element.getKey();
            String otherLsrId = this.getLsrId(otherDevId);
            if (otherLsrId == null) {
                log.error("The lsr-id of device id {} is null.", (Object)otherDevId.toString());
                this.releaseNodeLabel(specificDeviceId, specificLsrId);
                return false;
            }
            if (otherDevId.equals((Object)specificDeviceId)) continue;
            try {
                this.pushGlobalNodeLabel(this.getPcepClient(otherDevId), specificLabelId, IpAddress.valueOf((String)specificLsrId).getIp4Address().toInt(), PcepLabelOp.ADD, false);
                this.pushGlobalNodeLabel(pcc, element.getValue(), IpAddress.valueOf((String)otherLsrId).getIp4Address().toInt(), PcepLabelOp.ADD, false);
            }
            catch (PcepParseException e) {
                log.error("Failed to push global node label for LSR {} or LSR {}.", (Object)specificLsrId.toString(), (Object)otherLsrId.toString());
            }
        }
        return true;
    }

    public boolean releaseNodeLabel(DeviceId specificDeviceId, String specificLsrId) {
        Preconditions.checkNotNull((Object)specificDeviceId, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)specificLsrId, (Object)LSR_ID_NULL);
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        boolean retValue = true;
        LabelResourceId labelId = this.pceStore.getGlobalNodeLabel(specificDeviceId);
        if (labelId == null) {
            log.error("Unable to retrieve label of a device id {} from store.", (Object)specificDeviceId.toString());
            return false;
        }
        for (Map.Entry<DeviceId, LabelResourceId> element : this.pceStore.getGlobalNodeLabels().entrySet()) {
            DeviceId otherDevId = element.getKey();
            if (specificDeviceId.equals((Object)otherDevId)) continue;
            try {
                this.pushGlobalNodeLabel(this.getPcepClient(otherDevId), labelId, IpAddress.valueOf((String)specificLsrId).getIp4Address().toInt(), PcepLabelOp.REMOVE, false);
            }
            catch (PcepParseException e) {
                log.error("Failed to push global node label for LSR {}.", (Object)specificLsrId.toString());
            }
        }
        HashSet<LabelResourceId> release = new HashSet<LabelResourceId>();
        release.add(labelId);
        if (!this.labelRsrcService.releaseToGlobalPool(release)) {
            log.error("Unable to release label id {} from label manager.", (Object)labelId.toString());
            retValue = false;
        }
        if (!this.pceStore.removeGlobalNodeLabel(specificDeviceId)) {
            log.error("Unable to remove global node label id {} from store.", (Object)labelId.toString());
            retValue = false;
        }
        return retValue;
    }

    public boolean allocateAdjacencyLabel(Link link) {
        long applyNum = 1L;
        DeviceId srcDeviceId = link.src().deviceId();
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        LabelResourceId labelId = this.pceStore.getAdjLabel(link);
        if (labelId != null) {
            log.debug("Adjacency label {} was already allocated for a link {}.", (Object)labelId.toString(), (Object)link.toString());
            return false;
        }
        Collection labelList = this.labelRsrcService.applyFromDevicePool(srcDeviceId, applyNum);
        if (labelList.isEmpty()) {
            log.error("Unable to allocate label to a device id {}.", (Object)srcDeviceId.toString());
            return false;
        }
        Iterator iterator = labelList.iterator();
        DefaultLabelResource defaultLabelResource = (DefaultLabelResource)iterator.next();
        labelId = defaultLabelResource.labelResourceId();
        if (labelId == null) {
            log.error("Unable to allocate label to a device id {}.", (Object)srcDeviceId.toString());
            return false;
        }
        log.debug("Allocated adjacency label {} to a link {}.", (Object)labelId.toString(), (Object)link.toString());
        try {
            this.pushAdjacencyLabel(this.getPcepClient(srcDeviceId), labelId, (int)link.src().port().toLong(), (int)link.dst().port().toLong(), PcepLabelOp.ADD);
        }
        catch (PcepParseException e) {
            log.error("Failed to push adjacency label for link {}-{}.", (Object)((int)link.src().port().toLong()), (Object)((int)link.dst().port().toLong()));
        }
        this.pceStore.addAdjLabel(link, labelId);
        return true;
    }

    public boolean releaseAdjacencyLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        boolean retValue = true;
        LabelResourceId labelId = this.pceStore.getAdjLabel(link);
        if (labelId == null) {
            log.error("Unabel to retrieve label for a link {} from store.", (Object)link.toString());
            return false;
        }
        DeviceId srcDeviceId = link.src().deviceId();
        try {
            this.pushAdjacencyLabel(this.getPcepClient(srcDeviceId), labelId, (int)link.src().port().toLong(), (int)link.dst().port().toLong(), PcepLabelOp.REMOVE);
        }
        catch (PcepParseException e) {
            log.error("Failed to push adjacency label for link {}-{}.", (Object)((int)link.src().port().toLong()), (Object)((int)link.dst().port().toLong()));
        }
        ArrayListMultimap release = ArrayListMultimap.create();
        DefaultLabelResource defaultLabelResource = new DefaultLabelResource(srcDeviceId, labelId);
        release.put((Object)srcDeviceId, (Object)defaultLabelResource);
        if (!this.labelRsrcService.releaseToDevicePool((Multimap)release)) {
            log.error("Unable to release label id {} from label manager.", (Object)labelId.toString());
            retValue = false;
        }
        if (!this.pceStore.removeAdjLabel(link)) {
            log.error("Unable to remove adjacency label id {} from store.", (Object)labelId.toString());
            retValue = false;
        }
        return retValue;
    }

    public LabelStack computeLabelStack(Path path) {
        Preconditions.checkNotNull((Object)path, (Object)PATH_NULL);
        LinkedList<LabelResourceId> labelStack = new LinkedList<LabelResourceId>();
        List linkList = path.links();
        if (linkList != null && !linkList.isEmpty()) {
            Link link2 = null;
            LabelResourceId nodeLabelId = null;
            LabelResourceId adjLabelId = null;
            DeviceId deviceId = null;
            for (Link link2 : linkList) {
                adjLabelId = this.pceStore.getAdjLabel(link2);
                if (adjLabelId == null) {
                    log.error("Adjacency label id is null for a link {}.", (Object)link2.toString());
                    return null;
                }
                labelStack.add(adjLabelId);
                deviceId = link2.dst().deviceId();
                nodeLabelId = this.pceStore.getGlobalNodeLabel(deviceId);
                if (nodeLabelId == null) {
                    log.error("Unable to find node label for a device id {} in store.", (Object)deviceId.toString());
                    return null;
                }
                labelStack.add(nodeLabelId);
            }
        } else {
            log.debug("Empty link in path.");
            return null;
        }
        return new DefaultLabelStack(labelStack);
    }

    void pushGlobalNodeLabel(PcepClient pc, LabelResourceId labelId, int labelForNode, PcepLabelOp type, boolean isBos) throws PcepParseException {
        Preconditions.checkNotNull((Object)pc);
        Preconditions.checkNotNull((Object)labelId);
        Preconditions.checkNotNull((Object)((Object)type));
        LinkedList<PcepLabelUpdate> labelUpdateList = new LinkedList<PcepLabelUpdate>();
        PcepFecObjectIPv4 fecObject = pc.factory().buildFecObjectIpv4().setNodeID(labelForNode).build();
        boolean bSFlag = false;
        if (pc.labelDbSyncStatus() == PcepSyncStatus.IN_SYNC && !isBos) {
            bSFlag = true;
        }
        PcepSrpObject srpObj = this.getSrpObject(pc, type, bSFlag);
        PcepLabelObject labelObject = pc.factory().buildLabelObject().setLabel((int)labelId.labelId()).build();
        PcepLabelMap labelMap = new PcepLabelMap();
        labelMap.setFecObject((PcepFecObject)fecObject);
        labelMap.setLabelObject(labelObject);
        labelMap.setSrpObject(srpObj);
        labelUpdateList.add(pc.factory().buildPcepLabelUpdateObject().setLabelMap(labelMap).build());
        PcepLabelUpdateMsg labelMsg = pc.factory().buildPcepLabelUpdateMsg().setPcLabelUpdateList(labelUpdateList).build();
        pc.sendMessage((PcepMessage)labelMsg);
        if (isBos) {
            pc.setLabelDbSyncStatus(PcepSyncStatus.SYNCED);
        }
    }

    void pushAdjacencyLabel(PcepClient pc, LabelResourceId labelId, int srcPortNo, int dstPortNo, PcepLabelOp type) throws PcepParseException {
        Preconditions.checkNotNull((Object)pc);
        Preconditions.checkNotNull((Object)labelId);
        Preconditions.checkNotNull((Object)((Object)type));
        LinkedList<PcepLabelUpdate> labelUpdateList = new LinkedList<PcepLabelUpdate>();
        PcepFecObjectIPv4Adjacency fecAdjObject = pc.factory().buildFecIpv4Adjacency().seRemoteIPv4Address(dstPortNo).seLocalIPv4Address(srcPortNo).build();
        boolean bSFlag = false;
        if (pc.labelDbSyncStatus() == PcepSyncStatus.IN_SYNC) {
            bSFlag = true;
        }
        PcepSrpObject srpObj = this.getSrpObject(pc, type, bSFlag);
        PcepLabelObject labelObject = pc.factory().buildLabelObject().setLabel((int)labelId.labelId()).build();
        PcepLabelMap labelMap = new PcepLabelMap();
        labelMap.setFecObject((PcepFecObject)fecAdjObject);
        labelMap.setLabelObject(labelObject);
        labelMap.setSrpObject(srpObj);
        labelUpdateList.add(pc.factory().buildPcepLabelUpdateObject().setLabelMap(labelMap).build());
        PcepLabelUpdateMsg labelMsg = pc.factory().buildPcepLabelUpdateMsg().setPcLabelUpdateList(labelUpdateList).build();
        pc.sendMessage((PcepMessage)labelMsg);
    }

    private PcepSrpObject getSrpObject(PcepClient pc, PcepLabelOp type, boolean bSFlag) throws PcepParseException {
        boolean bRFlag = false;
        if (!type.equals((Object)PcepLabelOp.ADD)) {
            bRFlag = true;
        }
        PcepSrpObject srpObj = pc.factory().buildSrpObject().setRFlag(bRFlag).setSFlag(bSFlag).setSrpID(SrpIdGenerators.create()).build();
        return srpObj;
    }

    private PcepClient getPcepClient(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        String lsrId = device.annotations().value(LSR_ID);
        PcepClient pcc = this.clientController.getClient(PccId.pccId((IpAddress)IpAddress.valueOf((String)lsrId)));
        return pcc;
    }
}

