/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.controller.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.onlab.util.Tools;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepCfg;
import org.onosproject.pcep.controller.PcepPacketStats;
import org.onosproject.pcep.controller.driver.PcepAgent;
import org.onosproject.pcep.controller.driver.PcepClientDriver;
import org.onosproject.pcep.controller.impl.PcepClientImpl;
import org.onosproject.pcep.controller.impl.PcepConfig;
import org.onosproject.pcep.controller.impl.PcepPipelineFactory;
import org.onosproject.pcepio.protocol.PcepFactories;
import org.onosproject.pcepio.protocol.PcepFactory;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    private static final PcepFactory FACTORY1 = PcepFactories.getFactory((PcepVersion)PcepVersion.PCEP_1);
    private PcepCfg pcepConfig = new PcepConfig();
    private ChannelGroup cg;
    private int pcepPort = 4189;
    private int workerThreads = 10;
    private long systemStartTime;
    private PcepAgent agent;
    private Map<String, String> peerMap = new TreeMap<String, String>();
    private Map<String, List<String>> pcepExceptionMap = new TreeMap<String, List<String>>();
    private Map<Integer, Integer> pcepErrorMsg = new TreeMap<Integer, Integer>();
    private Map<String, Byte> sessionMap = new TreeMap<String, Byte>();
    private LinkedList<String> pcepExceptionList = new LinkedList();
    private NioServerSocketChannelFactory execFactory;
    private static final int SEND_BUFFER_SIZE = 0x400000;

    public void peerStatus(String peerId, String status, byte sessionId) {
        if (peerId != null) {
            this.peerMap.put(peerId, status);
            this.sessionMap.put(peerId, sessionId);
        } else {
            log.debug("Peer Id is null");
        }
    }

    public void peerExceptions(String peerId, String exception) {
        if (peerId != null) {
            this.pcepExceptionList.add(exception);
            this.pcepExceptionMap.put(peerId, this.pcepExceptionList);
        } else {
            log.debug("Peer Id is null");
        }
        if (this.pcepExceptionList.size() > 10) {
            this.pcepExceptionList.clear();
            this.pcepExceptionList.add(exception);
            this.pcepExceptionMap.put(peerId, this.pcepExceptionList);
        }
    }

    public void peerErrorMsg(String peerId, Integer errorType, Integer errValue) {
        if (peerId == null) {
            this.pcepErrorMsg.put(errorType, errValue);
        } else {
            if (this.pcepErrorMsg.size() > 10) {
                this.pcepErrorMsg.clear();
            }
            this.pcepErrorMsg.put(errorType, errValue);
        }
    }

    public Map<String, Byte> mapSession() {
        return this.sessionMap;
    }

    public PcepFactory getPcepMessageFactory1() {
        return FACTORY1;
    }

    public long getSystemStartTime() {
        return this.systemStartTime;
    }

    public Map<String, String> mapPeer() {
        return this.peerMap;
    }

    public Map<String, List<String>> exceptionsMap() {
        return this.pcepExceptionMap;
    }

    public Map<Integer, Integer> mapErrorMsg() {
        return this.pcepErrorMsg;
    }

    public void run() {
        try {
            ServerBootstrap bootstrap = this.createServerBootStrap();
            bootstrap.setOption("reuseAddr", (Object)true);
            bootstrap.setOption("child.keepAlive", (Object)true);
            bootstrap.setOption("child.tcpNoDelay", (Object)true);
            bootstrap.setOption("child.sendBufferSize", (Object)0x400000);
            PcepPipelineFactory pfact = new PcepPipelineFactory(this);
            bootstrap.setPipelineFactory((ChannelPipelineFactory)pfact);
            InetSocketAddress sa = new InetSocketAddress(this.pcepPort);
            this.cg = new DefaultChannelGroup();
            this.cg.add((Object)bootstrap.bind((SocketAddress)sa));
            log.debug("Listening for PCC connection on {}", (Object)sa);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ServerBootstrap createServerBootStrap() {
        if (this.workerThreads == 0) {
            this.execFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/pcep", (String)"boss-%d")), (Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/pcep", (String)"worker-%d")));
            return new ServerBootstrap((ChannelFactory)this.execFactory);
        }
        this.execFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/pcep", (String)"boss-%d")), (Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/pcep", (String)"worker-%d")), this.workerThreads);
        return new ServerBootstrap((ChannelFactory)this.execFactory);
    }

    public void init() {
        this.systemStartTime = System.currentTimeMillis();
    }

    public Map<String, Long> getMemory() {
        HashMap<String, Long> m = new HashMap<String, Long>();
        Runtime runtime = Runtime.getRuntime();
        m.put("total", runtime.totalMemory());
        m.put("free", runtime.freeMemory());
        return m;
    }

    public Long getUptime() {
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        return rb.getUptime();
    }

    protected PcepClientDriver getPcepClientInstance(PccId pccId, int sessionID, PcepVersion pv, PcepPacketStats pktStats) {
        PcepClientImpl pcepClientDriver = new PcepClientImpl();
        pcepClientDriver.init(pccId, pv, pktStats);
        pcepClientDriver.setAgent(this.agent);
        return pcepClientDriver;
    }

    public void start(PcepAgent ag) {
        log.info("Started");
        this.agent = ag;
        this.init();
        this.run();
    }

    public void stop() {
        log.info("Stopped");
        this.execFactory.shutdown();
        this.cg.close();
    }
}

