/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.controller.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onosproject.incubator.net.resource.label.DefaultLabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.pcelabelstore.DefaultLspLocalLabelInfo;
import org.onosproject.pcelabelstore.PcepLabelOp;
import org.onosproject.pcelabelstore.api.LspLocalLabelInfo;
import org.onosproject.pcelabelstore.api.PceLabelStore;
import org.onosproject.pcep.controller.LspType;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepClientController;
import org.onosproject.pcep.controller.SrpIdGenerators;
import org.onosproject.pcep.controller.impl.LabelType;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepAttribute;
import org.onosproject.pcepio.protocol.PcepBandwidthObject;
import org.onosproject.pcepio.protocol.PcepEroObject;
import org.onosproject.pcepio.protocol.PcepLabelObject;
import org.onosproject.pcepio.protocol.PcepLabelUpdate;
import org.onosproject.pcepio.protocol.PcepLabelUpdateMsg;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMsgPath;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.protocol.PcepUpdateMsg;
import org.onosproject.pcepio.protocol.PcepUpdateRequest;
import org.onosproject.pcepio.types.IPv4SubObject;
import org.onosproject.pcepio.types.NexthopIPv4addressTlv;
import org.onosproject.pcepio.types.PathSetupTypeTlv;
import org.onosproject.pcepio.types.PcepLabelDownload;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.StatefulIPv4LspIdentifiersTlv;
import org.onosproject.pcepio.types.SymbolicPathNameTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicPceccHandler {
    private static final Logger log = LoggerFactory.getLogger(BasicPceccHandler.class);
    public static final int OUT_LABEL_TYPE = 0;
    public static final int IN_LABEL_TYPE = 1;
    public static final long IDENTIFIER_SET = 0x100000000L;
    public static final long SET = 0xFFFFFFFFL;
    private static final String LSRID = "lsrId";
    private static final String LABEL_RESOURCE_SERVICE_NULL = "Label Resource Service cannot be null";
    private static final String PCE_STORE_NULL = "PCE Store cannot be null";
    private static BasicPceccHandler crHandlerInstance = null;
    private LabelResourceService labelRsrcService;
    private DeviceService deviceService;
    private PceLabelStore pceStore;
    private PcepClientController clientController;
    private PcepLabelObject labelObj;

    private BasicPceccHandler() {
    }

    public static BasicPceccHandler getInstance() {
        if (crHandlerInstance == null) {
            crHandlerInstance = new BasicPceccHandler();
        }
        return crHandlerInstance;
    }

    public void initialize(LabelResourceService labelRsrcService, DeviceService deviceService, PceLabelStore pceStore, PcepClientController clientController) {
        this.labelRsrcService = labelRsrcService;
        this.deviceService = deviceService;
        this.pceStore = pceStore;
        this.clientController = clientController;
    }

    public boolean allocateLabel(Tunnel tunnel) {
        long applyNum = 1L;
        boolean isLastLabelToPush = false;
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        List linkList = tunnel.path().links();
        if (linkList != null && !linkList.isEmpty()) {
            ListIterator iterator = linkList.listIterator(linkList.size());
            while (iterator.hasPrevious()) {
                Link link = (Link)iterator.previous();
                DeviceId dstDeviceId = link.dst().deviceId();
                DeviceId srcDeviceId = link.src().deviceId();
                Collection labelRscList = this.labelRsrcService.applyFromDevicePool(dstDeviceId, applyNum);
                if (labelRscList != null && !labelRscList.isEmpty()) {
                    Iterator labelIterator = labelRscList.iterator();
                    DefaultLabelResource defaultLabelResource = (DefaultLabelResource)labelIterator.next();
                    LabelResourceId labelId = defaultLabelResource.labelResourceId();
                    log.debug("Allocated local label: " + labelId.toString() + "to device: " + defaultLabelResource.deviceId().toString());
                    PortNumber dstPort = link.dst().port();
                    if (!iterator.hasPrevious()) {
                        isLastLabelToPush = true;
                    }
                    try {
                        this.pushLocalLabels(dstDeviceId, labelId, dstPort, tunnel, false, Long.valueOf(LabelType.IN_LABEL.value), PcepLabelOp.ADD);
                        this.pushLocalLabels(srcDeviceId, labelId, dstPort, tunnel, isLastLabelToPush, Long.valueOf(LabelType.OUT_LABEL.value), PcepLabelOp.ADD);
                    }
                    catch (PcepParseException e) {
                        log.error("Failed to push local label for device {} or {} for tunnel {}.", new Object[]{dstDeviceId.toString(), srcDeviceId.toString(), tunnel.tunnelName().toString()});
                    }
                    this.updatePceccTunnelInfoInStore(srcDeviceId, dstDeviceId, labelId, dstPort, tunnel);
                    continue;
                }
                log.error("Unable to allocate label to device id {}.", (Object)dstDeviceId.toString());
                this.releaseLabel(tunnel);
                return false;
            }
        } else {
            log.error("Tunnel {} is having empty links.", (Object)tunnel.toString());
            return false;
        }
        return true;
    }

    public void updatePceccTunnelInfoInStore(DeviceId srcDeviceId, DeviceId dstDeviceId, LabelResourceId labelId, PortNumber dstPort, Tunnel tunnel) {
        boolean dstDeviceUpdated = false;
        boolean srcDeviceUpdated = false;
        List<LspLocalLabelInfo> lspLabelInfoList = this.pceStore.getTunnelInfo(tunnel.tunnelId());
        if (lspLabelInfoList != null && !lspLabelInfoList.isEmpty()) {
            for (int i = 0; i < lspLabelInfoList.size(); ++i) {
                LspLocalLabelInfo lspLocalLabelInfo = lspLabelInfoList.get(i);
                DefaultLspLocalLabelInfo.Builder lspLocalLabelInfoBuilder = null;
                if (dstDeviceId.equals((Object)lspLocalLabelInfo.deviceId())) {
                    lspLocalLabelInfoBuilder = DefaultLspLocalLabelInfo.builder(lspLocalLabelInfo);
                    lspLocalLabelInfoBuilder.inLabelId(labelId);
                    lspLocalLabelInfoBuilder.inPort(dstPort);
                    dstDeviceUpdated = true;
                } else if (srcDeviceId.equals((Object)lspLocalLabelInfo.deviceId())) {
                    lspLocalLabelInfoBuilder = DefaultLspLocalLabelInfo.builder(lspLocalLabelInfo);
                    lspLocalLabelInfoBuilder.outLabelId(labelId);
                    lspLocalLabelInfoBuilder.outPort(dstPort);
                    srcDeviceUpdated = true;
                }
                if (lspLocalLabelInfoBuilder == null || !dstDeviceUpdated && !srcDeviceUpdated) continue;
                lspLabelInfoList.set(i, lspLocalLabelInfoBuilder.build());
            }
        }
        if (!dstDeviceUpdated || !srcDeviceUpdated) {
            if (lspLabelInfoList == null) {
                lspLabelInfoList = new LinkedList<LspLocalLabelInfo>();
            }
            if (!dstDeviceUpdated) {
                LspLocalLabelInfo lspLocalLabelInfo = DefaultLspLocalLabelInfo.builder().deviceId(dstDeviceId).inLabelId(labelId).outLabelId(null).inPort(dstPort).outPort(null).build();
                lspLabelInfoList.add(lspLocalLabelInfo);
            }
            if (!srcDeviceUpdated) {
                LspLocalLabelInfo lspLocalLabelInfo = DefaultLspLocalLabelInfo.builder().deviceId(srcDeviceId).inLabelId(null).outLabelId(labelId).inPort(null).outPort(dstPort).build();
                lspLabelInfoList.add(lspLocalLabelInfo);
            }
            this.pceStore.addTunnelInfo(tunnel.tunnelId(), lspLabelInfoList);
        }
    }

    public void releaseLabel(Tunnel tunnel) {
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        ArrayListMultimap release = ArrayListMultimap.create();
        List<LspLocalLabelInfo> lspLocalLabelInfoList = this.pceStore.getTunnelInfo(tunnel.tunnelId());
        if (lspLocalLabelInfoList != null && !lspLocalLabelInfoList.isEmpty()) {
            Iterator<LspLocalLabelInfo> iterator = lspLocalLabelInfoList.iterator();
            while (iterator.hasNext()) {
                LspLocalLabelInfo lspLocalLabelInfo = iterator.next();
                DeviceId deviceId = lspLocalLabelInfo.deviceId();
                LabelResourceId inLabelId = lspLocalLabelInfo.inLabelId();
                LabelResourceId outLabelId = lspLocalLabelInfo.outLabelId();
                PortNumber inPort = lspLocalLabelInfo.inPort();
                PortNumber outPort = lspLocalLabelInfo.outPort();
                try {
                    if (outLabelId != null && outPort != null) {
                        this.pushLocalLabels(deviceId, outLabelId, outPort, tunnel, false, Long.valueOf(LabelType.OUT_LABEL.value), PcepLabelOp.REMOVE);
                    }
                    if (inLabelId != null && inPort != null) {
                        this.pushLocalLabels(deviceId, inLabelId, inPort, tunnel, false, Long.valueOf(LabelType.IN_LABEL.value), PcepLabelOp.REMOVE);
                    }
                }
                catch (PcepParseException e) {
                    log.error("Failed to push local label for device {}for tunnel {}.", (Object)deviceId.toString(), (Object)tunnel.tunnelName().toString());
                }
                if (!iterator.hasNext() || inLabelId == null) continue;
                DefaultLabelResource labelRsc = new DefaultLabelResource(deviceId, inLabelId);
                release.put((Object)deviceId, (Object)labelRsc);
            }
        }
        if (!release.isEmpty()) {
            this.labelRsrcService.releaseToDevicePool((Multimap)release);
        }
        this.pceStore.removeTunnelInfo(tunnel.tunnelId());
    }

    private void pushLocalLabels(DeviceId deviceId, LabelResourceId labelId, PortNumber portNum, Tunnel tunnel, Boolean isBos, Long labelType, PcepLabelOp type) throws PcepParseException {
        Preconditions.checkNotNull((Object)deviceId);
        Preconditions.checkNotNull((Object)labelId);
        Preconditions.checkNotNull((Object)portNum);
        Preconditions.checkNotNull((Object)tunnel);
        Preconditions.checkNotNull((Object)labelType);
        Preconditions.checkNotNull((Object)((Object)type));
        PcepClient pc = this.getPcepClient(deviceId);
        if (pc == null) {
            log.error("PCEP client not found");
            return;
        }
        LinkedList<PcepLabelUpdate> labelUpdateList = new LinkedList<PcepLabelUpdate>();
        LinkedList<PcepLabelObject> labelObjects = new LinkedList<PcepLabelObject>();
        PcepLabelDownload labelDownload = new PcepLabelDownload();
        LinkedList<NexthopIPv4addressTlv> optionalTlv = new LinkedList<NexthopIPv4addressTlv>();
        long portNo = portNum.toLong();
        portNo = (portNo & 0x100000000L) == 0x100000000L ? portNo & 0xFFFFFFFFL : portNo;
        optionalTlv.add(NexthopIPv4addressTlv.of((int)((int)portNo)));
        PcepLabelObject labelObj = pc.factory().buildLabelObject().setOFlag(labelType == 0L).setOptionalTlv(optionalTlv).setLabel((int)labelId.labelId()).build();
        if (!deviceId.equals((Object)tunnel.path().src().deviceId()) && !deviceId.equals((Object)tunnel.path().dst().deviceId())) {
            if (labelType == 0L) {
                this.labelObj = labelObj;
                return;
            }
            labelObjects.add(this.labelObj);
        }
        labelObjects.add(labelObj);
        PcepSrpObject srpObj = this.getSrpObject(pc, type, false);
        String lspId = tunnel.annotations().value("localLspId");
        String plspId = tunnel.annotations().value("PLspId");
        String tunnelIdentifier = tunnel.annotations().value("PccTunnelId");
        LinkedList<Object> tlvs = new LinkedList<Object>();
        StatefulIPv4LspIdentifiersTlv lspIdTlv = new StatefulIPv4LspIdentifiersTlv(((IpTunnelEndPoint)tunnel.src()).ip().getIp4Address().toInt(), Short.valueOf(lspId).shortValue(), Short.valueOf(tunnelIdentifier).shortValue(), ((IpTunnelEndPoint)tunnel.src()).ip().getIp4Address().toInt(), ((IpTunnelEndPoint)tunnel.dst()).ip().getIp4Address().toInt());
        tlvs.add(lspIdTlv);
        if (tunnel.tunnelName().value() != null) {
            SymbolicPathNameTlv pathNameTlv = new SymbolicPathNameTlv(tunnel.tunnelName().value().getBytes());
            tlvs.add(pathNameTlv);
        }
        boolean delegated = tunnel.annotations().value("delegate") == null ? false : Boolean.valueOf(tunnel.annotations().value("delegate"));
        boolean initiated = tunnel.annotations().value("pceInit") == null ? false : Boolean.valueOf(tunnel.annotations().value("pceInit"));
        PcepLspObject lspObj = pc.factory().buildLspObject().setRFlag(false).setAFlag(true).setDFlag(delegated).setCFlag(initiated).setPlspId(Integer.valueOf(plspId).intValue()).setOptionalTlv(tlvs).build();
        labelDownload.setLabelList(labelObjects);
        labelDownload.setLspObject(lspObj);
        labelDownload.setSrpObject(srpObj);
        labelUpdateList.add(pc.factory().buildPcepLabelUpdateObject().setLabelDownload(labelDownload).build());
        PcepLabelUpdateMsg labelMsg = pc.factory().buildPcepLabelUpdateMsg().setPcLabelUpdateList(labelUpdateList).build();
        pc.sendMessage((PcepMessage)labelMsg);
        if (isBos.booleanValue()) {
            this.sendPcepUpdateMsg(pc, lspObj, tunnel);
        }
    }

    private void sendPcepUpdateMsg(PcepClient pc, PcepLspObject lspObj, Tunnel tunnel) throws PcepParseException {
        LinkedList<PcepUpdateRequest> updateRequestList = new LinkedList<PcepUpdateRequest>();
        LinkedList<PcepValueType> subObjects = this.createEroSubObj(tunnel.path());
        if (subObjects == null) {
            log.error("ERO subjects not present");
            return;
        }
        LinkedList<PathSetupTypeTlv> llOptionalTlv = new LinkedList<PathSetupTypeTlv>();
        LspType lspSigType = LspType.valueOf((String)tunnel.annotations().value("lspSigType"));
        llOptionalTlv.add(new PathSetupTypeTlv(lspSigType.type()));
        PcepSrpObject srpObj = pc.factory().buildSrpObject().setRFlag(false).setSrpID(SrpIdGenerators.create()).setOptionalTlv(llOptionalTlv).build();
        PcepEroObject eroObj = pc.factory().buildEroObject().setSubObjects(subObjects).build();
        float iBandwidth = 0.0f;
        if (tunnel.annotations().value("bandwidth") != null) {
            iBandwidth = Float.parseFloat(tunnel.annotations().value("bandwidth"));
        }
        PcepBandwidthObject bandwidthObject = pc.factory().buildBandwidthObject().setBandwidth(iBandwidth).build();
        PcepAttribute pcepAttribute = pc.factory().buildPcepAttribute().setBandwidthObject(bandwidthObject).build();
        PcepMsgPath msgPath = pc.factory().buildPcepMsgPath().setEroObject(eroObj).setPcepAttribute(pcepAttribute).build();
        PcepUpdateRequest updateReq = pc.factory().buildPcepUpdateRequest().setSrpObject(srpObj).setMsgPath(msgPath).setLspObject(lspObj).build();
        updateRequestList.add(updateReq);
        PcepUpdateMsg updateMsg = pc.factory().buildUpdateMsg().setUpdateRequestList(updateRequestList).build();
        pc.sendMessage((PcepMessage)updateMsg);
    }

    private LinkedList<PcepValueType> createEroSubObj(Path path) {
        LinkedList<PcepValueType> subObjects = new LinkedList<PcepValueType>();
        List links = path.links();
        ConnectPoint source = null;
        ConnectPoint destination = null;
        Ip4Address ipDstAddress = null;
        Ip4Address ipSrcAddress = null;
        IPv4SubObject subObj = null;
        for (Link link : links) {
            long portNo;
            source = link.src();
            if (!source.equals(destination)) {
                portNo = source.port().toLong();
                portNo = (portNo & 0x100000000L) == 0x100000000L ? portNo & 0xFFFFFFFFL : portNo;
                ipSrcAddress = Ip4Address.valueOf((int)((int)portNo));
                subObj = new IPv4SubObject(ipSrcAddress.getIp4Address().toInt());
                subObjects.add((PcepValueType)subObj);
            }
            portNo = ((portNo = (destination = link.dst()).port().toLong()) & 0x100000000L) == 0x100000000L ? portNo & 0xFFFFFFFFL : portNo;
            ipDstAddress = Ip4Address.valueOf((int)((int)portNo));
            subObj = new IPv4SubObject(ipDstAddress.getIp4Address().toInt());
            subObjects.add((PcepValueType)subObj);
        }
        return subObjects;
    }

    private PcepSrpObject getSrpObject(PcepClient pc, PcepLabelOp type, boolean bSFlag) throws PcepParseException {
        boolean bRFlag = false;
        if (!type.equals((Object)PcepLabelOp.ADD)) {
            bRFlag = true;
        }
        PcepSrpObject srpObj = pc.factory().buildSrpObject().setRFlag(bRFlag).setSFlag(bSFlag).setSrpID(SrpIdGenerators.create()).build();
        return srpObj;
    }

    private PcepClient getPcepClient(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        String lsrId = device.annotations().value(LSRID);
        PcepClient pcc = this.clientController.getClient(PccId.pccId((IpAddress)IpAddress.valueOf((String)lsrId)));
        return pcc;
    }
}

