/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcelabelstore;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.incubator.net.resource.label.LabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.pcelabelstore.DefaultLspLocalLabelInfo;
import org.onosproject.pcelabelstore.api.LspLocalLabelInfo;
import org.onosproject.pcelabelstore.api.PceLabelStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedPceLabelStore
implements PceLabelStore {
    private static final String DEVICE_ID_NULL = "Device ID cannot be null";
    private static final String LABEL_RESOURCE_ID_NULL = "Label Resource Id cannot be null";
    private static final String LINK_NULL = "LINK cannot be null";
    private static final String PCECC_TUNNEL_INFO_NULL = "PCECC Tunnel Info cannot be null";
    private static final String TUNNEL_ID_NULL = "Tunnel Id cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<DeviceId, LabelResourceId> globalNodeLabelMap;
    private ConsistentMap<Link, LabelResourceId> adjLabelMap;
    private ConsistentMap<TunnelId, List<LspLocalLabelInfo>> tunnelLabelInfoMap;
    private Map<String, DeviceId> lsrIdDeviceIdMap = new HashMap<String, DeviceId>();
    private HashSet<DeviceId> pendinglabelDbSyncPccMap = new HashSet();

    @Activate
    protected void activate() {
        this.globalNodeLabelMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-pce-globalnodelabelmap")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{LabelResourceId.class}).build()))).build();
        this.adjLabelMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-pce-adjlabelmap")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{Link.class, LabelResource.class, LabelResourceId.class}).build()))).build();
        this.tunnelLabelInfoMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-pce-tunnellabelinfomap")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{TunnelId.class, DefaultLspLocalLabelInfo.class, LabelResourceId.class, DeviceId.class}).build()))).build();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Stopped");
    }

    @Override
    public boolean existsGlobalNodeLabel(DeviceId id) {
        Preconditions.checkNotNull((Object)id, (Object)DEVICE_ID_NULL);
        return this.globalNodeLabelMap.containsKey((Object)id);
    }

    @Override
    public boolean existsAdjLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        return this.adjLabelMap.containsKey((Object)link);
    }

    @Override
    public boolean existsTunnelInfo(TunnelId tunnelId) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNEL_ID_NULL);
        return this.tunnelLabelInfoMap.containsKey((Object)tunnelId);
    }

    @Override
    public int getGlobalNodeLabelCount() {
        return this.globalNodeLabelMap.size();
    }

    @Override
    public int getAdjLabelCount() {
        return this.adjLabelMap.size();
    }

    @Override
    public int getTunnelInfoCount() {
        return this.tunnelLabelInfoMap.size();
    }

    @Override
    public Map<DeviceId, LabelResourceId> getGlobalNodeLabels() {
        return this.globalNodeLabelMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (LabelResourceId)((Versioned)e.getValue()).value()));
    }

    @Override
    public Map<Link, LabelResourceId> getAdjLabels() {
        return this.adjLabelMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (LabelResourceId)((Versioned)e.getValue()).value()));
    }

    @Override
    public Map<TunnelId, List<LspLocalLabelInfo>> getTunnelInfos() {
        return this.tunnelLabelInfoMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (List)((Versioned)e.getValue()).value()));
    }

    @Override
    public LabelResourceId getGlobalNodeLabel(DeviceId id) {
        Preconditions.checkNotNull((Object)id, (Object)DEVICE_ID_NULL);
        return this.globalNodeLabelMap.get((Object)id) == null ? null : (LabelResourceId)this.globalNodeLabelMap.get((Object)id).value();
    }

    @Override
    public LabelResourceId getAdjLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        return this.adjLabelMap.get((Object)link) == null ? null : (LabelResourceId)this.adjLabelMap.get((Object)link).value();
    }

    @Override
    public List<LspLocalLabelInfo> getTunnelInfo(TunnelId tunnelId) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNEL_ID_NULL);
        return this.tunnelLabelInfoMap.get((Object)tunnelId) == null ? null : (List)this.tunnelLabelInfoMap.get((Object)tunnelId).value();
    }

    @Override
    public void addGlobalNodeLabel(DeviceId deviceId, LabelResourceId labelId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)labelId, (Object)LABEL_RESOURCE_ID_NULL);
        this.globalNodeLabelMap.put((Object)deviceId, (Object)labelId);
    }

    @Override
    public void addAdjLabel(Link link, LabelResourceId labelId) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        Preconditions.checkNotNull((Object)labelId, (Object)LABEL_RESOURCE_ID_NULL);
        this.adjLabelMap.put((Object)link, (Object)labelId);
    }

    @Override
    public void addTunnelInfo(TunnelId tunnelId, List<LspLocalLabelInfo> lspLocalLabelInfoList) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNEL_ID_NULL);
        Preconditions.checkNotNull(lspLocalLabelInfoList, (Object)PCECC_TUNNEL_INFO_NULL);
        this.tunnelLabelInfoMap.put((Object)tunnelId, lspLocalLabelInfoList);
    }

    @Override
    public boolean removeGlobalNodeLabel(DeviceId id) {
        Preconditions.checkNotNull((Object)id, (Object)DEVICE_ID_NULL);
        if (this.globalNodeLabelMap.remove((Object)id) == null) {
            this.log.error("SR-TE node label deletion for device {} has failed.", (Object)id.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAdjLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        if (this.adjLabelMap.remove((Object)link) == null) {
            this.log.error("Adjacency label deletion for link {} hash failed.", (Object)link.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeTunnelInfo(TunnelId tunnelId) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNEL_ID_NULL);
        if (this.tunnelLabelInfoMap.remove((Object)tunnelId) == null) {
            this.log.error("Tunnel info deletion for tunnel id {} has failed.", (Object)tunnelId.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean addLsrIdDevice(String lsrId, DeviceId deviceId) {
        Preconditions.checkNotNull((Object)lsrId);
        Preconditions.checkNotNull((Object)deviceId);
        this.lsrIdDeviceIdMap.put(lsrId, deviceId);
        return true;
    }

    @Override
    public boolean removeLsrIdDevice(String lsrId) {
        Preconditions.checkNotNull((Object)lsrId);
        this.lsrIdDeviceIdMap.remove(lsrId);
        return true;
    }

    @Override
    public DeviceId getLsrIdDevice(String lsrId) {
        Preconditions.checkNotNull((Object)lsrId);
        return this.lsrIdDeviceIdMap.get(lsrId);
    }

    @Override
    public boolean addPccLsr(DeviceId lsrId) {
        Preconditions.checkNotNull((Object)lsrId);
        this.pendinglabelDbSyncPccMap.add(lsrId);
        return true;
    }

    @Override
    public boolean removePccLsr(DeviceId lsrId) {
        Preconditions.checkNotNull((Object)lsrId);
        this.pendinglabelDbSyncPccMap.remove(lsrId);
        return true;
    }

    @Override
    public boolean hasPccLsr(DeviceId lsrId) {
        Preconditions.checkNotNull((Object)lsrId);
        return this.pendinglabelDbSyncPccMap.contains(lsrId);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

